/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.BinaryRowSequence;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.TabularData;

class TableBodies {
    TableBodies() {
    }

    static Class[] getClasses(Decoder[] decoders) {
        int ncol = decoders.length;
        Class[] classes = new Class[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            classes[icol] = decoders[icol].getContentClass();
        }
        return classes;
    }

    static class TabledataTabularData
    extends SequentialTabularData {
        final Decoder[] decoders;
        final Element tabledataEl;
        final int ncol;
        Element[] rows;

        TabledataTabularData(Decoder[] decoders, Element tabledataEl) {
            super(TableBodies.getClasses(decoders));
            this.decoders = decoders;
            this.tabledataEl = tabledataEl;
            this.ncol = decoders.length;
        }

        public long getRowCount() {
            if (this.rows == null) {
                long nrow = 0L;
                for (Node node = this.tabledataEl.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !((Element)node).getTagName().equals("TR")) continue;
                    ++nrow;
                }
                return nrow;
            }
            return this.rows.length;
        }

        public boolean isRandom() {
            return true;
        }

        private Element[] getRows() {
            ArrayList<Element> rowList = new ArrayList<Element>();
            if (this.rows == null) {
                Element trEl = TabledataTabularData.firstSibling("TR", this.tabledataEl.getFirstChild());
                while (trEl != null) {
                    rowList.add(trEl);
                    trEl = TabledataTabularData.firstSibling("TR", trEl.getNextSibling());
                }
                this.rows = rowList.toArray(new Element[0]);
            }
            return this.rows;
        }

        public Object[] getRow(long irow) {
            return this.getRow(this.getRows()[(int)irow]);
        }

        public Object getCell(long irow, int icol) {
            Element trEl = this.getRows()[(int)irow];
            int jcol = 0;
            Element tdEl = TabledataTabularData.firstSibling("TD", trEl.getFirstChild());
            while (tdEl != null && icol < this.ncol) {
                if (jcol == icol) {
                    String txt = DOMUtils.getTextContent((Element)tdEl);
                    if (txt != null && txt.length() > 0) {
                        return this.decoders[icol].decodeString(txt);
                    }
                    return null;
                }
                ++jcol;
                tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
            }
            return null;
        }

        public RowSequence getRowSequence() {
            return new RowSequence(){
                Element trEl;
                boolean done;

                public boolean next() {
                    if (this.done) {
                        return false;
                    }
                    Node prev = this.trEl == null ? TabledataTabularData.this.tabledataEl.getFirstChild() : this.trEl.getNextSibling();
                    this.trEl = TabledataTabularData.firstSibling("TR", prev);
                    if (this.trEl == null) {
                        this.done = true;
                    }
                    return !this.done;
                }

                public Object[] getRow() {
                    if (this.trEl == null || this.done) {
                        throw new IllegalStateException();
                    }
                    return TabledataTabularData.this.getRow(this.trEl);
                }

                public Object getCell(int icol) {
                    if (this.trEl == null || this.done) {
                        throw new IllegalStateException();
                    }
                    Element tdEl = TabledataTabularData.firstSibling("TD", this.trEl.getFirstChild());
                    while (icol-- > 0) {
                        tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
                    }
                    if (tdEl == null) {
                        return null;
                    }
                    String txt = DOMUtils.getTextContent((Element)tdEl);
                    return txt == null || txt.length() == 0 ? null : TabledataTabularData.this.decoders[icol].decodeString(txt);
                }

                public void close() {
                    this.trEl = null;
                }
            };
        }

        private Object[] getRow(Element trEl) {
            Object[] row = new Object[this.ncol];
            Element tdEl = TabledataTabularData.firstSibling("TD", trEl.getFirstChild());
            for (int icol = 0; tdEl != null && icol < this.ncol; ++icol) {
                String txt = DOMUtils.getTextContent((Element)tdEl);
                if (txt != null && txt.length() > 0) {
                    row[icol] = this.decoders[icol].decodeString(txt);
                }
                tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
            }
            return row;
        }

        private static Element firstSibling(String tag, Node node) {
            if (node == null) {
                return null;
            }
            if (node instanceof Element && ((Element)node).getTagName().equals(tag)) {
                return (Element)node;
            }
            return TabledataTabularData.firstSibling(tag, node.getNextSibling());
        }
    }

    static class HrefBinaryTabularData
    extends SequentialTabularData {
        private final Decoder[] decoders;
        private final URL url;
        private final String encoding;

        public HrefBinaryTabularData(Decoder[] decoders, URL url, String encoding) {
            super(TableBodies.getClasses(decoders));
            this.decoders = decoders;
            this.url = url;
            this.encoding = encoding;
        }

        public RowSequence getRowSequence() throws IOException {
            BufferedInputStream istrm = new BufferedInputStream(this.url.openStream());
            return new BinaryRowSequence(this.decoders, istrm, this.encoding);
        }
    }

    static class StarTableTabularData
    implements TabularData {
        private final StarTable startab;

        public StarTableTabularData(StarTable startab) {
            this.startab = startab;
        }

        public int getColumnCount() {
            return this.startab.getColumnCount();
        }

        public long getRowCount() {
            return this.startab.getRowCount();
        }

        public Class getContentClass(int icol) {
            return this.startab.getColumnInfo(icol).getContentClass();
        }

        public RowSequence getRowSequence() throws IOException {
            return this.startab.getRowSequence();
        }

        public boolean isRandom() {
            return this.startab.isRandom();
        }

        public Object getCell(long irow, int icol) throws IOException {
            return this.startab.getCell(irow, icol);
        }

        public Object[] getRow(long irow) throws IOException {
            return this.startab.getRow(irow);
        }
    }

    static class EmptyTabularData
    extends SequentialTabularData {
        public EmptyTabularData(Class[] classes) {
            super(classes);
        }

        public long getRowCount() {
            return 0L;
        }

        public RowSequence getRowSequence() {
            return EmptyRowSequence.getInstance();
        }
    }

    static abstract class SequentialTabularData
    implements TabularData {
        final int ncol;
        final Class[] classes;

        public SequentialTabularData(Class[] classes) {
            this.classes = classes;
            this.ncol = classes.length;
        }

        public int getColumnCount() {
            return this.ncol;
        }

        public long getRowCount() {
            return -1L;
        }

        public Class getContentClass(int icol) {
            return this.classes[icol];
        }

        public abstract RowSequence getRowSequence() throws IOException;

        public boolean isRandom() {
            return false;
        }

        public Object getCell(long irow, int icol) {
            throw new UnsupportedOperationException("Not random");
        }

        public Object[] getRow(long irow) {
            throw new UnsupportedOperationException("Not random");
        }
    }
}

