/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import uk.ac.starlink.votable.BooleanDecoder;

class ScalarBooleanDecoder
extends BooleanDecoder {
    ScalarBooleanDecoder() {
        super(Boolean.class, SCALAR_SIZE);
    }

    private Boolean decodeChar(char c) {
        switch (c) {
            case '1': 
            case 'T': 
            case 't': {
                return Boolean.TRUE;
            }
            case '0': 
            case 'F': 
            case 'f': {
                return Boolean.FALSE;
            }
            case '\u0000': 
            case ' ': 
            case '?': {
                return null;
            }
        }
        return null;
    }

    public Object decodeString(String txt) {
        int nchar = txt.length();
        if (nchar == 0) {
            return null;
        }
        if (nchar == 1) {
            return this.decodeChar(txt.charAt(0));
        }
        if (txt.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (txt.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Object decodeStream(DataInput strm) throws IOException {
        return this.decodeChar((char)(0xFF & (char)strm.readByte()));
    }
}

