/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.ColumnStoreStarTable;
import uk.ac.starlink.table.storage.IndexedMappedColumnStore;
import uk.ac.starlink.table.storage.IndexedStreamColumnStore;
import uk.ac.starlink.table.storage.MappedColumnStore;
import uk.ac.starlink.table.storage.StreamColumnStore;

public class SidewaysRowStore
implements RowStore {
    private final File file_;
    private final Set tempFiles_;
    private int ncol_;
    private StarTable template_;
    private long lrow_;
    private ColumnStore[] colStores_;
    private StarTable storedTable_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SidewaysRowStore(File file) throws IOException {
        this.file_ = file;
        this.tempFiles_ = new HashSet();
    }

    public SidewaysRowStore() throws IOException {
        this(File.createTempFile("SidewaysRowStore", ".bin"));
    }

    public void acceptMetadata(StarTable meta) throws TableFormatException {
        try {
            this.doAcceptMetadata(meta);
        }
        catch (TableFormatException e) {
            this.tidy();
            throw e;
        }
        catch (IOException e) {
            this.tidy();
            throw new TableFormatException("I/O trouble during RowStore setup", e);
        }
    }

    private void doAcceptMetadata(StarTable meta) throws IOException {
        if (this.template_ != null) {
            throw new IllegalStateException("Metadata already submitted");
        }
        logger_.info("Storing table data in " + this.file_);
        this.template_ = meta;
        this.ncol_ = meta.getColumnCount();
        Codec[] codecs = new Codec[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnInfo cinfo = meta.getColumnInfo(icol);
            Codec codec = Codec.getCodec(cinfo);
            if (codec == null) {
                throw new TableFormatException("No codec available for " + cinfo);
            }
            codecs[icol] = codec;
        }
        this.colStores_ = new ColumnStore[this.ncol_];
        long nrow = meta.getRowCount();
        if (nrow >= 0L) {
            this.file_.deleteOnExit();
            this.tempFiles_.add(this.file_);
            RandomAccessFile raf = new RandomAccessFile(this.file_, "rw");
            FileChannel chan = raf.getChannel();
            long offset = 0L;
            for (int icol = 0; icol < this.ncol_; ++icol) {
                ColumnStore colStore;
                Codec codec = codecs[icol];
                int itemSize = codec.getItemSize();
                boolean fixedSize = itemSize >= 0;
                long storeSize = nrow * (long)(fixedSize ? itemSize : 8);
                MappedByteBuffer bbuf = chan.map(FileChannel.MapMode.READ_WRITE, offset, storeSize);
                if (fixedSize) {
                    colStore = new MappedColumnStore(codec, bbuf);
                } else {
                    File file = new File(this.file_ + "_" + icol);
                    file.deleteOnExit();
                    this.tempFiles_.add(file);
                    colStore = new IndexedMappedColumnStore(codec, bbuf, file);
                }
                offset += storeSize;
                this.colStores_[icol] = colStore;
            }
            raf.close();
            if (!$assertionsDisabled && chan.isOpen()) {
                throw new AssertionError();
            }
        } else {
            for (int icol = 0; icol < this.ncol_; ++icol) {
                ColumnStore colStore;
                Codec codec = codecs[icol];
                int itemSize = codec.getItemSize();
                boolean fixedSize = itemSize >= 0;
                File dataFile = new File(this.file_ + "_" + icol);
                dataFile.deleteOnExit();
                this.tempFiles_.add(dataFile);
                if (fixedSize) {
                    colStore = new StreamColumnStore(codec, dataFile);
                } else {
                    File indexFile = new File(dataFile + "_ix");
                    indexFile.deleteOnExit();
                    this.tempFiles_.add(indexFile);
                    colStore = new IndexedStreamColumnStore(codec, dataFile, indexFile);
                }
                this.colStores_[icol] = colStore;
            }
        }
    }

    public void acceptRow(Object[] row) throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            this.colStores_[icol].acceptCell(row[icol]);
        }
        ++this.lrow_;
    }

    public void endRows() throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            this.colStores_[icol].endCells();
        }
        this.storedTable_ = new ColumnStoreStarTable(this.template_, this.lrow_, this.colStores_);
    }

    public StarTable getStarTable() {
        if (this.storedTable_ == null) {
            throw new IllegalStateException("endRows not called");
        }
        return this.storedTable_;
    }

    private void tidy() {
        Iterator it = this.tempFiles_.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (!file.exists()) continue;
            if (file.delete()) {
                logger_.info("Deleted temporary file " + file);
                it.remove();
                continue;
            }
            logger_.warning("Failed to delete temporary file " + file);
        }
        if (this.colStores_ != null) {
            for (int icol = 0; icol < this.ncol_; ++icol) {
                ColumnStore cs = this.colStores_[icol];
                if (cs == null) continue;
                cs.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.tidy();
        }
        finally {
            super.finalize();
        }
    }

    static {
        $assertionsDisabled = !SidewaysRowStore.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.table.storage");
    }
}

