/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import [Ljava.lang.String;;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Logger;
import uk.ac.starlink.table.ValueInfo;

abstract class Codec {
    private int warnings_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    Codec() {
    }

    public abstract int encode(Object var1, DataOutput var2) throws IOException;

    public abstract Object decode(DataInput var1) throws IOException;

    abstract int getItemSize();

    public static Codec getCodec(ValueInfo info) {
        Class clazz = info.getContentClass();
        if (clazz == Byte.class) {
            return new FlaggedCodec(new ByteCodec());
        }
        if (clazz == Short.class) {
            return new FlaggedCodec(new ShortCodec());
        }
        if (clazz == Integer.class) {
            return new FlaggedCodec(new IntCodec());
        }
        if (clazz == Long.class) {
            return new FlaggedCodec(new LongCodec());
        }
        if (clazz == Character.class) {
            return new FlaggedCodec(new CharCodec());
        }
        if (clazz == Float.class) {
            return new FloatCodec();
        }
        if (clazz == Double.class) {
            return new DoubleCodec();
        }
        if (clazz == Boolean.class) {
            return new BooleanCodec();
        }
        if (clazz == String.class) {
            int esize = info.getElementSize();
            return esize > 0 ? new FixedStringCodec(esize) : new VariableStringCodec();
        }
        if (clazz == String;.class) {
            return new StringArrayCodec();
        }
        if (clazz.isArray()) {
            int[] shape = info.getShape();
            int nel = 1;
            boolean isFixed = true;
            for (int i = 0; i < shape.length; ++i) {
                nel *= shape[i];
                if (shape[i] > 0) continue;
                isFixed = false;
            }
            Codec1 codec1 = null;
            if (clazz == [B.class) {
                codec1 = new ByteCodec1();
            } else if (clazz == [S.class) {
                codec1 = new ShortCodec1();
            } else if (clazz == [I.class) {
                codec1 = new IntCodec1();
            } else if (clazz == [J.class) {
                codec1 = new LongCodec1();
            } else if (clazz == [C.class) {
                codec1 = new CharCodec1();
            } else if (clazz == [F.class) {
                codec1 = new FloatCodec1();
            } else if (clazz == [D.class) {
                codec1 = new DoubleCodec1();
            } else if (clazz == [Z.class) {
                codec1 = new BooleanCodec1();
            }
            if (codec1 != null) {
                return isFixed ? new FlaggedCodec(new FixedArrayCodec(codec1, nel)) : new VariableArrayCodec(codec1);
            }
        }
        logger_.info("No codec available for class " + clazz.getName());
        return null;
    }

    protected void warnCorrupt() {
        if (++this.warnings_ <= 3) {
            logger_.warning("Unexpected stream data - table raw data stream is probably corrupt");
            if (this.warnings_ == 3) {
                logger_.warning("... more");
            }
        }
    }

    private static class BooleanCodec1
    extends Codec1 {
        private BooleanCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeByte(((boolean[])array)[index] ? 84 : 70);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            boolean bval;
            switch (in.readByte()) {
                case 84: {
                    bval = true;
                    break;
                }
                case 70: {
                    bval = false;
                    break;
                }
                default: {
                    bval = false;
                    this.warnCorrupt();
                }
            }
            ((boolean[])array)[index] = bval;
        }

        public int getItemSize1() {
            return 1;
        }

        public Object getBuffer(int size) {
            return new boolean[size];
        }
    }

    private static class CharCodec1
    extends Codec1 {
        private CharCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeChar(((char[])array)[index]);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            ((char[])array)[index] = in.readChar();
        }

        public int getItemSize1() {
            return 2;
        }

        public Object getBuffer(int size) {
            return new char[size];
        }
    }

    private static class DoubleCodec1
    extends Codec1 {
        private DoubleCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeDouble(((double[])array)[index]);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            ((double[])array)[index] = in.readDouble();
        }

        public int getItemSize1() {
            return 8;
        }

        public Object getBuffer(int size) {
            return new double[size];
        }
    }

    private static class FloatCodec1
    extends Codec1 {
        private FloatCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeFloat(((float[])array)[index]);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            ((float[])array)[index] = in.readFloat();
        }

        public int getItemSize1() {
            return 4;
        }

        public Object getBuffer(int size) {
            return new float[size];
        }
    }

    private static class LongCodec1
    extends Codec1 {
        private LongCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeLong(((long[])array)[index]);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            ((long[])array)[index] = in.readLong();
        }

        public int getItemSize1() {
            return 8;
        }

        public Object getBuffer(int size) {
            return new long[size];
        }
    }

    private static class IntCodec1
    extends Codec1 {
        private IntCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeInt(((int[])array)[index]);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            ((int[])array)[index] = in.readInt();
        }

        public int getItemSize1() {
            return 4;
        }

        public Object getBuffer(int size) {
            return new int[size];
        }
    }

    private static class ShortCodec1
    extends Codec1 {
        private ShortCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeShort(((short[])array)[index]);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            ((short[])array)[index] = in.readShort();
        }

        public int getItemSize1() {
            return 2;
        }

        public Object getBuffer(int size) {
            return new short[size];
        }
    }

    private static class ByteCodec1
    extends Codec1 {
        private ByteCodec1() {
        }

        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeByte(((byte[])array)[index]);
        }

        public void decode1(Object array, int index, DataInput in) throws IOException {
            ((byte[])array)[index] = in.readByte();
        }

        public int getItemSize1() {
            return 1;
        }

        public Object getBuffer(int size) {
            return new byte[size];
        }
    }

    private static abstract class Codec1 {
        private int warnings_;

        private Codec1() {
        }

        abstract void encode1(Object var1, int var2, DataOutput var3) throws IOException;

        abstract void decode1(Object var1, int var2, DataInput var3) throws IOException;

        abstract Object getBuffer(int var1);

        abstract int getItemSize1();

        protected void warnCorrupt() {
            if (++this.warnings_ <= 3) {
                logger_.warning("Unexpected stream data - table raw data stream is probably corrupt");
                if (this.warnings_ == 3) {
                    logger_.warning("... more");
                }
            }
        }
    }

    private static class StringArrayCodec
    extends Codec {
        private StringArrayCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            int count = 0;
            String[] strings = value == null ? new String[]{} : (String[])value;
            int nstr = strings.length;
            out.writeInt(nstr);
            count += 4;
            for (int is = 0; is < nstr; ++is) {
                String str = strings[is] == null ? "" : strings[is];
                int leng = str.length();
                out.writeInt(leng);
                count += 4;
                for (int ic = 0; ic < leng; ++ic) {
                    out.writeChar(str.charAt(ic));
                    count += 2;
                }
            }
            return count;
        }

        public Object decode(DataInput in) throws IOException {
            int nstr = in.readInt();
            if (nstr < 0) {
                this.warnCorrupt();
                return null;
            }
            String[] strings = new String[nstr];
            for (int is = 0; is < nstr; ++is) {
                int leng = in.readInt();
                if (leng < 0) {
                    this.warnCorrupt();
                    return null;
                }
                if (leng == 0) {
                    strings[is] = null;
                    continue;
                }
                char[] chrs = new char[leng];
                for (int ic = 0; ic < leng; ++ic) {
                    chrs[ic] = in.readChar();
                }
                strings[is] = new String(chrs);
            }
            return strings;
        }

        public int getItemSize() {
            return -1;
        }
    }

    private static class VariableStringCodec
    extends VariableArrayCodec {
        VariableStringCodec() {
            super(new CharCodec1());
        }

        public int encode(Object value, DataOutput out) throws IOException {
            char[] cval = value == null ? null : ((String)value).toCharArray();
            return super.encode(cval, out);
        }

        public Object decode(DataInput in) throws IOException {
            char[] cval = (char[])super.decode(in);
            return cval == null ? null : new String(cval);
        }
    }

    private static class FixedStringCodec
    extends Codec {
        final int nchar_;
        final char[] cbuf_;

        FixedStringCodec(int nchar) {
            this.nchar_ = nchar;
            this.cbuf_ = new char[this.nchar_];
        }

        public int encode(Object value, DataOutput out) throws IOException {
            int ic;
            String sval = (String)value;
            if (sval != null) {
                int leng = sval.length();
                for (ic = 0; ic < this.nchar_ && ic < leng; ++ic) {
                    out.writeChar(sval.charAt(ic));
                }
            }
            while (ic < this.nchar_) {
                out.writeChar(0);
                ++ic;
            }
            return this.nchar_ * 2;
        }

        public Object decode(DataInput in) throws IOException {
            int lastNonZero = -1;
            for (int ic = 0; ic < this.nchar_; ++ic) {
                char c = in.readChar();
                if (c != '\u0000') {
                    lastNonZero = ic;
                }
                this.cbuf_[ic] = c;
            }
            return lastNonZero < 0 ? null : new String(this.cbuf_, 0, lastNonZero + 1);
        }

        public int getItemSize() {
            return this.nchar_ * 2;
        }
    }

    private static class VariableArrayCodec
    extends Codec {
        final Codec1 codec1_;

        VariableArrayCodec(Codec1 codec1) {
            this.codec1_ = codec1;
        }

        public int encode(Object value, DataOutput out) throws IOException {
            int nel = value == null ? 0 : Array.getLength(value);
            out.writeInt(nel);
            for (int i = 0; i < nel; ++i) {
                this.codec1_.encode1(value, i, out);
            }
            return 4 + nel * this.codec1_.getItemSize1();
        }

        public Object decode(DataInput in) throws IOException {
            int nel = in.readInt();
            if (nel < 0) {
                this.warnCorrupt();
                return null;
            }
            if (nel == 0) {
                return null;
            }
            Object value = this.codec1_.getBuffer(nel);
            for (int i = 0; i < nel; ++i) {
                this.codec1_.decode1(value, i, in);
            }
            return value;
        }

        public int getItemSize() {
            return -1;
        }
    }

    private static class FixedArrayCodec
    extends Codec {
        final int nel_;
        final Codec1 codec1_;
        final int itemSize_;

        FixedArrayCodec(Codec1 codec1, int nel) {
            this.codec1_ = codec1;
            this.nel_ = nel;
            this.itemSize_ = nel * codec1.getItemSize1();
        }

        public int encode(Object value, DataOutput out) throws IOException {
            for (int i = 0; i < this.nel_; ++i) {
                this.codec1_.encode1(value, i, out);
            }
            return this.itemSize_;
        }

        public Object decode(DataInput in) throws IOException {
            Object value = this.codec1_.getBuffer(this.nel_);
            for (int i = 0; i < this.nel_; ++i) {
                this.codec1_.decode1(value, i, in);
            }
            return value;
        }

        public int getItemSize() {
            return this.itemSize_;
        }
    }

    private static class FlaggedCodec
    extends Codec {
        Codec baseCodec_;
        int itemSize_;
        byte[] nullBuffer_;
        static final byte BAD = -1;
        static final byte OK = 0;

        FlaggedCodec(Codec baseCodec) {
            this.baseCodec_ = baseCodec;
            this.itemSize_ = baseCodec.getItemSize() + 1;
            this.nullBuffer_ = new byte[this.itemSize_];
            this.nullBuffer_[0] = -1;
        }

        public int encode(Object value, DataOutput out) throws IOException {
            if (value == null) {
                out.write(this.nullBuffer_);
            } else {
                out.write(0);
                this.baseCodec_.encode(value, out);
            }
            return this.itemSize_;
        }

        public Object decode(DataInput in) throws IOException {
            byte flag = in.readByte();
            switch (flag) {
                case 0: {
                    return this.baseCodec_.decode(in);
                }
                case -1: {
                    in.skipBytes(this.itemSize_ - 1);
                    return null;
                }
            }
            this.warnCorrupt();
            return null;
        }

        public int getItemSize() {
            return this.itemSize_;
        }
    }

    private static class BooleanCodec
    extends Codec {
        private BooleanCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            int brep = value == null ? 32 : ((Boolean)value != false ? 84 : 70);
            out.writeByte(brep);
            return 1;
        }

        public Object decode(DataInput in) throws IOException {
            switch (in.readByte()) {
                case 84: {
                    return Boolean.TRUE;
                }
                case 70: {
                    return Boolean.FALSE;
                }
                case 32: {
                    return null;
                }
            }
            this.warnCorrupt();
            return null;
        }

        public int getItemSize() {
            return 1;
        }
    }

    private static class DoubleCodec
    extends Codec {
        private DoubleCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            out.writeDouble(value == null ? Double.NaN : (Double)value);
            return 8;
        }

        public Object decode(DataInput in) throws IOException {
            return new Double(in.readDouble());
        }

        public int getItemSize() {
            return 8;
        }
    }

    private static class FloatCodec
    extends Codec {
        private FloatCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            out.writeFloat(value == null ? Float.NaN : ((Float)value).floatValue());
            return 4;
        }

        public Object decode(DataInput in) throws IOException {
            return new Float(in.readFloat());
        }

        public int getItemSize() {
            return 4;
        }
    }

    private static class CharCodec
    extends Codec {
        private CharCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            out.writeChar(((Character)value).charValue());
            return 2;
        }

        public Object decode(DataInput in) throws IOException {
            return new Character(in.readChar());
        }

        public int getItemSize() {
            return 2;
        }
    }

    private static class LongCodec
    extends Codec {
        private LongCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            out.writeLong((Long)value);
            return 8;
        }

        public Object decode(DataInput in) throws IOException {
            return new Long(in.readLong());
        }

        public int getItemSize() {
            return 8;
        }
    }

    private static class IntCodec
    extends Codec {
        private IntCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            out.writeInt((Integer)value);
            return 4;
        }

        public Object decode(DataInput in) throws IOException {
            return new Integer(in.readInt());
        }

        public int getItemSize() {
            return 4;
        }
    }

    private static class ShortCodec
    extends Codec {
        private ShortCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            out.writeShort(((Short)value).shortValue());
            return 2;
        }

        public Object decode(DataInput in) throws IOException {
            return new Short(in.readShort());
        }

        public int getItemSize() {
            return 2;
        }
    }

    private static class ByteCodec
    extends Codec {
        private ByteCodec() {
        }

        public int encode(Object value, DataOutput out) throws IOException {
            out.writeByte(((Byte)value).byteValue());
            return 1;
        }

        public Object decode(DataInput in) throws IOException {
            return new Byte(in.readByte());
        }

        public int getItemSize() {
            return 1;
        }
    }
}

