/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.IsotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.MatchEngine;

public class SphericalPolarMatchEngine
implements MatchEngine {
    private Double[] work0_ = new Double[3];
    private Double[] work1_ = new Double[3];
    private Double[] work2_ = new Double[3];
    private final IsotropicCartesianMatchEngine spaceEngine_;
    private static final DefaultValueInfo R_INFO = new DefaultValueInfo("Distance", Number.class, "Distance along the line of sight");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Cartesian distance between matched points");

    public SphericalPolarMatchEngine(double err) {
        this.spaceEngine_ = new IsotropicCartesianMatchEngine(3, err, false);
        ((DefaultValueInfo)this.spaceEngine_.errorParam_.getInfo()).setUnitString("Units of distance");
    }

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        SphericalPolarMatchEngine.polarToCartesian(tuple1, this.work1_);
        SphericalPolarMatchEngine.polarToCartesian(tuple2, this.work2_);
        return this.spaceEngine_.matchScore(this.work1_, this.work2_);
    }

    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    public Object[] getBins(Object[] tuple) {
        if (tuple[0] instanceof Number && tuple[1] instanceof Number && tuple[2] instanceof Number) {
            SphericalPolarMatchEngine.polarToCartesian(tuple, this.work0_);
            return this.spaceEngine_.getBins(this.work0_);
        }
        return NO_BINS;
    }

    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO, R_INFO};
    }

    public DescribedValue[] getMatchParameters() {
        return this.spaceEngine_.getMatchParameters();
    }

    public boolean canBoundMatch() {
        return false;
    }

    public Comparable[][] getMatchBounds(Comparable[] min, Comparable[] max) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Sky 3D";
    }

    private static void polarToCartesian(Object[] polar, Object[] cartesian) {
        double ra = ((Number)polar[0]).doubleValue();
        double dec = ((Number)polar[1]).doubleValue();
        double r = ((Number)polar[2]).doubleValue();
        double cd = Math.cos(dec);
        double sd = Math.sin(dec);
        double cr = Math.cos(ra);
        double sr = Math.sin(ra);
        double x = r * cr * cd;
        double y = r * sr * cd;
        double z = r * sd;
        cartesian[0] = new Double(x);
        cartesian[1] = new Double(y);
        cartesian[2] = new Double(z);
    }

    static {
        R_INFO.setNullable(false);
    }
}

