/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;

class Range {
    private final int ndim_;
    private final Comparable[] mins_;
    private final Comparable[] maxs_;
    private final boolean isBounded_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Range(Comparable[] mins, Comparable[] maxs) {
        this.mins_ = (Comparable[])mins.clone();
        this.maxs_ = (Comparable[])maxs.clone();
        this.ndim_ = mins.length;
        if (this.ndim_ != maxs.length) {
            throw new IllegalArgumentException("Array length mismatch");
        }
        boolean isBounded = false;
        for (int i = 0; i < this.ndim_; ++i) {
            Comparable min = this.mins_[i];
            Comparable max = this.maxs_[i];
            boolean hasMin = min != null;
            boolean hasMax = max != null;
            boolean bl = isBounded = isBounded || hasMin || hasMax;
            if (!hasMin || !hasMax || Range.compare(min, max) <= 0) continue;
            throw new IllegalArgumentException("Boundary limits error: " + min + " > " + max);
        }
        this.isBounded_ = isBounded;
    }

    public Range(int ndim) {
        this(new Comparable[ndim], new Comparable[ndim]);
        if (!$assertionsDisabled && this.isBounded()) {
            throw new AssertionError();
        }
    }

    public boolean isBounded() {
        return this.isBounded_;
    }

    public boolean isInside(Object[] coords) {
        if (this.isBounded_) {
            for (int i = 0; i < this.ndim_; ++i) {
                if (!(coords[i] instanceof Comparable)) continue;
                Comparable coord = (Comparable)coords[i];
                Comparable min = this.mins_[i];
                if (min != null && Range.compare(coord, min) < 0) {
                    return false;
                }
                Comparable max = this.maxs_[i];
                if (max == null || Range.compare(coord, max) <= 0) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof Range) {
            Range other = (Range)o;
            return Arrays.equals(this.mins_, other.mins_) && Arrays.equals(this.maxs_, other.maxs_);
        }
        return false;
    }

    public int hashCode() {
        int code = 23;
        code = 37 * code + ((Object)Arrays.asList(this.mins_)).hashCode();
        code = 37 * code + ((Object)Arrays.asList(this.maxs_)).hashCode();
        return code;
    }

    public String toString() {
        if (this.isBounded()) {
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < this.ndim_; ++i) {
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(this.mins_[i] == null ? "" : Range.formatObject(this.mins_[i]));
                sbuf.append(" .. ");
                sbuf.append(this.maxs_[i] == null ? "" : Range.formatObject(this.maxs_[i]));
            }
            return sbuf.toString();
        }
        return "(unbounded)";
    }

    public static Range intersection(Range r1, Range r2) {
        int i;
        if (r1.ndim_ != r2.ndim_) {
            throw new IllegalArgumentException("Dimensionality mismatch");
        }
        int ndim = r1.ndim_;
        Comparable[] mins = new Comparable[ndim];
        Comparable[] maxs = new Comparable[ndim];
        for (i = 0; i < ndim; ++i) {
            mins[i] = Range.max(r1.mins_[i], r2.mins_[i], false);
            maxs[i] = Range.min(r1.maxs_[i], r2.maxs_[i], false);
        }
        for (i = 0; i < ndim; ++i) {
            if (mins[i] == null || maxs[i] == null || Range.compare(mins[i], maxs[i]) <= 0) continue;
            return null;
        }
        return new Range(mins, maxs);
    }

    public static Range union(Range r1, Range r2) {
        if (r1.ndim_ != r2.ndim_) {
            throw new IllegalArgumentException("Dimensionality mismatch");
        }
        int ndim = r1.ndim_;
        Comparable[] mins = new Comparable[ndim];
        Comparable[] maxs = new Comparable[ndim];
        for (int i = 0; i < ndim; ++i) {
            mins[i] = Range.min(r1.mins_[i], r2.mins_[i], true);
            maxs[i] = Range.max(r1.maxs_[i], r2.maxs_[i], true);
        }
        return new Range(mins, maxs);
    }

    public static Comparable min(Comparable c1, Comparable c2, boolean failNull) {
        if (c1 == null) {
            return failNull ? null : c2;
        }
        if (c2 == null) {
            return failNull ? null : c1;
        }
        return Range.compare(c1, c2) < 0 ? c1 : c2;
    }

    public static Comparable max(Comparable c1, Comparable c2, boolean failNull) {
        if (c1 == null) {
            return failNull ? null : c2;
        }
        if (c2 == null) {
            return failNull ? null : c1;
        }
        return Range.compare(c1, c2) > 0 ? c1 : c2;
    }

    private static int compare(Comparable o1, Comparable o2) {
        try {
            return o1.compareTo(o2);
        }
        catch (ClassCastException e) {
            if (o1 instanceof Number && o2 instanceof Number) {
                return Double.compare(((Number)((Object)o1)).doubleValue(), ((Number)((Object)o2)).doubleValue());
            }
            throw e;
        }
    }

    private static String formatObject(Comparable c) {
        if (c == null) {
            return "null";
        }
        if (c instanceof Double) {
            return Float.toString(((Number)((Object)c)).floatValue());
        }
        return c.toString();
    }

    static {
        $assertionsDisabled = !Range.class.desiredAssertionStatus();
    }
}

