/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import uk.ac.starlink.table.join.ListStore;

public class ListStores {
    private ListStores() {
    }

    public static ListStore createListStore() {
        return new CombinationListStore();
    }

    public static ListStore createModifiableListStore() {
        return new LinkedListListStore();
    }

    private static class StorageList
    extends LinkedList {
        private StorageList() {
        }
    }

    private static class LinkedListListStore
    implements ListStore {
        private LinkedListListStore() {
        }

        public List getList(Object value) {
            return (List)value;
        }

        public Object addItem(Object value, Object item) {
            List<Object> list = value == null ? new LinkedList() : (List)value;
            list.add(item);
            return list;
        }
    }

    private static class CombinationListStore
    implements ListStore {
        private CombinationListStore() {
        }

        public List getList(Object value) {
            if (value == null) {
                return Collections.EMPTY_LIST;
            }
            if (value instanceof StorageList) {
                return (List)value;
            }
            return Collections.singletonList(value);
        }

        public Object addItem(Object value, Object item) {
            if (item instanceof StorageList) {
                throw new IllegalArgumentException("Can't mix keys with values!");
            }
            if (value == null) {
                return item;
            }
            if (value instanceof StorageList) {
                ((List)value).add(item);
                return value;
            }
            StorageList list = new StorageList();
            list.add(value);
            list.add(item);
            return list;
        }
    }
}

