/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.lang.reflect.Array;
import java.util.Arrays;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;

public class EqualsMatchEngine
implements MatchEngine {
    static final /* synthetic */ boolean $assertionsDisabled;

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        return EqualsMatchEngine.isEqual(tuple1[0], tuple2[0]) ? 0.0 : -1.0;
    }

    public Object[] getBins(Object[] tuple) {
        Object[] objectArray;
        Object obj = tuple[0];
        if (Tables.isBlank(obj)) {
            objectArray = NO_BINS;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new Integer(EqualsMatchEngine.getHash(obj));
        }
        return objectArray;
    }

    public ValueInfo getMatchScoreInfo() {
        return null;
    }

    public ValueInfo[] getTupleInfos() {
        DefaultValueInfo vinfo = new DefaultValueInfo("Matched Value", Object.class, "Value for exact match");
        vinfo.setNullable(false);
        return new ValueInfo[]{vinfo};
    }

    public DescribedValue[] getMatchParameters() {
        return new DescribedValue[0];
    }

    public boolean canBoundMatch() {
        return true;
    }

    public Comparable[][] getMatchBounds(Comparable[] min, Comparable[] max) {
        return new Comparable[][]{min, max};
    }

    public String toString() {
        return "Exact Value";
    }

    private static boolean isEqual(Object o1, Object o2) {
        if (Tables.isBlank(o1) || Tables.isBlank(o2)) {
            return false;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            Class<?> clazz = o1.getClass().getComponentType();
            if (clazz == Byte.TYPE) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (clazz == Short.TYPE) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
            if (clazz == Integer.TYPE) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (clazz == Long.TYPE) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (clazz == Float.TYPE) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (clazz == Double.TYPE) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
            if (clazz == Boolean.TYPE) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (clazz == Character.TYPE) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            if (!$assertionsDisabled && !Object.class.isAssignableFrom(clazz)) {
                throw new AssertionError();
            }
            Object[] a1 = (Object[])o1;
            int n1 = a1.length;
            Object[] a2 = (Object[])o2;
            int n2 = a2.length;
            if (n1 != n2) {
                return false;
            }
            for (int i = 0; i < n1; ++i) {
                if (EqualsMatchEngine.isEqual(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    private static int getHash(Object obj) {
        if (Tables.isBlank(obj)) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            int leng = Array.getLength(obj);
            int hash = 17;
            for (int i = 0; i < leng; ++i) {
                hash = 23 * hash + EqualsMatchEngine.getHash(Array.get(obj, i));
            }
            return hash;
        }
        return obj.hashCode();
    }

    static {
        $assertionsDisabled = !EqualsMatchEngine.class.desiredAssertionStatus();
    }
}

