/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.ListStore;
import uk.ac.starlink.table.join.ListStores;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

public class BinContents {
    private final Map map_;
    private final ListStore listStore_;
    private final ProgressIndicator indicator_;
    private long nrow_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BinContents(ProgressIndicator indicator) {
        this.indicator_ = indicator;
        this.map_ = new HashMap();
        this.listStore_ = ListStores.createListStore();
    }

    public void putRowInBin(Object key, RowRef row) {
        ++this.nrow_;
        this.map_.put(key, this.listStore_.addItem(this.map_.get(key), row));
    }

    public boolean containsKey(Object key) {
        return this.map_.containsKey(key);
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public void addRowLinks(LinkSet links) throws InterruptedException {
        this.indicator_.logMessage(this.nrow_ + " row refs in " + this.map_.size() + " bins");
        this.indicator_.logMessage("(average bin occupancy " + (float)this.nrow_ / (float)this.map_.size() + ")");
        this.indicator_.startStage("Consolidating potential match groups");
        double nl = this.map_.size();
        int il = 0;
        Iterator it = this.map_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List refList = this.listStore_.getList(entry.getValue());
            if (refList.size() > 1) {
                links.addLink(new RowLink(refList));
            }
            it.remove();
            this.indicator_.setLevel((double)(++il) / nl);
        }
        if (!$assertionsDisabled && !this.map_.isEmpty()) {
            throw new AssertionError();
        }
        this.nrow_ = 0L;
        this.indicator_.endStage();
    }

    static {
        $assertionsDisabled = !BinContents.class.desiredAssertionStatus();
    }
}

