/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JDBCUtils {
    private static final Pattern POSTGRESQL_DRIVER_REGEX;
    private static final Pattern MYSQL_DRIVER_REGEX;
    private static final Pattern SQLSERVER_DRIVER_REGEX;
    private static Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    private JDBCUtils() {
    }

    public static Statement createStreamingStatement(Connection conn, boolean update) throws SQLException {
        int concurrency = update ? 1008 : 1007;
        DatabaseMetaData metadata = conn.getMetaData();
        String driver = metadata.getDriverName();
        if (driver == null) {
            driver = "";
        }
        if (POSTGRESQL_DRIVER_REGEX.matcher(driver).matches()) {
            logger_.info("Fixing PostgreSQL driver to stream results");
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement(1003, concurrency);
            stmt.setFetchSize(1024);
            return stmt;
        }
        if (MYSQL_DRIVER_REGEX.matcher(driver).matches()) {
            logger_.info("Fixing MySQL driver to stream results");
            Statement stmt = conn.createStatement(1003, concurrency);
            stmt.setFetchSize(Integer.MIN_VALUE);
            return stmt;
        }
        if (SQLSERVER_DRIVER_REGEX.matcher(driver).matches()) {
            logger_.info("Fixing SQL Server driver to stream results");
            try {
                int cursorType = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerResultSet").getField("TYPE_SS_SERVER_CURSOR_FORWARD_ONLY").getInt(null);
                if (!$assertionsDisabled && cursorType != 2004) {
                    throw new AssertionError();
                }
                return conn.createStatement(cursorType, concurrency);
            }
            catch (Throwable e) {
                logger_.warning("SQL Server tweaking failed: " + e);
                return conn.createStatement(1003, concurrency);
            }
        }
        logger_.info("No special steps to stream results - may run out of memory for large ResultSet?");
        return conn.createStatement(1003, concurrency);
    }

    static {
        $assertionsDisabled = !JDBCUtils.class.desiredAssertionStatus();
        POSTGRESQL_DRIVER_REGEX = Pattern.compile(".*PostgreSQL.*", 2);
        MYSQL_DRIVER_REGEX = Pattern.compile(".*MySQL.*", 2);
        SQLSERVER_DRIVER_REGEX = Pattern.compile(".*SQL.?Server.*", 2);
        logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");
    }
}

