/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.gui.StarJTable;

public class TableRowHeader
extends JTable {
    private JTable masterTable;
    private AbstractTableModel rowModel;
    private TableModel masterModel;
    private TableModelListener listener;

    public TableRowHeader(JTable table) {
        this.masterTable = table;
        this.masterModel = this.masterTable.getModel();
        this.rowModel = new AbstractTableModel(){

            public int getRowCount() {
                return TableRowHeader.this.masterTable.getRowCount();
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int irow, int icol) {
                return new Integer(TableRowHeader.this.rowNumber(irow)) + "  ";
            }
        };
        this.setModel(this.rowModel);
        this.setSelectionModel(this.masterTable.getSelectionModel());
        this.listener = new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                TableModel mmodel = TableRowHeader.this.masterTable.getModel();
                if (mmodel != TableRowHeader.this.masterModel) {
                    TableRowHeader.this.masterModel.removeTableModelListener(this);
                    TableRowHeader.this.masterModel = mmodel;
                    TableRowHeader.this.masterModel.addTableModelListener(this);
                }
                TableRowHeader.this.rowModel.fireTableDataChanged();
            }
        };
        this.masterModel.addTableModelListener(this.listener);
        this.setTableHeader(null);
        this.setAutoResizeMode(0);
        this.setPreferredScrollableViewportSize(this.masterTable.getPreferredSize());
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        DefaultTableCellRenderer rend = (DefaultTableCellRenderer)new JTableHeader().getDefaultRenderer();
        rend.setFont(UIManager.getFont("TableHeader.font"));
        rend.setBackground(UIManager.getColor("TableHeader.background"));
        rend.setForeground(UIManager.getColor("TableHeader.foreground"));
        rend.setHorizontalAlignment(4);
        TableColumn col = new TableColumn(0, 64, rend, null){

            public int getPreferredWidth() {
                TableRowHeader tab = TableRowHeader.this;
                int nrow = TableRowHeader.this.masterTable.getRowCount();
                if (nrow > 0) {
                    int first = StarJTable.getCellWidth(tab, 0, 0);
                    int last = StarJTable.getCellWidth(tab, nrow - 1, 0);
                    int guess = tab.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)tab, (Object)new StringBuffer().append((Object)new Integer((int)(nrow + 1))).append((String)"  ").toString(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                    return 8 + Math.max(Math.max(first, last), guess);
                }
                return 64;
            }
        };
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        tcm.addColumn(col);
        this.setColumnModel(tcm);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void modelChanged() {
        this.listener.tableChanged(null);
    }

    public int rowNumber(int irow) {
        return irow + 1;
    }
}

