/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.StarTableModel;

public class StarJTable
extends JTable {
    private boolean rowHeader;
    private StarTable startable;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.gui");
    private static final int MIN_WIDTH = 50;
    private static final long MAX_CONFIG_TIME = 8000L;

    public StarJTable(boolean rowHeader) {
        this.rowHeader = rowHeader;
    }

    public StarJTable(StarTable startable, boolean rowHeader) {
        this(rowHeader);
        this.setStarTable(startable, rowHeader);
    }

    public boolean hasRowHeader() {
        return this.rowHeader;
    }

    public void setStarTable(StarTable startable, boolean rowHeader) {
        this.setModel(new StarTableModel(startable, rowHeader));
        this.startable = startable;
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        int jcol = 0;
        if (rowHeader) {
            ColumnInfo rhColInfo = new ColumnInfo(new DefaultValueInfo("Index", Integer.class, "Row index"));
            StarTableColumn rhcol = new StarTableColumn(rhColInfo, jcol++);
            rhcol.setCellRenderer(StarJTable.getRowHeaderRenderer());
            tcm.addColumn(rhcol);
        }
        for (int icol = 0; icol < startable.getColumnCount(); ++icol) {
            ColumnInfo cinfo = startable.getColumnInfo(icol);
            StarTableColumn tcol = new StarTableColumn(cinfo, jcol++);
            tcm.addColumn(tcol);
        }
        this.setColumnModel(tcm);
    }

    public StarTable getStarTable() {
        return this.startable;
    }

    public void configureColumnWidths(int maxpix, int nrows) {
        StarJTable.configureColumnWidths(this, maxpix, nrows);
        if (this.rowHeader) {
            int hwidth = Math.max(StarJTable.getCellWidth(this, 0, 0), StarJTable.getCellWidth(this, this.getRowCount() - 1, 0)) + 8;
            this.getColumnModel().getColumn(0).setPreferredWidth(hwidth);
        }
    }

    public static void configureColumnWidths(JTable table, int maxpix, int rowSample) {
        int w;
        int icol;
        int ncol = table.getColumnCount();
        int[] widths = new int[ncol];
        for (int icol2 = 0; icol2 < ncol; ++icol2) {
            widths[icol2] = StarJTable.getHeaderWidth(table, icol2);
        }
        Iterator it = StarJTable.sampleIterator(table.getRowCount(), rowSample, 8000L);
        while (it.hasNext()) {
            int irow = (Integer)it.next();
            for (icol = 0; icol < ncol; ++icol) {
                if (widths[icol] >= maxpix || (w = StarJTable.getCellWidth(table, irow, icol)) <= widths[icol]) continue;
                widths[icol] = Math.min(w, maxpix);
            }
        }
        TableColumnModel tcm = table.getColumnModel();
        int wtot = 0;
        for (icol = 0; icol < ncol; ++icol) {
            w = Math.max(widths[icol] + 8, 50);
            wtot += w;
            tcm.getColumn(icol).setPreferredWidth(w);
        }
        Container holder = table.getParent();
        table.setAutoResizeMode(holder != null && wtot <= holder.getSize().width ? 4 : 0);
    }

    public static void configureColumnWidth(JTable table, int maxpix, int rowSample, int icol) {
        int width = Math.min(StarJTable.getColumnWidth(table, icol, rowSample), maxpix);
        table.getColumnModel().getColumn(icol).setPreferredWidth(width);
    }

    private static int getColumnWidth(JTable table, int icol, int rowSample) {
        int width = StarJTable.getHeaderWidth(table, icol);
        Iterator it = StarJTable.sampleIterator(table.getRowCount(), rowSample, 8000L);
        while (it.hasNext()) {
            int irow = (Integer)it.next();
            int w = StarJTable.getCellWidth(table, irow, icol);
            width = Math.max(w, width);
        }
        return Math.max(width + 10, 50);
    }

    private static int getHeaderWidth(JTable jtab, int icol) {
        TableCellRenderer headRend = jtab.getColumnModel().getColumn(icol).getHeaderRenderer();
        if (headRend == null) {
            headRend = jtab.getTableHeader().getDefaultRenderer();
        }
        String headObj = jtab.getColumnName(icol);
        Component headComp = headRend.getTableCellRendererComponent(jtab, headObj, false, false, 0, icol);
        int width = headComp.getPreferredSize().width;
        return Math.max(50, width);
    }

    public static int getCellWidth(JTable jtab, int irow, int icol) {
        TableCellRenderer rend = jtab.getCellRenderer(irow, icol);
        Object value = jtab.getValueAt(irow, icol);
        Component comp = rend.getTableCellRendererComponent(jtab, value, false, false, irow, icol);
        return comp.getPreferredSize().width;
    }

    private static TableCellRenderer getRowHeaderRenderer() {
        DefaultTableCellRenderer rend = new DefaultTableCellRenderer();
        rend.setFont(UIManager.getFont("TableHeader.font"));
        rend.setBackground(UIManager.getColor("TableHeader.background"));
        rend.setForeground(UIManager.getColor("TableHeader.foreground"));
        rend.setHorizontalAlignment(4);
        return rend;
    }

    private static Iterator sampleIterator(final int nrow, final int nsample, final long maxTime) {
        if (nsample >= nrow) {
            return new Iterator(){
                int irow = 0;

                public boolean hasNext() {
                    return this.irow < nrow;
                }

                public Object next() {
                    return new Integer(this.irow++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator(){
            final int NS4;
            final int NS2;
            final int NR4;
            int iseg_;
            int isamp4_;
            long segStart_;
            int next_;
            {
                this.NS4 = nsample / 4;
                this.NS2 = nsample / 2;
                this.NR4 = nrow / 4;
                this.iseg_ = 0;
                this.isamp4_ = 0;
                this.segStart_ = System.currentTimeMillis();
                this.next_ = this.nextInt();
            }

            public boolean hasNext() {
                return this.next_ >= 0;
            }

            public Object next() {
                if (this.next_ >= 0) {
                    Integer nobj = new Integer(this.next_);
                    this.next_ = this.nextInt();
                    return nobj;
                }
                throw new IllegalStateException();
            }

            private int nextInt() {
                long now = System.currentTimeMillis();
                if (this.isamp4_ >= this.NS4 || now - this.segStart_ > maxTime / 4L) {
                    this.segStart_ = now;
                    this.isamp4_ = 0;
                    ++this.iseg_;
                }
                int is4 = this.isamp4_++;
                switch (this.iseg_) {
                    case 0: {
                        return is4;
                    }
                    case 1: {
                        return is4 / this.NS4 * this.NR4 + this.NR4;
                    }
                    case 2: {
                        return is4 / this.NS4 * this.NR4 + this.NR4 * 2;
                    }
                    case 3: {
                        return nrow - 1 - is4;
                    }
                }
                return -1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

