/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.TableFormatException;

public class RowEvaluator {
    private boolean[] maybeBoolean_;
    private boolean[] maybeShort_;
    private boolean[] maybeInteger_;
    private boolean[] maybeLong_;
    private boolean[] maybeFloat_;
    private boolean[] maybeDouble_;
    private boolean[] maybeDate_;
    private boolean[] maybeHms_;
    private boolean[] maybeDms_;
    private int[] stringLength_;
    private long nrow_;
    private int ncol_ = -1;
    private static final Pattern ISO8601_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,2})-([0-9]{1,2})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?Z?)?");
    private static final Pattern HMS_REGEX = Pattern.compile("[ 012]?[0-9][:h ][ 0-6][0-9][:m ][0-6][0-9](\\.[0-9]*)?");
    private static final Pattern DMS_REGEX = Pattern.compile("[-+][ 0-9]?[0-9][:d ][ 0-6][0-9][:m ][0-6][0-9](\\.[0-9]*)?");
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public RowEvaluator() {
    }

    public RowEvaluator(int ncol) {
        this.init(ncol);
    }

    private void init(int ncol) {
        this.ncol_ = ncol;
        this.maybeBoolean_ = this.makeFlagArray(true);
        this.maybeShort_ = this.makeFlagArray(true);
        this.maybeInteger_ = this.makeFlagArray(true);
        this.maybeLong_ = this.makeFlagArray(true);
        this.maybeFloat_ = this.makeFlagArray(true);
        this.maybeDouble_ = this.makeFlagArray(true);
        this.maybeDate_ = this.makeFlagArray(true);
        this.maybeHms_ = this.makeFlagArray(true);
        this.maybeDms_ = this.makeFlagArray(true);
        this.stringLength_ = new int[ncol];
    }

    public void submitRow(List row) throws TableFormatException {
        ++this.nrow_;
        if (this.ncol_ < 0) {
            this.init(row.size());
        }
        if (row.size() != this.ncol_) {
            throw new TableFormatException("Wrong number of columns at row " + this.nrow_ + " (expecting " + this.ncol_ + ", found " + row.size() + ")");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            int val;
            boolean isMinus;
            boolean done = false;
            String cell = (String)row.get(icol);
            cell = cell == null ? "" : cell.trim();
            int leng = cell.length();
            if (leng == 0) {
                done = true;
            }
            if (leng > this.stringLength_[icol]) {
                this.stringLength_[icol] = leng;
            }
            if (!done && this.maybeBoolean_[icol]) {
                if (cell.equalsIgnoreCase("false") || cell.equalsIgnoreCase("true") || cell.equalsIgnoreCase("f") || cell.equalsIgnoreCase("t")) {
                    done = true;
                } else {
                    this.maybeBoolean_[icol] = false;
                }
            }
            boolean bl = !done ? cell.charAt(0) == '-' : (isMinus = false);
            if (!done && this.maybeShort_[icol]) {
                try {
                    val = Short.parseShort(cell);
                    if (val == 0 && isMinus) {
                        throw new NumberFormatException();
                    }
                    done = true;
                }
                catch (NumberFormatException e) {
                    this.maybeShort_[icol] = false;
                }
            }
            if (!done && this.maybeInteger_[icol]) {
                try {
                    val = Integer.parseInt(cell);
                    if (val == 0 && isMinus) {
                        throw new NumberFormatException();
                    }
                    done = true;
                }
                catch (NumberFormatException e) {
                    this.maybeInteger_[icol] = false;
                }
            }
            if (!done && this.maybeLong_[icol]) {
                try {
                    long val2 = Long.parseLong(cell);
                    if (val2 == 0L && isMinus) {
                        throw new NumberFormatException();
                    }
                    done = true;
                }
                catch (NumberFormatException e) {
                    this.maybeLong_[icol] = false;
                }
            }
            if (!done && (this.maybeFloat_[icol] || this.maybeDouble_[icol])) {
                try {
                    ParsedFloat pf = RowEvaluator.parseFloating(cell);
                    if (this.maybeFloat_[icol]) {
                        if (pf.sigFig > 6) {
                            this.maybeFloat_[icol] = false;
                        } else if (!Double.isInfinite(pf.dValue) && Float.isInfinite((float)pf.dValue)) {
                            this.maybeFloat_[icol] = false;
                        }
                    }
                    done = true;
                }
                catch (NumberFormatException e) {
                    this.maybeFloat_[icol] = false;
                    this.maybeDouble_[icol] = false;
                }
            }
            if (!done && this.maybeDate_[icol]) {
                if (ISO8601_REGEX.matcher(cell).matches()) {
                    done = true;
                } else {
                    this.maybeDate_[icol] = false;
                }
            }
            if (!done && this.maybeHms_[icol]) {
                if (HMS_REGEX.matcher(cell).matches()) {
                    done = true;
                } else {
                    this.maybeHms_[icol] = false;
                }
            }
            if (done || !this.maybeDms_[icol]) continue;
            if (DMS_REGEX.matcher(cell).matches()) {
                done = true;
                continue;
            }
            this.maybeDms_[icol] = false;
        }
    }

    public Metadata getMetadata() {
        ColumnInfo[] colInfos = new ColumnInfo[this.ncol_];
        Decoder[] decoders = new Decoder[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            Decoder decoder;
            ColumnInfo colinfo;
            String name = "col" + (icol + 1);
            if (this.maybeBoolean_[icol]) {
                colinfo = new ColumnInfo(name, class$java$lang$Boolean == null ? RowEvaluator.class$("java.lang.Boolean") : class$java$lang$Boolean, null);
                decoder = new Decoder(){

                    public Object decode(String value) {
                        char v1 = value.trim().charAt(0);
                        return v1 == 't' || v1 == 'T' ? Boolean.TRUE : Boolean.FALSE;
                    }
                };
            } else if (this.maybeShort_[icol]) {
                colinfo = new ColumnInfo(name, class$java$lang$Short == null ? RowEvaluator.class$("java.lang.Short") : class$java$lang$Short, null);
                decoder = new Decoder(){

                    public Object decode(String value) {
                        return new Short(Short.parseShort(value.trim()));
                    }
                };
            } else if (this.maybeInteger_[icol]) {
                colinfo = new ColumnInfo(name, class$java$lang$Integer == null ? RowEvaluator.class$("java.lang.Integer") : class$java$lang$Integer, null);
                decoder = new Decoder(){

                    public Object decode(String value) {
                        return new Integer(Integer.parseInt(value.trim()));
                    }
                };
            } else if (this.maybeLong_[icol]) {
                colinfo = new ColumnInfo(name, class$java$lang$Long == null ? RowEvaluator.class$("java.lang.Long") : class$java$lang$Long, null);
                decoder = new Decoder(){

                    public Object decode(String value) {
                        return new Long(Long.parseLong(value.trim()));
                    }
                };
            } else if (this.maybeFloat_[icol]) {
                colinfo = new ColumnInfo(name, class$java$lang$Float == null ? RowEvaluator.class$("java.lang.Float") : class$java$lang$Float, null);
                decoder = new Decoder(){

                    public Object decode(String value) {
                        return new Float(Float.parseFloat(value.trim()));
                    }
                };
            } else if (this.maybeDouble_[icol]) {
                colinfo = new ColumnInfo(name, class$java$lang$Double == null ? RowEvaluator.class$("java.lang.Double") : class$java$lang$Double, null);
                decoder = new Decoder(){

                    public Object decode(String value) {
                        return new Double(Double.parseDouble(value.trim()));
                    }
                };
            } else {
                colinfo = new ColumnInfo(name, class$java$lang$String == null ? RowEvaluator.class$("java.lang.String") : class$java$lang$String, null);
                colinfo.setElementSize(this.stringLength_[icol]);
                Class clazz = class$java$lang$String == null ? RowEvaluator.class$("java.lang.String") : class$java$lang$String;
                decoder = new Decoder(){

                    public Object decode(String value) {
                        return value;
                    }
                };
                if (this.maybeDate_[icol]) {
                    colinfo.setUnitString("iso-8601");
                    colinfo.setUCD("TIME");
                } else if (this.maybeHms_[icol]) {
                    colinfo.setUnitString("hms");
                } else if (this.maybeDms_[icol]) {
                    colinfo.setUnitString("dms");
                }
            }
            colInfos[icol] = colinfo;
            decoders[icol] = decoder;
        }
        return new Metadata(colInfos, decoders, this.nrow_);
    }

    private boolean[] makeFlagArray(boolean val) {
        boolean[] flags = new boolean[this.ncol_];
        Arrays.fill(flags, val);
        return flags;
    }

    private static ParsedFloat parseFloating(String item) {
        int nc = item.length();
        boolean foundExp = false;
        int sigFig = 0;
        block5: for (int i = 0; i < nc; ++i) {
            char c = item.charAt(i);
            switch (c) {
                case 'D': 
                case 'd': {
                    if (!foundExp) {
                        StringBuffer sbuf = new StringBuffer(item);
                        sbuf.setCharAt(i, 'e');
                        item = sbuf.toString();
                    }
                    foundExp = true;
                    continue block5;
                }
                case 'E': 
                case 'e': {
                    foundExp = true;
                    continue block5;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (foundExp) continue block5;
                    ++sigFig;
                    continue block5;
                }
            }
        }
        double dvalue = Double.parseDouble(item);
        return ParsedFloat.getInstance(sigFig, dvalue);
    }

    private static class ParsedFloat {
        static ParsedFloat instance = new ParsedFloat();
        int sigFig;
        double dValue;

        private ParsedFloat() {
        }

        static ParsedFloat getInstance(int sigFig, double dValue) {
            ParsedFloat.instance.sigFig = sigFig;
            ParsedFloat.instance.dValue = dValue;
            return instance;
        }
    }

    public static abstract class Decoder {
        public abstract Object decode(String var1);
    }

    public static class Metadata {
        public final ColumnInfo[] colInfos_;
        public final Decoder[] decoders_;
        public final long nrow_;
        public final int ncol_;

        public Metadata(ColumnInfo[] colInfos, Decoder[] decoders, long nrow) {
            this.colInfos_ = colInfos;
            this.decoders_ = decoders;
            this.nrow_ = nrow;
            if (this.colInfos_.length != this.decoders_.length) {
                throw new IllegalArgumentException();
            }
            this.ncol_ = this.colInfos_.length;
        }
    }
}

