/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.LineSequence;

class IpacReader
implements RowSequence {
    private final InputStream in_;
    private final int[] ends_;
    private final String[] tokens_;
    private final ColumnReader[] colReaders_;
    private final DescribedValue[] params_;
    private final LineSequence lseq_;
    private String dataLine_;
    private String[] dataTokens_;
    private static final ValueInfo COMMENT_INFO = new DefaultValueInfo("Comments", String.class, "Miscellaneous comments");

    public IpacReader(InputStream in) throws IOException {
        this.in_ = in;
        this.lseq_ = new LineSequence(in);
        this.params_ = IpacReader.readParameters(this.lseq_);
        this.ends_ = IpacReader.readEnds(this.lseq_);
        int ncol = this.ends_.length;
        this.tokens_ = new String[ncol];
        String[] hlines = IpacReader.readHeaderLines(this.lseq_);
        if (hlines.length < 2) {
            throw new TableFormatException("Not enough header lines");
        }
        String[] colNames = this.readHeaderTokens(hlines[0]);
        String[] colTypes = this.readHeaderTokens(hlines[1]);
        String[] colUnits = hlines.length >= 3 ? this.readHeaderTokens(hlines[2]) : new String[ncol];
        String[] colNulls = hlines.length >= 4 ? this.readHeaderTokens(hlines[3]) : new String[ncol];
        this.colReaders_ = new ColumnReader[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnReader cr = IpacReader.createColumnReader(colNames[icol], colTypes[icol], colUnits[icol], colNulls[icol]);
            ColumnInfo info = cr.getInfo();
            if (info.getContentClass().equals(class$java$lang$String == null ? IpacReader.class$("java.lang.String") : class$java$lang$String)) {
                info.setElementSize(this.ends_[icol] - (icol == 0 ? 0 : this.ends_[icol - 1]));
            }
            this.colReaders_[icol] = cr;
        }
    }

    public int getColumnCount() {
        return this.colReaders_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colReaders_[icol].getInfo();
    }

    public DescribedValue[] getParameters() {
        return this.params_;
    }

    public boolean next() throws IOException {
        this.dataLine_ = this.lseq_.nextLine();
        this.dataTokens_ = null;
        return this.dataLine_ != null;
    }

    public Object getCell(int icol) throws IOException {
        return this.colReaders_[icol].readValue(this.getDataTokens()[icol]);
    }

    public Object[] getRow() throws IOException {
        int ncol = this.colReaders_.length;
        String[] tokens = this.getDataTokens();
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            row[icol] = this.colReaders_[icol].readValue(tokens[icol]);
        }
        return row;
    }

    public void close() throws IOException {
        this.in_.close();
    }

    private String[] getDataTokens() throws IOException {
        if (this.dataTokens_ == null) {
            this.dataTokens_ = this.readDataTokens(this.dataLine_);
        }
        return this.dataTokens_;
    }

    private String[] readHeaderTokens(String line) {
        int ipos = 1;
        String[] tokens = new String[this.ends_.length];
        for (int icol = 0; icol < tokens.length; ++icol) {
            tokens[icol] = line.substring(ipos, this.ends_[icol] - 1).trim();
            ipos = this.ends_[icol];
        }
        return tokens;
    }

    private String[] readDataTokens(String line) {
        int ipos = 0;
        String[] tokens = this.tokens_;
        int leng = line.length();
        for (int icol = 0; icol < tokens.length; ++icol) {
            tokens[icol] = line.substring(ipos, Math.min(this.ends_[icol], leng)).trim();
            ipos = this.ends_[icol];
        }
        return tokens;
    }

    private static String[] readHeaderLines(LineSequence lseq) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        boolean done = false;
        while (!done && (line = lseq.nextLine()) != null) {
            if (line.length() <= 0) continue;
            if (line.charAt(0) == '|') {
                lines.add(line);
                continue;
            }
            lseq.replaceLine(line);
            done = true;
        }
        return lines.toArray(new String[0]);
    }

    private static int[] readEnds(LineSequence lseq) throws IOException {
        String line;
        boolean done = false;
        while (!done && (line = lseq.nextLine()) != null) {
            if ((line = line.trim()).length() <= 1) continue;
            if (line.charAt(0) != '|') {
                throw new TableFormatException("Bad header line, should start with '|': \"" + line + "\"");
            }
            lseq.replaceLine(line);
            return IpacReader.readEnds(line);
        }
        throw new TableFormatException("No header lines found");
    }

    private static int[] readEnds(String line) {
        int[] ends1 = new int[line.length()];
        int icol = 0;
        for (int ipos = 1; ipos < line.length(); ++ipos) {
            if (line.charAt(ipos) != '|') continue;
            ends1[icol++] = ipos + 1;
        }
        int[] ends = new int[icol];
        System.arraycopy(ends1, 0, ends, 0, icol);
        return ends;
    }

    private static DescribedValue[] readParameters(LineSequence lseq) throws IOException {
        String line;
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        boolean done = false;
        while (!done && (line = lseq.nextLine()) != null) {
            if ((line = line.trim()).length() <= 1) continue;
            if (line.charAt(0) == '\\') {
                if (line.charAt(1) == ' ') {
                    comments.add(line.substring(2));
                    continue;
                }
                params.add(IpacReader.parseParameter(line.substring(1)));
                continue;
            }
            lseq.replaceLine(line);
            done = true;
        }
        if (comments.size() > 0) {
            StringBuffer comBuf = new StringBuffer();
            Iterator it = comments.iterator();
            while (it.hasNext()) {
                comBuf.append((String)it.next());
                if (!it.hasNext()) continue;
                comBuf.append('\n');
            }
            params.add(new DescribedValue(COMMENT_INFO, comBuf.toString()));
        }
        return params.toArray(new DescribedValue[0]);
    }

    private static DescribedValue parseParameter(String line) throws TableFormatException {
        int ieq = line.indexOf(61);
        if (ieq < 0) {
            throw new TableFormatException("Bad \\name=value line \"" + line + "\"");
        }
        String name = line.substring(0, ieq).trim();
        String sval = line.substring(ieq + 1).trim();
        int sleng = sval.length();
        if (sval.length() > 1 && (sval.charAt(0) == '\'' && sval.charAt(sleng - 1) == '\'' || sval.charAt(0) == '\"' && sval.charAt(sleng - 1) == '\"')) {
            return IpacReader.createParameter(name, sval.substring(1, sleng - 1));
        }
        if (sval.length() == 0) {
            return IpacReader.createParameter(name, "");
        }
        if (sval.equals("T")) {
            return IpacReader.createParameter(name, Boolean.TRUE);
        }
        if (sval.equals("F")) {
            return IpacReader.createParameter(name, Boolean.FALSE);
        }
        try {
            return IpacReader.createParameter(name, Integer.valueOf(sval));
        }
        catch (NumberFormatException e) {
            try {
                return IpacReader.createParameter(name, Long.valueOf(sval));
            }
            catch (NumberFormatException e2) {
                try {
                    return IpacReader.createParameter(name, Double.valueOf(sval));
                }
                catch (NumberFormatException e3) {
                    return IpacReader.createParameter(name, sval);
                }
            }
        }
    }

    private static DescribedValue createParameter(String name, Object value) {
        Class clazz = value == null ? String.class : value.getClass();
        Class clazz2 = clazz;
        return new DescribedValue(new DefaultValueInfo(name, clazz2), value);
    }

    private static ColumnReader createColumnReader(String name, String type, String unit, String blank) throws TableFormatException {
        boolean hasBlank;
        DefaultValueInfo info = new DefaultValueInfo(name);
        if (unit != null && unit.trim().length() > 0) {
            info.setUnitString(unit);
        }
        final String blankVal = blank == null || blank.trim().length() == 0 ? null : blank.trim();
        boolean bl = hasBlank = blankVal != null;
        if (type.equals("int") || type.equals("i")) {
            info.setContentClass(Integer.class);
            info.setNullable(hasBlank);
            return new ColumnReader(info){

                Object readValue(String token) {
                    if (hasBlank && blankVal.equals(token)) {
                        return null;
                    }
                    try {
                        return Integer.valueOf(token);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            };
        }
        if (type.equals("double") || type.equals("d")) {
            info.setContentClass(Double.class);
            return new ColumnReader(info){

                Object readValue(String token) {
                    if (hasBlank && blankVal.equals(token)) {
                        return null;
                    }
                    try {
                        return Double.valueOf(token);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            };
        }
        if (type.equals("float") || type.equals("f") || type.equals("real") || type.equals("r")) {
            info.setContentClass(Float.class);
            return new ColumnReader(info){

                Object readValue(String token) {
                    if (hasBlank && blankVal.equals(token)) {
                        return null;
                    }
                    try {
                        return Float.valueOf(token);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            };
        }
        if (type.equals("char") || type.equals("c")) {
            info.setContentClass(String.class);
            return new ColumnReader(info){

                Object readValue(String token) {
                    if (hasBlank && blankVal.equals(token)) {
                        return null;
                    }
                    return token;
                }
            };
        }
        if (type.equals("date")) {
            info.setContentClass(String.class);
            info.setUnitString("iso-8601");
            info.setUCD("TIME");
            info.setNullable(hasBlank);
            return new ColumnReader(info){

                Object readValue(String token) {
                    if (hasBlank && blankVal.equals(token)) {
                        return null;
                    }
                    return token;
                }
            };
        }
        throw new TableFormatException("Unknown IPAC data type " + type);
    }

    private static abstract class ColumnReader {
        final ColumnInfo info_;

        ColumnReader(ValueInfo info) {
            this.info_ = new ColumnInfo(info);
        }

        ColumnInfo getInfo() {
            return this.info_;
        }

        abstract Object readValue(String var1);
    }
}

