/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.BitSet;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnInfo;

public abstract class PrimitiveArrayColumn
extends ArrayColumn {
    private final Object data;
    private boolean trueMeansNull = true;
    private final BitSet flags = new BitSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    private PrimitiveArrayColumn(ColumnInfo base, Object data) {
        super(base, data);
        this.data = data;
    }

    protected void storeValue(int irow, Object val) {
        if (val == null) {
            this.flags.set(irow, this.trueMeansNull);
        } else {
            this.flags.set(irow, !this.trueMeansNull);
            this.storeElement(irow, val);
        }
    }

    protected Object readValue(int irow) {
        return this.flags.get(irow) == this.trueMeansNull ? null : this.readElement(irow);
    }

    public void setAllNulls() {
        this.trueMeansNull = false;
        this.flags.clear();
    }

    public void setNoNulls() {
        this.trueMeansNull = true;
        this.flags.clear();
    }

    abstract void storeElement(int var1, Object var2);

    abstract Object readElement(int var1);

    public static PrimitiveArrayColumn makePrimitiveColumn(ColumnInfo base, Object data) {
        Class<?> clazz = data.getClass();
        if (clazz == [Z.class) {
            return new BooleanArrayColumn(base, (boolean[])data);
        }
        if (clazz == [C.class) {
            return new CharacterArrayColumn(base, (char[])data);
        }
        if (clazz == [B.class) {
            return new ByteArrayColumn(base, (byte[])data);
        }
        if (clazz == [S.class) {
            return new ShortArrayColumn(base, (short[])data);
        }
        if (clazz == [I.class) {
            return new IntegerArrayColumn(base, (int[])data);
        }
        if (clazz == [J.class) {
            return new LongArrayColumn(base, (long[])data);
        }
        if (clazz == [F.class) {
            return new FloatArrayColumn(base, (float[])data);
        }
        if (clazz == [D.class) {
            return new DoubleArrayColumn(base, (double[])data);
        }
        throw new IllegalArgumentException("Data object is not an array of primitives  (it's a " + clazz.getName() + ")");
    }

    public static PrimitiveArrayColumn makePrimitiveColumn(ColumnInfo base, long rowCount) {
        if (rowCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many rows requested: " + rowCount + " > Integer.MAX_VALUE");
        }
        int nrow = (int)rowCount;
        if (!$assertionsDisabled && (long)nrow != rowCount) {
            throw new AssertionError();
        }
        Class clazz = base.getContentClass();
        if (clazz == null) {
            throw new IllegalArgumentException("No class defined");
        }
        if (clazz == Boolean.class) {
            return new BooleanArrayColumn(base, new boolean[nrow]);
        }
        if (clazz == Character.class) {
            return new CharacterArrayColumn(base, new char[nrow]);
        }
        if (clazz == Byte.class) {
            return new ByteArrayColumn(base, new byte[nrow]);
        }
        if (clazz == Short.class) {
            return new ShortArrayColumn(base, new short[nrow]);
        }
        if (clazz == Integer.class) {
            return new IntegerArrayColumn(base, new int[nrow]);
        }
        if (clazz == Long.class) {
            return new LongArrayColumn(base, new long[nrow]);
        }
        if (clazz == Float.class) {
            return new FloatArrayColumn(base, new float[nrow]);
        }
        if (clazz == Double.class) {
            return new DoubleArrayColumn(base, new double[nrow]);
        }
        throw new IllegalArgumentException("Supplied columninfo content class is not a primitive wrapper type (it's a " + clazz.getName() + ")");
    }

    static {
        $assertionsDisabled = !PrimitiveArrayColumn.class.desiredAssertionStatus();
    }

    private static class DoubleArrayColumn
    extends PrimitiveArrayColumn {
        double[] data;

        DoubleArrayColumn(ColumnInfo base, double[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Double == null ? (class$java$lang$Double = PrimitiveArrayColumn.class$("java.lang.Double")) : class$java$lang$Double);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = (Double)val;
        }

        Object readElement(int irow) {
            return new Double(this.data[irow]);
        }
    }

    private static class FloatArrayColumn
    extends PrimitiveArrayColumn {
        float[] data;

        FloatArrayColumn(ColumnInfo base, float[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveArrayColumn.class$("java.lang.Float")) : class$java$lang$Float);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = ((Float)val).floatValue();
        }

        Object readElement(int irow) {
            return new Float(this.data[irow]);
        }
    }

    private static class LongArrayColumn
    extends PrimitiveArrayColumn {
        long[] data;

        LongArrayColumn(ColumnInfo base, long[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveArrayColumn.class$("java.lang.Long")) : class$java$lang$Long);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = (Long)val;
        }

        Object readElement(int irow) {
            return new Long(this.data[irow]);
        }
    }

    private static class IntegerArrayColumn
    extends PrimitiveArrayColumn {
        int[] data;

        IntegerArrayColumn(ColumnInfo base, int[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveArrayColumn.class$("java.lang.Integer")) : class$java$lang$Integer);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = (Integer)val;
        }

        Object readElement(int irow) {
            return new Integer(this.data[irow]);
        }
    }

    private static class ShortArrayColumn
    extends PrimitiveArrayColumn {
        short[] data;

        ShortArrayColumn(ColumnInfo base, short[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveArrayColumn.class$("java.lang.Short")) : class$java$lang$Short);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = (Short)val;
        }

        Object readElement(int irow) {
            return new Short(this.data[irow]);
        }
    }

    private static class ByteArrayColumn
    extends PrimitiveArrayColumn {
        byte[] data;

        ByteArrayColumn(ColumnInfo base, byte[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Byte == null ? (class$java$lang$Byte = PrimitiveArrayColumn.class$("java.lang.Byte")) : class$java$lang$Byte);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = (Byte)val;
        }

        Object readElement(int irow) {
            return new Byte(this.data[irow]);
        }
    }

    private static class CharacterArrayColumn
    extends PrimitiveArrayColumn {
        char[] data;

        CharacterArrayColumn(ColumnInfo base, char[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Character == null ? (class$java$lang$Character = PrimitiveArrayColumn.class$("java.lang.Character")) : class$java$lang$Character);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = ((Character)val).charValue();
        }

        Object readElement(int irow) {
            return new Character(this.data[irow]);
        }
    }

    private static class BooleanArrayColumn
    extends PrimitiveArrayColumn {
        boolean[] data;

        BooleanArrayColumn(ColumnInfo base, boolean[] data) {
            super(base, data);
            this.checkContentClass(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveArrayColumn.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            this.data = data;
        }

        void storeElement(int irow, Object val) {
            this.data[irow] = (Boolean)val;
        }

        Object readElement(int irow) {
            return this.data[irow] ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

