/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ObjectArrayColumn;
import uk.ac.starlink.table.PrimitiveArrayColumn;

public abstract class ArrayColumn
extends ColumnData {
    private final Object data;
    static final /* synthetic */ boolean $assertionsDisabled;

    ArrayColumn(final ColumnInfo base, Object data) {
        super(new ColumnInfo(base){

            public void setContentClass(Class clazz) {
                if (!clazz.equals(base.getContentClass())) {
                    throw new IllegalArgumentException("Can't change class");
                }
                super.setContentClass(clazz);
            }
        });
        this.data = data;
    }

    public boolean isWritable() {
        return true;
    }

    public void storeValue(long lrow, Object val) {
        this.storeValue((int)lrow, val);
    }

    public Object readValue(long lrow) {
        return this.readValue((int)lrow);
    }

    abstract void storeValue(int var1, Object var2);

    abstract Object readValue(int var1);

    public Object getArray() {
        return this.data;
    }

    void checkContentClass(Class clazz) {
        ColumnInfo colinfo = this.getColumnInfo();
        if (colinfo.getContentClass() == null) {
            colinfo.setContentClass(clazz);
        } else if (!colinfo.getContentClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Incompatible content class in column info: " + colinfo.getContentClass() + " not assignable from " + clazz);
        }
    }

    public static ArrayColumn makeColumn(ColumnInfo base, long rowCount) {
        if (rowCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many rows requested: " + rowCount + " > Integer.MAX_VALUE");
        }
        int nrow = (int)rowCount;
        if (!$assertionsDisabled && (long)nrow != rowCount) {
            throw new AssertionError();
        }
        Class clazz = base.getContentClass();
        if (clazz == null) {
            throw new IllegalArgumentException("No class defined");
        }
        if (clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class) {
            return PrimitiveArrayColumn.makePrimitiveColumn(base, nrow);
        }
        return new ObjectArrayColumn(base, new Object[nrow]);
    }

    public static ArrayColumn makeColumn(ColumnInfo base, Object data) {
        Class<?> eclazz = data.getClass().getComponentType();
        if (eclazz == null) {
            throw new IllegalArgumentException("Data object is not an array  (it's a " + data.getClass());
        }
        if (eclazz.isPrimitive()) {
            return PrimitiveArrayColumn.makePrimitiveColumn(base, data);
        }
        return new ObjectArrayColumn(base, (Object[])data);
    }

    public static ArrayColumn makeColumn(String name, Object data) {
        Class contentClass = data.getClass().getComponentType();
        if (contentClass.isPrimitive()) {
            if (contentClass == Byte.TYPE) {
                contentClass = Byte.class;
            } else if (contentClass == Short.TYPE) {
                contentClass = Short.class;
            } else if (contentClass == Integer.TYPE) {
                contentClass = Integer.class;
            } else if (contentClass == Long.TYPE) {
                contentClass = Long.class;
            } else if (contentClass == Float.TYPE) {
                contentClass = Float.class;
            } else if (contentClass == Double.TYPE) {
                contentClass = Double.class;
            } else if (contentClass == Character.TYPE) {
                contentClass = Character.class;
            } else if (contentClass == Boolean.TYPE) {
                contentClass = Boolean.class;
            } else {
                throw new AssertionError((Object)("Unknonwn primitive type?? " + contentClass));
            }
        }
        return ArrayColumn.makeColumn(new ColumnInfo(name, contentClass, null), data);
    }

    static {
        $assertionsDisabled = !ArrayColumn.class.desiredAssertionStatus();
    }
}

