/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.skycat;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import jsky.catalog.AbstractCatalogDirectory;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.catalog.skycat.SkycatCatalog;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.util.FileUtil;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressPanel;

public class SkycatConfigFile
extends AbstractCatalogDirectory {
    private static SkycatConfigFile _configFile;
    private static URL _defaultURL;
    private transient ProgressPanel _progressPanel;
    public static final String SERV_TYPE = "serv_type";
    public static final String LONG_NAME = "long_name";
    public static final String SHORT_NAME = "short_name";
    public static final String URL = "url";
    public static final String BACKUP1 = "backup1";
    public static final String BACKUP2 = "backup2";
    public static final String EQUINOX = "equinox";
    public static final String SYMBOL = "symbol";
    public static final String ID_COL = "id_col";
    public static final String RA_COL = "ra_col";
    public static final String DEC_COL = "dec_col";
    public static final String X_COL = "x_col";
    public static final String Y_COL = "y_col";
    public static final String SEARCH_COLS = "search_cols";
    public static final String HELP = "help";

    public SkycatConfigFile(String name, URL url) {
        super(name);
        this.setURL(url);
        this._load();
    }

    public SkycatConfigFile(String name, String configFileOrURL) {
        this(name, FileUtil.makeURL(null, (String)configFileOrURL));
    }

    public SkycatConfigFile(String configFileOrURL) {
        this(configFileOrURL, FileUtil.makeURL(null, (String)configFileOrURL));
    }

    public SkycatConfigFile(URL url, HTMLQueryResultHandler handler) {
        super(new File(url.toString()).getPath());
        this.setURL(url);
        this.setHTMLQueryResultHandler(handler);
        this._load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        URL url = this.getURL();
        if (url == null) {
            return;
        }
        try {
            String protocol = url.getProtocol();
            if (protocol.equals("file") || protocol.equals("jar")) {
                this._load(url.openStream());
            } else {
                HTMLQueryResultHandler handler;
                if (this._progressPanel == null) {
                    this._progressPanel = ProgressPanel.makeProgressPanel((String)"Downloading the catalog config file.");
                }
                this._progressPanel.start();
                this._progressPanel.setText("Connect: " + url.getHost() + ", waiting for reply.");
                URLConnection connection = this._progressPanel.openConnection(url);
                String contentType = connection.getContentType();
                if (contentType.equals("text/html") && (handler = this.getHTMLQueryResultHandler()) != null) {
                    handler.displayHTMLPage(url);
                    throw new RuntimeException("Error reading catalog config file URL: " + url.toString());
                }
                this._load(connection.getInputStream());
            }
        }
        catch (IOException e) {
            this._load(this.getName());
        }
        finally {
            if (this._progressPanel != null) {
                this._progressPanel.stop();
            }
        }
    }

    private void _load(String name) {
        InputStream is;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("I/O error reading catalog config file: " + e);
        }
        this._load(is);
    }

    private void _load(InputStream stream) {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        int lineNumber = 0;
        Properties properties = null;
        ArrayList<Catalog> catalogs = new ArrayList<Catalog>();
        if (this._progressPanel != null) {
            this._progressPanel.setText("Reading catalog config file...");
        }
        while ((line = this._getLine(r)) != null) {
            ++lineNumber;
            if (line.length() == 0 || line.startsWith("#")) continue;
            int i = line.indexOf(58);
            if (i == -1) {
                throw new RuntimeException(this.getURL().toString() + ": line " + lineNumber + ": missing separator (':') in config file");
            }
            String key = line.substring(0, i).trim();
            String value = line.substring(i + 1).trim();
            if (key.equals(SERV_TYPE)) {
                if (properties != null) {
                    SkycatConfigEntry entry = new SkycatConfigEntry(this, properties);
                    SkycatCatalog cat = new SkycatCatalog(entry);
                    catalogs.add(cat);
                    CatalogFactory.registerCatalog(cat, this.isLocal());
                }
                properties = new Properties();
            }
            if (properties == null) continue;
            properties.setProperty(key, value);
        }
        if (properties != null) {
            SkycatConfigEntry entry = new SkycatConfigEntry(this, properties);
            SkycatCatalog cat = new SkycatCatalog(entry);
            catalogs.add(cat);
        }
        this.setCatalogs(catalogs);
        if (this._progressPanel != null) {
            this._progressPanel.setText("Done.");
        }
    }

    private String _getLine(BufferedReader r) {
        String line;
        try {
            line = r.readLine();
            if (line != null && line.endsWith("\\")) {
                StringBuffer result = new StringBuffer(line);
                do {
                    result.setLength(result.length() - 1);
                    line = r.readLine();
                    if (line == null) continue;
                    result.append(line);
                } while (line != null && line.endsWith("\\"));
                return result.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return line;
    }

    public static CatalogDirectory getDirectory() {
        return SkycatConfigFile.getConfigFile();
    }

    public static CatalogDirectory getDirectory(AstroCatalog cat) {
        SkycatConfigFile configFile = SkycatConfigFile.getConfigFile();
        configFile.setName(cat.getName());
        return configFile;
    }

    public static SkycatConfigFile getConfigFile() {
        if (_configFile != null) {
            return _configFile;
        }
        String[] urls = new String[4];
        int index = 0;
        String urlStr = System.getProperty("jsky.catalog.skycat.config");
        if (urlStr == null) {
            urlStr = System.getProperty("jnlp.jsky.catalog.skycat.config");
        }
        if (urlStr != null && urlStr.length() != 0) {
            urls[index++] = urlStr;
        }
        String sep = System.getProperty("file.separator");
        String filename = Preferences.getPreferences().getDir() + sep + "skycat.cfg";
        File file = new File(filename);
        if (file.exists()) {
            try {
                urls[index++] = file.toURI().toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (_defaultURL == null) {
            _defaultURL = Resources.getResource((String)"skycat.cfg");
        }
        if (_defaultURL == null) {
            throw new RuntimeException("Can't find the default catalog config file resource (skycat.cfg).");
        }
        urls[index++] = _defaultURL.toString();
        String home = System.getProperty("user.home");
        filename = home + sep + ".skycat" + sep + "skycat.cfg";
        file = new File(filename);
        if (file.exists()) {
            try {
                urls[index++] = file.toURI().toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        _configFile = new SkycatConfigFile(urls[0]);
        for (int i = 1; i < index; ++i) {
            if (urls[i] == null) continue;
            _configFile.addCatalogDirectory(urls[i]);
        }
        return _configFile;
    }

    @Override
    public Catalog reload() {
        _configFile = null;
        SkycatConfigFile.getConfigFile();
        return _configFile;
    }

    @Override
    public CatalogDirectory loadSubDir(URL url) {
        String filename = url.getFile();
        if (filename.endsWith(".cfg")) {
            return new SkycatConfigFile(url, this.getHTMLQueryResultHandler());
        }
        throw new RuntimeException("Expected a Skycat style .cfg file, or an AstroCat XML file");
    }

    public static void setConfigFile(URL url) {
        _defaultURL = url;
    }

    public void addCatalogDirectory(String urlStr) {
        if (this.getCatalog(urlStr) != null) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty(SERV_TYPE, "directory");
        properties.setProperty(LONG_NAME, urlStr);
        properties.setProperty(URL, urlStr);
        SkycatConfigEntry entry = new SkycatConfigEntry(this, properties);
        SkycatCatalog cat = new SkycatCatalog(entry);
        this.addCatalog(cat);
    }

    @Override
    public List<Catalog> getNameServers() {
        List<Catalog> l = CatalogFactory.getCatalogsByType("namesvr");
        if (l.size() != 0) {
            return l;
        }
        this._addDefaultNameServers();
        return CatalogFactory.getCatalogsByType("namesvr");
    }

    private void _addDefaultNameServers() {
        Properties p1 = new Properties();
        p1.setProperty(SERV_TYPE, "namesvr");
        p1.setProperty(LONG_NAME, "SIMBAD Names");
        p1.setProperty(SHORT_NAME, "simbad_ns@eso");
        p1.setProperty(URL, "http://archive.eso.org/skycat/servers/sim-server?&o=%id");
        SkycatConfigEntry entry = new SkycatConfigEntry(this, p1);
        SkycatCatalog cat = new SkycatCatalog(entry);
        CatalogFactory.registerCatalog(cat, false);
        Properties p2 = new Properties();
        p2.setProperty(SERV_TYPE, "namesvr");
        p2.setProperty(LONG_NAME, "NED Names");
        p2.setProperty(SHORT_NAME, "ned@eso");
        p2.setProperty(URL, "http://archive.eso.org/skycat/servers/ned-server?&o=%id");
        entry = new SkycatConfigEntry(this, p2);
        cat = new SkycatCatalog(entry);
        CatalogFactory.registerCatalog(cat, false);
    }

    @Override
    public void save() {
        String sep = System.getProperty("file.separator");
        String filename = Preferences.getPreferences().getDir() + sep + "skycat.cfg";
        try {
            this.save(filename);
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void save(String filename) throws IOException {
        File file = new File(filename + ".tmp");
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            DialogUtil.error((String)("Could not create directory: " + dir));
            return;
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.save(stream);
        }
        catch (Exception e) {
            ((OutputStream)stream).close();
            file.delete();
            throw new RuntimeException(e);
        }
        ((OutputStream)stream).close();
        File newFile = new File(filename);
        if (!newFile.delete()) {
            DialogUtil.error((String)("Could not delete existing file: " + file));
            return;
        }
        if (!file.renameTo(newFile)) {
            DialogUtil.error((String)("Rename " + file + " to " + filename + " failed"));
        }
    }

    public void save(OutputStream stream) {
        PrintWriter out = new PrintWriter(stream);
        out.println("# Catalog config file");
        out.println("# This file was automatically generated by JSky.");
        out.println();
        List<Catalog> catalogs = this.getCatalogs();
        int numCatalogs = this.getNumCatalogs();
        for (int i = 0; i < numCatalogs; ++i) {
            out.println();
            SkycatCatalog catalog = (SkycatCatalog)catalogs.get(i);
            SkycatConfigEntry entry = catalog.getConfigEntry();
            Properties properties = entry.getProperties();
            out.println("serv_type: " + properties.getProperty(SERV_TYPE));
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (s.equals(SERV_TYPE)) continue;
                out.println(s + ": " + properties.getProperty(s));
            }
        }
        out.close();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java -classpath ... SkycatConfigFile catalogName");
            System.exit(1);
        }
        String catalogName = args[0];
        SkycatConfigFile configFile = SkycatConfigFile.getConfigFile();
        Catalog cat = configFile.getCatalog(catalogName);
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        } else {
            System.out.println("Test passed");
        }
    }

    static {
        _defaultURL = null;
    }
}

