/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.util.Vector;
import jsky.coords.Coordinates;
import jsky.coords.ImageCoords;
import jsky.coords.WorldCoords;

public class RowCoordinates {
    protected int _idCol = -1;
    protected int _xCol = -1;
    protected int _yCol = -1;
    protected boolean _isWcs = false;
    protected double _equinox = 2000.0;
    protected int _equinoxCol = -1;
    protected boolean _isPix = false;

    public RowCoordinates(int raCol, int decCol, double equinox) {
        this._xCol = raCol;
        this._yCol = decCol;
        this._equinox = equinox;
        this._isWcs = true;
    }

    public RowCoordinates(int raCol, int decCol, int equinoxCol) {
        this._xCol = raCol;
        this._yCol = decCol;
        this._equinoxCol = equinoxCol;
        this._isWcs = true;
    }

    public RowCoordinates(int xCol, int yCol) {
        this._xCol = xCol;
        this._yCol = yCol;
        this._isPix = true;
    }

    public RowCoordinates() {
    }

    public boolean hasCoordinates() {
        return this._isWcs || this._isPix;
    }

    public boolean isWCS() {
        return this._isWcs;
    }

    public double equinox() {
        return this._equinox;
    }

    public boolean isPix() {
        return this._isPix;
    }

    public Coordinates getCoordinates(Vector row) {
        try {
            int n = row.size();
            if (this._xCol < n && this._yCol < n) {
                if (this._isWcs) {
                    Object ra = row.get(this._xCol);
                    Object dec = row.get(this._yCol);
                    if (ra != null && dec != null) {
                        if (ra instanceof String && dec instanceof String && ((String)ra).length() != 0 && ((String)dec).length() != 0) {
                            return new WorldCoords((String)ra, (String)dec, this._equinox);
                        }
                        if (ra instanceof Double && dec instanceof Double) {
                            return new WorldCoords((Double)ra, (Double)dec, this._equinox);
                        }
                        if (ra instanceof Float && dec instanceof Float) {
                            return new WorldCoords((double)((Float)ra).floatValue(), (double)((Float)dec).floatValue(), this._equinox);
                        }
                    }
                } else if (this._isPix) {
                    Object x = row.get(this._xCol);
                    Object y = row.get(this._yCol);
                    if (x != null && y != null) {
                        if (x instanceof Double && y instanceof Double) {
                            return new ImageCoords((Double)x, (Double)y);
                        }
                        if (x instanceof Float && y instanceof Float) {
                            return new ImageCoords((double)((Float)x).floatValue(), (double)((Float)y).floatValue());
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public int getXCol() {
        return this._isPix ? this._xCol : -1;
    }

    public int getYCol() {
        return this._isPix ? this._yCol : -1;
    }

    public int getRaCol() {
        return this._isWcs ? this._xCol : -1;
    }

    public int getDecCol() {
        return this._isWcs ? this._yCol : -1;
    }

    public double getEquinox() {
        return this._equinox;
    }

    public int getEquinoxCol() {
        return this._equinoxCol;
    }

    public int getIdCol() {
        return this._idCol;
    }

    public void setIdCol(int idCol) {
        this._idCol = idCol;
    }
}

