/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client.cache;

import com.cosylab.logging.client.cache.ILogMap;
import com.cosylab.logging.client.cache.LogCacheException;
import com.cosylab.logging.client.cache.LogFileCache;
import com.cosylab.logging.client.cache.LogIterator;
import com.cosylab.logging.engine.log.ILogEntry;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class LogBufferedFileCache
extends LogFileCache
implements ILogMap {
    public static final String WRITEBUFFERSIZE_PROPERTY_NAME = "jlog.cache.writebuffersize";
    public static final int DEFAULT_WRITEBUFFERSIZE = 8192;
    private TreeMap<Integer, BufferedCacheItem> buffer = new TreeMap();
    private int size;
    private volatile long bufferFileSize = 0L;

    public LogBufferedFileCache(int writeBufferSize) throws LogCacheException {
        if (writeBufferSize <= 0) {
            throw new IllegalArgumentException("Invalid size for the buffer " + writeBufferSize);
        }
        this.size = writeBufferSize;
    }

    public LogBufferedFileCache() throws LogCacheException {
        this(LogBufferedFileCache.getDefaultWriteCacheSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() throws LogCacheException {
        super.clear();
        TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
        synchronized (treeMap) {
            this.buffer.clear();
        }
        this.bufferFileSize = 0L;
    }

    @Override
    public synchronized ILogEntry getLog(Integer key) throws LogCacheException {
        BufferedCacheItem item = this.buffer.get(key);
        if (item == null) {
            return super.getLog(key);
        }
        return item.getLogEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteLog(Integer key) throws LogCacheException {
        BufferedCacheItem itemToDelete = this.buffer.get(key);
        if (itemToDelete != null) {
            TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
            synchronized (treeMap) {
                this.buffer.remove(key);
            }
            this.bufferFileSize -= (long)itemToDelete.getLogCacheString().length();
        } else {
            super.deleteLog(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteLogs(Collection<Integer> keys) throws LogCacheException {
        if (keys == null) {
            throw new IllegalArgumentException("Illegal null collection of logs to delete");
        }
        Iterator<Integer> iter = keys.iterator();
        while (iter.hasNext()) {
            BufferedCacheItem cacheItem;
            Integer key = iter.next();
            TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
            synchronized (treeMap) {
                cacheItem = this.buffer.remove(key);
            }
            if (cacheItem == null) continue;
            iter.remove();
            this.bufferFileSize -= (long)cacheItem.getLogCacheString().length();
        }
        if (keys.size() > 0) {
            super.deleteLogs(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int add(ILogEntry log) throws LogCacheException {
        int logInBuffer;
        if (log == null) {
            throw new LogCacheException("Error: trying to add a null log to the buffer");
        }
        BufferedCacheItem cacheItem = new BufferedCacheItem(log, this.toCacheString(log));
        TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
        synchronized (treeMap) {
            this.buffer.put(this.logID, cacheItem);
            logInBuffer = this.buffer.size();
            this.bufferFileSize += (long)cacheItem.getLogCacheString().length();
        }
        if (logInBuffer == this.size) {
            this.flushBuffer();
        }
        return this.logID++;
    }

    private static int getDefaultWriteCacheSize() {
        Integer cacheSizeFromProperty = Integer.getInteger(WRITEBUFFERSIZE_PROPERTY_NAME);
        if (cacheSizeFromProperty != null) {
            return cacheSizeFromProperty;
        }
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flushBuffer() throws LogCacheException {
        long startingPos;
        StringBuilder str = new StringBuilder();
        if (this.file == null) {
            try {
                this.initCache();
            }
            catch (IOException e) {
                throw new LogCacheException("Error flushing buffer", e);
            }
        }
        try {
            startingPos = this.file.length();
        }
        catch (IOException ioe) {
            throw new LogCacheException("Error getting the length of the file ", ioe);
        }
        for (Integer key : this.buffer.keySet()) {
            BufferedCacheItem item = this.buffer.get(key);
            LogFileCache.LogCacheInfo info = new LogFileCache.LogCacheInfo();
            info.start = startingPos + (long)str.length();
            str.append(item.getLogCacheString());
            info.len = item.getLogCacheString().length();
            if (!this.buffer.containsKey(key)) continue;
            this.index.put(key, info);
        }
        TreeMap<Integer, BufferedCacheItem> treeMap = this.file;
        synchronized (treeMap) {
            try {
                this.file.seek(startingPos);
                this.file.writeBytes(str.toString());
            }
            catch (IOException ioe) {
                throw new LogCacheException("Error writing the buffer on disk", ioe);
            }
        }
        treeMap = this.buffer;
        synchronized (treeMap) {
            this.buffer.clear();
        }
        this.bufferFileSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getSize() {
        int sz;
        TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
        synchronized (treeMap) {
            sz = this.buffer.size();
        }
        return super.getSize() + sz;
    }

    @Override
    public long getFileSize() throws IOException {
        return super.getFileSize() + this.bufferFileSize;
    }

    public final synchronized int getBufferSize() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getFirstLog() {
        Integer bufferFirstLog;
        Integer cacheFirstLog = super.getFirstLog();
        TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
        synchronized (treeMap) {
            if (this.buffer.isEmpty()) {
                return cacheFirstLog;
            }
            bufferFirstLog = this.buffer.firstKey();
        }
        if (cacheFirstLog == null) {
            return bufferFirstLog;
        }
        return Math.min(cacheFirstLog, bufferFirstLog);
    }

    @Override
    public int getFirstLogs(int n, Collection<Integer> keys) {
        if (n <= 0 || keys == null) {
            throw new IllegalArgumentException("Invalid number of requested keys or null collection");
        }
        int ret = super.getFirstLogs(n, keys);
        if (ret < n) {
            Set<Integer> allTheKeys = this.buffer.keySet();
            Iterator<Integer> iter = allTheKeys.iterator();
            while (iter.hasNext() && ret < n) {
                keys.add(iter.next());
                ++ret;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getLastLog() {
        Integer bufferLastLog;
        Integer cacheLastLog = super.getLastLog();
        TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
        synchronized (treeMap) {
            if (this.buffer.isEmpty()) {
                return cacheLastLog;
            }
            bufferLastLog = this.buffer.lastKey();
        }
        if (cacheLastLog == null) {
            return bufferLastLog;
        }
        return Math.max(cacheLastLog, bufferLastLog);
    }

    @Override
    public Set<Integer> keySet() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(super.keySet());
        ret.addAll(this.buffer.keySet());
        return ret;
    }

    @Override
    public Iterator<ILogEntry> iterator() {
        return new LogIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void replaceLog(Integer key, ILogEntry log) throws LogCacheException {
        TreeMap<Integer, BufferedCacheItem> treeMap = this.buffer;
        synchronized (treeMap) {
            if (this.buffer.containsKey(key)) {
                BufferedCacheItem oldItem = this.buffer.get(key);
                BufferedCacheItem cacheItem = new BufferedCacheItem(log, this.toCacheString(log));
                this.buffer.put(key, cacheItem);
                this.bufferFileSize = this.bufferFileSize + (long)cacheItem.getLogCacheString().length() - (long)oldItem.getLogCacheString().length();
                return;
            }
        }
        super.replaceLog(key, log);
    }

    private static class BufferedCacheItem {
        private ILogEntry logEntry;
        private String logCacheString;

        public BufferedCacheItem(ILogEntry log, String cacheString) {
            if (log == null) {
                throw new IllegalArgumentException("Invalid null log entry");
            }
            if (cacheString == null || cacheString.length() == 0) {
                throw new IllegalArgumentException("Invalid log cache string " + cacheString);
            }
            this.logEntry = log;
            this.logCacheString = cacheString;
        }

        public ILogEntry getLogEntry() {
            return this.logEntry;
        }

        public String getLogCacheString() {
            return this.logCacheString;
        }
    }
}

