/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client;

import alma.acs.logging.table.LogTooltipHelper;
import alma.acs.logging.table.renderer.EntryTypeRenderer;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.Component;
import java.awt.FontMetrics;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class DetailedLogTable
extends JTable {
    private static final String NOT_AVAILABLE = "";
    private DetailedTableModel dataModel = new DetailedTableModel();
    private int rowsNum;
    private int normalRowHeight;
    private String[][] nameValue;
    private MultilineRenderer logMessageRenderer = new MultilineRenderer();
    private EntryTypeRenderer entryTypeRenderer = new EntryTypeRenderer(true);

    public DetailedLogTable() {
        this.setModel(this.dataModel);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setAutoResizeMode(3);
        this.getColumnModel().getColumn(0).setHeaderValue("LogField");
        this.getColumnModel().getColumn(1).setHeaderValue("Value");
        this.getColumnModel().getColumn(0).setMinWidth(110);
        this.getColumnModel().getColumn(0).setMaxWidth(250);
        this.getColumnModel().getColumn(1).setMinWidth(250);
        this.setEmptyContent();
        this.normalRowHeight = this.getRowHeight();
    }

    private void setEmptyContent() {
        this.rowsNum = LogField.values().length;
        this.nameValue = new String[this.rowsNum][2];
        for (int i = 0; i < LogField.values().length; ++i) {
            this.nameValue[i][0] = "<HTML><B>" + LogField.values()[i].getName() + "</B>";
            this.nameValue[i][1] = NOT_AVAILABLE;
        }
        this.dataModel.fireTableDataChanged();
    }

    public void setupContent(ILogEntry log) {
        if (log == null) {
            this.setEmptyContent();
            return;
        }
        Vector additionalData = log.getAdditionalData();
        this.rowsNum = LogField.values().length;
        if (additionalData != null) {
            this.rowsNum += additionalData.size();
        }
        if (this.rowsNum > 0) {
            int i;
            this.nameValue = new String[this.rowsNum][2];
            for (i = 0; i < LogField.values().length; ++i) {
                LogField field = LogField.values()[i];
                this.nameValue[i][0] = "<HTML><B>" + field.getName() + "</B>";
                Object obj = log.getField(field);
                if (obj != null) {
                    if (field == LogField.ENTRYTYPE) {
                        this.nameValue[i][1] = obj.toString();
                        this.dataModel.logType = (LogTypeHelper)obj;
                        continue;
                    }
                    if (field == LogField.TIMESTAMP) {
                        IsoDateFormat df = new IsoDateFormat();
                        Date dt = new Date((Long)obj);
                        StringBuffer dateSB = new StringBuffer();
                        FieldPosition pos = new FieldPosition(0);
                        df.format(dt, dateSB, pos);
                        this.nameValue[i][1] = dateSB.toString();
                        continue;
                    }
                    this.nameValue[i][1] = obj.toString();
                    continue;
                }
                this.nameValue[i][1] = NOT_AVAILABLE;
            }
            for (i = LogField.values().length; i < this.rowsNum; ++i) {
                String temp;
                this.nameValue[i][0] = "<HTML><B>Additional</B> <I>" + ((ILogEntry.AdditionalData)additionalData.get((int)(i - LogField.values().length))).name + "</I>";
                this.nameValue[i][1] = temp = ((ILogEntry.AdditionalData)additionalData.get((int)(i - LogField.values().length))).value;
            }
            this.dataModel.fireTableDataChanged();
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (vColIndex == 1) {
            LogTooltipHelper.setToolTip((JComponent)c, this.nameValue[rowIndex][vColIndex].toString(), 96);
        }
        return c;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return super.getCellRenderer(row, column);
        }
        if (row != LogField.ENTRYTYPE.ordinal()) {
            return this.logMessageRenderer;
        }
        return this.entryTypeRenderer;
    }

    public class DetailedTableModel
    extends AbstractTableModel {
        public LogTypeHelper logType = null;

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DetailedLogTable.this.rowsNum;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 1 && row == LogField.ENTRYTYPE.ordinal()) {
                return this.logType;
            }
            return DetailedLogTable.this.nameValue[row][col];
        }
    }

    public class MultilineRenderer
    extends JTextArea
    implements TableCellRenderer {
        public MultilineRenderer() {
            super(100, 20);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(obj.toString());
            int newSize = DetailedLogTable.this.normalRowHeight * this.formatText(obj.toString());
            if (DetailedLogTable.this.getRowHeight(row) != newSize) {
                DetailedLogTable.this.setRowHeight(row, newSize);
            }
            FontMetrics fm = this.getFontMetrics(this.getFont());
            return this;
        }

        private int formatText(String str) {
            if (str == null || str.length() == 0) {
                return 1;
            }
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int pixels = fm.stringWidth(str);
            if (pixels < this.getSize().width) {
                return 1;
            }
            return pixels / this.getPreferredSize().width + 1;
        }
    }
}

