/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.tools;

import alma.acs.logging.tools.LogConverter;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;

public class CSVConverter
extends LogConverter {
    private char separator = (char)44;
    private boolean useDoubleQuotes = true;

    public CSVConverter(String cols) {
        super(cols);
    }

    public CSVConverter() {
    }

    public CSVConverter(String cols, char separator, boolean doubleQuotes) {
        super(cols);
        this.useDoubleQuotes = doubleQuotes;
        this.separator = separator;
    }

    public void setSeparator(char sep) {
        this.separator = sep;
    }

    public void encloseByDoubleQuotes(boolean enclose) {
        this.useDoubleQuotes = enclose;
    }

    @Override
    public String getHeader() {
        StringBuilder str = new StringBuilder();
        for (int t = 0; t < this.colIndex.length(); ++t) {
            Character c = Character.valueOf(Character.toUpperCase(this.colIndex.charAt(t)));
            int index = c.charValue() >= '0' && c.charValue() <= '9' || c.charValue() >= 'A' && c.charValue() <= 'F' ? Integer.parseInt(c.toString(), 16) : 16;
            if (t > 0) {
                str.append(this.separator);
            }
            this.appendField(LogField.values()[index].getName(), str);
        }
        str.append('\n');
        return str.toString();
    }

    @Override
    public String convert(ILogEntry log) {
        if (log == null) {
            throw new IllegalArgumentException("Impossible to convert a null log");
        }
        StringBuilder str = new StringBuilder();
        IsoDateFormat df = new IsoDateFormat();
        for (int t = 0; t < this.colIndex.length(); ++t) {
            Character c;
            if (t > 0) {
                str.append(this.separator);
            }
            if ((c = Character.valueOf(Character.toUpperCase(this.colIndex.charAt(t)))).charValue() >= '0' && c.charValue() <= '9' || c.charValue() >= 'A' && c.charValue() <= Character.toUpperCase(LogField.values()[LogField.values().length - 1].id)) {
                LogField field = LogField.fromID((char)c.charValue());
                Object obj = log.getField(field);
                if (obj == null) {
                    this.appendField(null, str);
                    continue;
                }
                if (field == LogField.TIMESTAMP) {
                    Date dt = new Date((Long)obj);
                    StringBuffer dateSB = new StringBuffer();
                    FieldPosition pos = new FieldPosition(0);
                    df.format(dt, dateSB, pos);
                    this.appendField(dateSB.toString(), str);
                    continue;
                }
                if (field == LogField.ENTRYTYPE) {
                    this.appendField(LogTypeHelper.fromLogTypeDescription((String)obj.toString()).logEntryType, str);
                    continue;
                }
                this.appendField(obj.toString(), str);
                continue;
            }
            if (log.hasDatas()) {
                this.appendField(this.formatData(log.getAdditionalData()), str);
                continue;
            }
            this.appendField(null, str);
        }
        str.append('\n');
        return str.toString();
    }

    private void appendField(String fld, StringBuilder str) {
        if (this.useDoubleQuotes) {
            if (fld == null || fld.length() == 0) {
                str.append('\"');
                str.append('\"');
                return;
            }
            str.append('\"');
            str.append(fld.replaceAll("\"", "\"\""));
            str.append('\"');
        } else {
            if (fld == null || fld.length() == 0) {
                return;
            }
            String temp = fld.replace('\"', '\'');
            temp = temp.replace(",", "_");
            str.append(temp.replace('\n', ' '));
        }
    }

    private String formatData(Vector<ILogEntry.AdditionalData> datas) {
        StringBuilder temp = new StringBuilder();
        boolean first = true;
        for (ILogEntry.AdditionalData data : datas) {
            if (!first) {
                temp.append(' ');
            } else {
                first = false;
            }
            temp.append('[');
            temp.append(data.name);
            temp.append(" ==> ");
            temp.append(data.value);
            temp.append(']');
        }
        return temp.toString();
    }
}

