/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table.reduction;

import alma.acs.logging.table.reduction.AntennaRule;
import alma.acs.logging.table.reduction.ReductionRule;
import alma.acs.logging.table.reduction.SourceAntennaRule;
import com.cosylab.logging.engine.log.ILogEntry;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class LogProcessor {
    private final List<ReductionRule> rules = Collections.synchronizedList(new Vector());

    public void reduce(List<ILogEntry> logs) {
        for (int t = 0; t < logs.size(); ++t) {
            ReductionRule rule;
            block6: {
                ILogEntry log = logs.get(t);
                if (log == null) continue;
                try {
                    rule = new SourceAntennaRule(log);
                    if (!rule.isReducible() && !(rule = new AntennaRule(log)).isReducible()) {
                    }
                    break block6;
                }
                catch (Throwable th) {
                    System.out.println("LogProcessor: error instantiating a Reduction rule: " + th.getMessage());
                    System.out.println("Problematic log: " + log.toString());
                    th.printStackTrace();
                }
                continue;
            }
            int j = t + 1;
            while (j < logs.size()) {
                ILogEntry reducibleLog = logs.get(j);
                if (rule.applyRule(reducibleLog)) {
                    logs.remove(j);
                    continue;
                }
                ++j;
            }
            if (!rule.isReducingLogs()) continue;
            ILogEntry newLog = rule.getReducedLog();
            logs.set(t, newLog);
        }
    }
}

