/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.io;

import alma.acs.logging.io.FileChooserFilter;
import alma.acs.logging.io.LoadSwitchesPanel;
import alma.acs.logging.io.LogsFileChooser;
import com.cosylab.logging.LoggingClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class LoadFileChooser
extends LogsFileChooser
implements ActionListener {
    private JCheckBox viewHiddenFiles = new JCheckBox("Show hidden files", false);
    private LoadSwitchesPanel guiSwitches;
    private LoggingClient loggingClient = null;

    public LoadFileChooser(File currentDir, String title, String[] extensions, LoggingClient client) {
        super(title, currentDir, true, client.getLogFrame());
        this.loggingClient = client;
        this.setModal(true);
        this.initialize(currentDir);
        if (extensions != null && extensions.length > 0) {
            this.fileChooser.setFileFilter(new FileChooserFilter(extensions));
        }
        this.pack();
        this.setVisible(true);
    }

    private void initialize(File curDir) {
        this.rootPane.setLayout(new BorderLayout());
        this.guiSwitches = new LoadSwitchesPanel(this.loggingClient);
        JPanel pnl = new JPanel(new BorderLayout());
        this.viewHiddenFiles.addActionListener(this);
        pnl.add((Component)this.guiSwitches, "North");
        pnl.add((Component)this.viewHiddenFiles, "South");
        this.rootPane.add((Component)pnl, "North");
        if (curDir == null) {
            curDir = new File(".");
        }
        this.fileChooser = new JFileChooser(curDir);
        this.fileChooser.setFileHidingEnabled(!this.viewHiddenFiles.isSelected());
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.addActionListener(this);
        JFileChooser fcComponent = this.fileChooser;
        fcComponent.setOpaque(true);
        this.rootPane.add((Component)fcComponent, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.viewHiddenFiles) {
            this.fileChooser.setFileHidingEnabled(!this.viewHiddenFiles.isSelected());
            this.fileChooser.rescanCurrentDirectory();
        } else {
            super.actionPerformed(e);
        }
    }

    public void execute() {
        this.guiSwitches.execute();
    }
}

