/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private String[] extensions;

    public FileChooserFilter(String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            throw new IllegalArgumentException("Invalid extensions");
        }
        this.extensions = new String[extensions.length];
        System.arraycopy(extensions, 0, this.extensions, 0, extensions.length);
    }

    @Override
    public boolean accept(File f) {
        if (!f.canRead()) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String fileName = f.getAbsolutePath().toLowerCase();
        for (String ext : this.extensions) {
            if (!fileName.endsWith(ext.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder ret = new StringBuilder("Files of type ");
        for (String str : this.extensions) {
            ret.append('*');
            ret.append(str);
            ret.append(' ');
        }
        return ret.toString();
    }
}

