/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.errorbrowser;

import alma.acs.logging.table.LogEntryTableModelBase;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;

public class Engine
extends Thread {
    private final LogEntryTableModelBase srcModel;
    private final LogEntryTableModelBase dstModel;
    private final String stackId;
    private volatile boolean terminateThread;

    public Engine(LogEntryTableModelBase model, String stackID, LogEntryTableModelBase listener) {
        if (model == null) {
            throw new IllegalArgumentException("The source model can't be null");
        }
        this.srcModel = model;
        if (listener == null) {
            throw new IllegalArgumentException("The destination model can't be null");
        }
        this.dstModel = listener;
        if (stackID == null || stackID.isEmpty()) {
            throw new IllegalArgumentException("The STACK ID can't be null nor empty");
        }
        this.stackId = stackID;
        this.terminateThread = false;
        Thread t = new Thread(this);
        t.setName("ErrorBrowserEngine");
        t.setDaemon(true);
        t.start();
    }

    public void close() {
        this.terminateThread = true;
    }

    @Override
    public void run() {
        int t = 0;
        while ((long)t < this.srcModel.totalLogNumber() && !this.terminateThread) {
            ILogEntry log = this.srcModel.getVisibleLogEntry(t);
            if (log != null && this.stackId.equals((String)log.getField(LogField.STACKID))) {
                this.dstModel.appendLog(log);
            }
            ++t;
        }
    }
}

