/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs.main;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import alma.acs.logging.ClientLogManager;
import alma.acs.logging.dialogs.main.CommandLineParser;
import alma.acs.logging.dialogs.main.ShutdownHook;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.ACS.ACSLogConnectionListener;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.audience.Audience;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LogFrame
extends JFrame
implements WindowListener,
ACSLogConnectionListener {
    private volatile boolean closing = false;
    private LoggingClient loggingClient;
    private Logger logger;
    private ShutdownHook shutdownHook;
    private static final String online = "LoggingClient - Online";
    private static final String offline = "LoggingClient - Offline";
    private static final String connecting = "LoggingClient - Connecting...";

    public LogFrame(File filterFile, File engineFilterFile, String logFileName, LogTypeHelper discardLevel, boolean doNotConnect, boolean unlimited, Audience.AudienceInfo audienceInfo) {
        FiltersVector filters;
        this.setName(offline);
        this.logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("Logging client GUI", true);
        this.initShutdownHook();
        this.initialize(discardLevel, unlimited, audienceInfo);
        if (filterFile != null) {
            filters = new FiltersVector();
            try {
                filters.loadFilters(filterFile, true, null);
                this.loggingClient.getLogEntryTable().setFilters(filters, false);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(null, "Error: " + t.getMessage(), "Error loading filters", 0);
            }
        }
        if (engineFilterFile != null) {
            filters = new FiltersVector();
            try {
                filters.loadFilters(engineFilterFile, true, null);
                this.loggingClient.getEngine().setFilters(filters, false);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(null, "Error: " + t.getMessage(), "Error loading engine filters", 0);
            }
        }
        if (logFileName == null) {
            if (!doNotConnect) {
                this.loggingClient.connect();
            }
        } else {
            this.loggingClient.getLCModel1().loadFromFile(logFileName);
        }
        this.addWindowListener(this);
    }

    private void initialize(LogTypeHelper discardLevel, boolean unlimited, Audience.AudienceInfo aInfo) {
        this.setTitle("LoggingClient");
        this.addWindowListener(this);
        ImageIcon image = new ImageIcon(LogFrame.class.getResource("/alma.png"));
        this.setIconImage(image.getImage());
        this.loggingClient = new LoggingClient(this, LoggingClient.DEFAULT_LOGLEVEL, discardLevel, unlimited, aInfo);
        if (this.loggingClient == null) {
            throw new NullPointerException("The logging client is null");
        }
        this.setRootPane(this.loggingClient);
        this.loggingClient.hideExitMenu(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getSize();
        this.setLocation(Math.max(0, (screenSize.width - windowSize.width) / 2), Math.max(0, (screenSize.height - windowSize.height) / 2));
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        CommandLineParser parser = null;
        try {
            parser = new CommandLineParser(args);
        }
        catch (Throwable t) {
            CommandLineParser.printUsage(t.getMessage());
            System.exit(-1);
        }
        if (parser.getHelp()) {
            CommandLineParser.printUsage(null);
            return;
        }
        String initLogFileName = parser.getFileToLoad();
        String initFilterFileName = parser.getFilterFileName();
        String initEngineFilterFileName = parser.getEngineFilterFileName();
        boolean doNotConnect = parser.isDoNotConnect();
        boolean unlimited = parser.isUnlimited();
        Audience.AudienceInfo audienceInfo = parser.getAudience();
        LogTypeHelper initialDiscardLevel = parser.getDiscardLevel();
        File logFile = null;
        if (initLogFileName != null) {
            logFile = new File(initLogFileName);
            if (!logFile.exists()) {
                System.err.println("log file " + initLogFileName + " does not exist!");
                initLogFileName = null;
                System.exit(-1);
            }
            if (!logFile.canRead()) {
                System.err.println("log file " + initLogFileName + " is unreadable!");
                initLogFileName = null;
                System.exit(-1);
            }
        }
        File filterFile = null;
        if (initFilterFileName != null && !(filterFile = new File(initFilterFileName)).canRead()) {
            System.err.println("Filter file " + initFilterFileName + " is unreadable!");
            System.exit(-1);
        }
        File engineFilterFile = null;
        if (initEngineFilterFileName != null && !(engineFilterFile = new File(initEngineFilterFileName)).canRead()) {
            System.err.println("Filter file " + initFilterFileName + " is unreadable!");
            System.exit(-1);
        }
        try {
            class FrameLauncher
            extends Thread {
                private final File f;
                private final File ef;
                private final String name;
                private final boolean offline;
                private final LogTypeHelper discard;
                private final boolean noLimit;
                private final Audience.AudienceInfo aInfo;

                public FrameLauncher(File fltFile, File engfltFile, String initFileName, LogTypeHelper initDiscard, boolean noACS, boolean unlimit, Audience.AudienceInfo info) {
                    this.f = fltFile;
                    this.ef = engfltFile;
                    this.name = initFileName;
                    this.discard = initDiscard;
                    this.offline = noACS;
                    this.noLimit = unlimit;
                    this.aInfo = info;
                }

                @Override
                public void run() {
                    new LogFrame(this.f, this.ef, this.name, this.discard, this.offline, this.noLimit, this.aInfo);
                }
            }
            SwingUtilities.invokeLater(new FrameLauncher(filterFile, engineFilterFile, initLogFileName, initialDiscardLevel, doNotConnect, unlimited, audienceInfo));
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of LoggingFrame");
            exception.printStackTrace(System.err);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.loggingClient = null;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.closing) {
            return;
        }
        this.closeApplication();
    }

    public void closeApplication() {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogFrame.this.setVisible(false);
            }
        });
        this.closing = true;
        try {
            if (this.loggingClient != null) {
                this.loggingClient.stop();
            }
        }
        catch (Throwable t) {
            System.err.println("Exception caught while closing the logging client: " + t.getMessage());
            t.printStackTrace(System.err);
        }
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogFrame.this.dispose();
            }
        });
    }

    private void initShutdownHook() {
        this.shutdownHook = new ShutdownHook(this.logger, "Logging client GUI", this);
        Runtime.getRuntime().addShutdownHook((Thread)((Object)this.shutdownHook));
    }

    private void setFrameTitle(final String title) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogFrame.this.setTitle(title);
            }
        });
    }

    public void voidSetWorkingMode(boolean mode) {
        if (mode) {
            this.setFrameTitle(online);
        } else {
            this.setFrameTitle(offline);
        }
    }

    public void acsLogConnConnecting() {
        this.setFrameTitle(connecting);
    }

    public void acsLogConnDisconnected() {
        this.setFrameTitle(offline);
    }

    public void acsLogConnEstablished() {
        this.setFrameTitle(online);
    }

    public void acsLogConnLost() {
        this.setFrameTitle(offline);
    }

    public void acsLogConnSuspended() {
    }

    public void acsLogsDelay() {
    }

    public void reportStatus(String status) {
    }
}

