/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

class TstStarTable
extends StreamStarTable {
    private int ncol_;
    private static final Pattern COMMENT_REGEX;
    private static final Pattern BLANK_REGEX;
    private static final Pattern RULER_REGEX;
    private static final Pattern PARAM_REGEX;
    private static final Pattern EOD_REGEX;
    private static final Logger logger_;
    public static final ValueInfo DESCRIPTION_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TstStarTable(DataSource datsrc) throws IOException, TableFormatException {
        this.init(datsrc);
    }

    protected RowEvaluator.Metadata obtainMetadata() throws TableFormatException, IOException {
        List row;
        String line0;
        PushbackInputStream in = super.getInputStream();
        List lineList = TstStarTable.readHeaderLines(in);
        String ruler = (String)lineList.remove(lineList.size() - 1);
        String colsLine = (String)lineList.remove(lineList.size() - 1);
        if (!$assertionsDisabled && !RULER_REGEX.matcher(ruler).matches()) {
            throw new AssertionError();
        }
        List colNames = TstStarTable.tabSplit(colsLine);
        if (((String)colNames.get(colNames.size() - 1)).length() == 0) {
            colNames.remove(colNames.size() - 1);
        }
        this.ncol_ = colNames.size();
        if (colNames.size() != this.ncol_) {
            throw new TableFormatException("Ruler line and column name line have different numbers of tabs");
        }
        Object title = null;
        if (!(lineList.isEmpty() || COMMENT_REGEX.matcher(line0 = (String)lineList.get(0)).matches() || BLANK_REGEX.matcher(line0).matches() || PARAM_REGEX.matcher(line0).matches())) {
            this.setName(((String)lineList.remove(0)).trim());
        }
        int idIndex = 0;
        int raIndex = 1;
        int decIndex = 2;
        int xIndex = -1;
        int yIndex = -1;
        ArrayList<DescribedValue> paramList = new ArrayList<DescribedValue>();
        Iterator it = lineList.iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            Matcher pmatcher = PARAM_REGEX.matcher(line);
            if (COMMENT_REGEX.matcher(line).matches() || !pmatcher.matches()) continue;
            String pname = pmatcher.group(1);
            String pval = pmatcher.group(2);
            if ("id_col".equalsIgnoreCase(pname)) {
                idIndex = TstStarTable.parseColumnIndex(pval, this.ncol_);
                it.remove();
                continue;
            }
            if ("ra_col".equalsIgnoreCase(pname)) {
                raIndex = TstStarTable.parseColumnIndex(pval, this.ncol_);
                it.remove();
                continue;
            }
            if ("dec_col".equalsIgnoreCase(pname)) {
                decIndex = TstStarTable.parseColumnIndex(pval, this.ncol_);
                it.remove();
                continue;
            }
            if ("x_col".equalsIgnoreCase(pname)) {
                xIndex = TstStarTable.parseColumnIndex(pval, this.ncol_);
                it.remove();
                continue;
            }
            if ("y_col".equalsIgnoreCase(pname)) {
                yIndex = TstStarTable.parseColumnIndex(pval, this.ncol_);
                it.remove();
                continue;
            }
            DescribedValue param = TstStarTable.createDescribedValue(pname, pval);
            if (param != null) {
                paramList.add(param);
            }
            it.remove();
        }
        StringBuffer descBuf = new StringBuffer();
        Iterator it2 = lineList.iterator();
        while (it2.hasNext()) {
            String line = (String)it2.next();
            if (COMMENT_REGEX.matcher(line).matches() || BLANK_REGEX.matcher(line).matches()) continue;
            if (descBuf.length() != 0) {
                descBuf.append('\n');
            }
            descBuf.append(line);
        }
        String description = descBuf.toString();
        if (description.trim().length() > 0) {
            paramList.add(new DescribedValue(DESCRIPTION_INFO, description));
        }
        this.setParameters(paramList);
        RowEvaluator evaluator = new RowEvaluator(this.ncol_);
        while ((row = this.readRow(in)) != null) {
            evaluator.submitRow(row);
        }
        RowEvaluator.Metadata metadata = evaluator.getMetadata();
        ColumnInfo[] colInfos = metadata.colInfos_;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            colInfos[icol].setName((String)colNames.get(icol));
        }
        if (raIndex >= 0) {
            ColumnInfo info = colInfos[raIndex];
            info.setUCD("pos.eq.ra");
            if (Number.class.isAssignableFrom(info.getContentClass())) {
                info.setUnitString("deg");
            }
        }
        if (decIndex >= 0) {
            ColumnInfo info = colInfos[decIndex];
            info.setUCD("pos.eq.dec");
            if (Number.class.isAssignableFrom(info.getContentClass())) {
                info.setUnitString("deg");
            }
        }
        if (idIndex >= 0) {
            ColumnInfo info = colInfos[idIndex];
            colInfos[idIndex].setUCD("meta.id");
        }
        if (xIndex >= 0) {
            colInfos[xIndex].setUCD("pos.cartesian.x");
        }
        if (yIndex >= 0) {
            colInfos[yIndex].setUCD("pos.cartesian.y");
        }
        return metadata;
    }

    protected PushbackInputStream getInputStream() throws IOException {
        PushbackInputStream in = super.getInputStream();
        TstStarTable.readHeaderLines(in);
        return in;
    }

    protected List readRow(PushbackInputStream in) throws TableFormatException, IOException {
        StringBuffer sbuf = new StringBuffer();
        String line = null;
        block4: while (line == null) {
            char c = (char)in.read();
            switch (c) {
                case '\uffff': {
                    if (sbuf.length() == 0) {
                        return null;
                    }
                }
                case '\n': 
                case '\r': {
                    if (sbuf.length() <= 0) continue block4;
                    line = sbuf.toString();
                    continue block4;
                }
            }
            sbuf.append(c);
        }
        if (EOD_REGEX.matcher(line).matches()) {
            return null;
        }
        List words = TstStarTable.tabSplit(line);
        if (words.size() == this.ncol_ + 1 && ((String)words.get(this.ncol_)).length() == 0) {
            words.remove(this.ncol_);
        }
        if (words.size() != this.ncol_) {
            throw new TableFormatException("Wrong number of fields (" + words.size() + " != " + this.ncol_ + ") for line: " + line);
        }
        return words;
    }

    private static List readHeaderLines(InputStream in) throws TableFormatException, IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        while (lineList.size() < 10000) {
            String line = TstStarTable.readHeaderLine(in);
            lineList.add(line);
            if (!RULER_REGEX.matcher(line).matches()) continue;
            return lineList;
        }
        throw new TableFormatException("Header looks too long for TST");
    }

    private static String readHeaderLine(InputStream in) throws TableFormatException, IOException {
        StringBuffer sbuf = new StringBuffer();
        while (sbuf.length() < 0x100000) {
            char c = (char)in.read();
            switch (c) {
                case '\uffff': {
                    if (sbuf.length() == 0) {
                        throw new TableFormatException("No TST rows");
                    }
                }
                case '\n': 
                case '\r': {
                    return sbuf.toString();
                }
            }
            sbuf.append(c);
        }
        throw new TableFormatException("Too long for a line in a TST table");
    }

    private static List tabSplit(String line) {
        ArrayList<String> fields = new ArrayList<String>();
        int start = 0;
        while (start >= 0) {
            int end = line.indexOf(9, start);
            if (end >= 0) {
                fields.add(line.substring(start, end));
                start = end + 1;
                continue;
            }
            fields.add(line.substring(start));
            break;
        }
        return fields;
    }

    private static int parseColumnIndex(String txt, int ncol) {
        Integer index;
        try {
            int ix = Integer.parseInt(txt.trim());
            index = ix >= -1 && ix < ncol ? new Integer(ix) : null;
        }
        catch (NumberFormatException e) {
            index = null;
        }
        if (index == null) {
            logger_.warning("Bad value \"" + txt + "\" for column index - " + "using -1");
            return -1;
        }
        return index;
    }

    private static DescribedValue createDescribedValue(String name, String sval) {
        RowEvaluator re1 = new RowEvaluator(1);
        try {
            re1.submitRow(Collections.singletonList(sval));
            RowEvaluator.Metadata meta1 = re1.getMetadata();
            DefaultValueInfo info = new DefaultValueInfo(meta1.colInfos_[0]);
            info.setName(name);
            Object value = sval == null || sval.trim().length() == 0 ? null : meta1.decoders_[0].decode(sval);
            return new DescribedValue(info, value);
        }
        catch (TableFormatException e) {
            logger_.warning("Failed to parse parameter " + name + ": " + sval);
            return null;
        }
    }

    static {
        $assertionsDisabled = !TstStarTable.class.desiredAssertionStatus();
        COMMENT_REGEX = Pattern.compile("^\\s*#.*");
        BLANK_REGEX = Pattern.compile("^\\s*$");
        RULER_REGEX = Pattern.compile("^[\\t\\-]*-[\\t\\-]*$");
        PARAM_REGEX = Pattern.compile("^(\\S+):\\s*(.*)");
        EOD_REGEX = Pattern.compile("^\\s*\\[EOD\\]\\s*$");
        logger_ = Logger.getLogger("uk.ac.starlink.table.formats");
        DESCRIPTION_INFO = new DefaultValueInfo("Description", String.class, "Free text description of the table");
    }
}

