/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.BitSet;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class RowSubsetStarTable
extends WrapperStarTable {
    private BitSet mask;

    public RowSubsetStarTable(StarTable baseTable) {
        this(baseTable, new BitSet());
    }

    public RowSubsetStarTable(StarTable baseTable, BitSet mask) {
        super(baseTable);
        this.mask = mask;
    }

    public BitSet getMask() {
        return this.mask;
    }

    public void setMask(BitSet mask) {
        this.mask = mask;
    }

    public boolean isRandom() {
        return false;
    }

    public long getRowCount() {
        return this.mask.cardinality();
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(this.baseTable.getRowSequence()){
            int iBase;
            {
                this.iBase = -1;
            }

            public boolean next() throws IOException {
                int leng = RowSubsetStarTable.this.mask.length();
                while (!RowSubsetStarTable.this.mask.get(this.iBase + 1)) {
                    if (this.iBase + 1 >= leng) {
                        return false;
                    }
                    super.next();
                    ++this.iBase;
                }
                super.next();
                ++this.iBase;
                return true;
            }
        };
    }
}

