/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot.AxisLabeller;
import uk.ac.starlink.ttools.plot.DataBounds;
import uk.ac.starlink.ttools.plot.Plot3D;
import uk.ac.starlink.ttools.plot.Plot3DState;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotVolume;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.SphericalPlotState;

public class SphericalPlot3D
extends Plot3D {
    private double[][][] sphereGrid_;
    private double lastRadius_;
    private int lastScale_;
    private static final int LATITUDE_GRID_LINES = 2;
    private static final int LONGITUDE_GRID_LINES = 12;
    private static final int SPHERE_PAD = 8;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Plot3D.RangeChecker configureRanges(Plot3DState state) {
        double rmax = state.getRanges()[0][1];
        this.loBounds_ = new double[3];
        this.hiBounds_ = new double[3];
        Arrays.fill(this.loBounds_, -rmax);
        Arrays.fill(this.hiBounds_, rmax);
        this.loBoundsG_ = (double[])this.loBounds_.clone();
        this.hiBoundsG_ = (double[])this.hiBounds_.clone();
        final double range2 = rmax * rmax * 1.0001;
        return new Plot3D.RangeChecker(){

            boolean inRange(double[] coords) {
                return coords[0] * coords[0] + coords[1] * coords[1] + coords[2] * coords[2] <= range2;
            }
        };
    }

    protected double getPadding(Plot3DState state, Graphics g, int[] padBorders) {
        Arrays.fill(padBorders, 8);
        SphericalPlotState sstate = (SphericalPlotState)state;
        if (sstate.getRadialInfo() != null && sstate.getZoomScale() == 1.0) {
            int n = this.annotateAtSide() ? 0 : 2;
            padBorders[n] = padBorders[n] + (g.getFontMetrics().getHeight() * 2 + 8);
        }
        return 1.0;
    }

    public DataBounds calculateBounds(PlotData data, PlotState state) {
        int iaux;
        boolean hasRadial = ((SphericalPlotState)state).getRadialInfo() != null;
        int ndim = data.getNdim();
        int naux = ndim - 3;
        Range[] auxRanges = new Range[naux];
        for (int iaux2 = 0; iaux2 < naux; ++iaux2) {
            auxRanges[iaux2] = new Range();
        }
        int nset = data.getSetCount();
        int[] npoints = new int[nset];
        PointSequence pseq = data.getPointSequence();
        int ip = 0;
        double r2max = 0.0;
        while (pseq.next()) {
            boolean isUsed = false;
            for (int iset = 0; iset < nset; ++iset) {
                if (!pseq.isIncluded(iset)) continue;
                isUsed = true;
                int n = iset;
                npoints[n] = npoints[n] + 1;
            }
            if (!isUsed) continue;
            if (hasRadial || naux > 0) {
                double r2;
                double[] coords = pseq.getPoint();
                boolean isValid = true;
                for (int idim = 0; idim < 3 && isValid; ++idim) {
                    isValid = isValid && !Double.isNaN(coords[idim]) && !Double.isInfinite(coords[idim]);
                }
                if (!isValid) continue;
                if (hasRadial && (r2 = coords[0] * coords[0] + coords[1] * coords[1] + coords[2] * coords[2]) > r2max) {
                    r2max = r2;
                }
                for (iaux = 0; iaux < naux; ++iaux) {
                    auxRanges[iaux].submit(coords[iaux + 3]);
                }
                ++ip;
                continue;
            }
            ++ip;
        }
        pseq.close();
        double rmax = hasRadial ? Math.sqrt(r2max) : 1.0;
        Range[] ranges = new Range[1 + naux];
        ranges[0] = new Range(0.0, rmax);
        for (iaux = 0; iaux < naux; ++iaux) {
            ranges[1 + iaux] = auxRanges[iaux];
        }
        return new DataBounds(ranges, ip, npoints);
    }

    protected boolean frontOnly(Plot3DState state) {
        SphericalPlotState sstate = (SphericalPlotState)state;
        return sstate.getZoomScale() > 2.0 && sstate.getRadialInfo() == null;
    }

    protected boolean[] get3DLogFlags() {
        return new boolean[3];
    }

    protected void plotAxes(Plot3DState state, Graphics g, Plot3D.Transformer3D trans, PlotVolume vol, boolean front) {
        if (state.getZoomScale() > 100.0) {
            return;
        }
        Color col = g.getColor();
        int scale = vol.getScale();
        double radius = this.hiBoundsG_[0];
        if (this.sphereGrid_ == null || scale != this.lastScale_ || radius != this.lastRadius_) {
            this.sphereGrid_ = SphericalPlot3D.calculateSphericalGrid(scale, radius);
            this.lastScale_ = scale;
            this.lastRadius_ = radius;
        }
        double[][][] grid = this.sphereGrid_;
        int nline = grid.length;
        for (int iline = 0; iline < nline; ++iline) {
            g.setColor(front ? Color.DARK_GRAY : Color.LIGHT_GRAY);
            double[][] line = grid[iline];
            int np = line.length;
            int[] xp = new int[np];
            int[] yp = new int[np];
            int ipoint = 0;
            double[] point = new double[3];
            for (int ip = 0; ip < np; ++ip) {
                System.arraycopy(line[ip], 0, point, 0, 3);
                trans.transform(point);
                if (point[2] < 0.5 == front || point[2] == 0.5) {
                    xp[ipoint] = vol.projectX(point[0]);
                    yp[ipoint] = vol.projectY(point[1]);
                    ++ipoint;
                    continue;
                }
                if (ipoint <= 0) continue;
                if (ipoint < np) {
                    xp[ipoint] = vol.projectX(point[0]);
                    yp[ipoint] = vol.projectY(point[1]);
                    ++ipoint;
                }
                g.drawPolyline(xp, yp, ipoint);
                ipoint = 0;
            }
            if (ipoint <= 0) continue;
            if (ipoint < np) {
                xp[ipoint] = vol.projectX(point[0]);
                yp[ipoint] = vol.projectY(point[1]);
                ++ipoint;
            }
            g.drawPolyline(xp, yp, ipoint);
            ipoint = 0;
        }
        g.setColor(col);
        SphericalPlotState sstate = (SphericalPlotState)this.getState();
        if (sstate.getRadialInfo() != null && sstate.getZoomScale() == 1.0) {
            boolean log = sstate.getRadialLog();
            double[] d0 = new double[]{0.0, 0.0, 0.0};
            trans.transform(d0);
            int xp0 = vol.projectX(d0[0]);
            int yp0 = vol.projectY(d0[1]);
            int xp1 = xp0 + scale / 2;
            int yp1 = yp0 + scale / 2 + 8;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(Color.BLACK);
            if (this.annotateAtSide()) {
                g2.rotate(1.5707963267948966, xp0, yp0);
            }
            g2.translate(xp0, yp1);
            g2.drawLine(0, 0, xp1 - xp0, 0);
            double rad = this.hiBounds_[0];
            new AxisLabeller(sstate.getAxisLabels()[0], log ? Math.exp(0.0) : 0.0, log ? Math.exp(rad) : rad, xp1 - xp0, log, false, g2.getFontMetrics(), AxisLabeller.X, 6, xp1 - xp0, 8).annotateAxis(g2);
        }
    }

    private boolean annotateAtSide() {
        Rectangle plotBounds = this.getPlotBounds();
        return plotBounds.width - plotBounds.height > 16;
    }

    private static double[][][] calculateSphericalGrid(int scale, double radius) {
        int nLat = 2;
        int nLong = 12;
        double tolerance = 0.5;
        double[][][] grid = new double[17][][];
        int np = (int)Math.ceil(1.5707963267948966 * Math.sqrt((double)scale / 0.5));
        for (int il = 0; il < 13; ++il) {
            grid[il] = new double[np * 4 + 1][];
        }
        double dTheta = 1.5707963267948966 / (double)np;
        double dPhi = 0.5235987755982988;
        double[] cosPhis = new double[12];
        double[] sinPhis = new double[12];
        for (int iLong = 0; iLong < 12; ++iLong) {
            double phi = (double)iLong * dPhi;
            cosPhis[iLong] = Math.cos(phi);
            sinPhis[iLong] = Math.sin(phi);
        }
        for (int ip = 0; ip <= np; ++ip) {
            double theta = (double)ip * dTheta;
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            int iLong = 0;
            while (iLong < 12) {
                int il = iLong++;
                double x = radius * (cosTheta * cosPhis[il]);
                double y = radius * (cosTheta * sinPhis[il]);
                double z = radius * sinTheta;
                int ip0 = 0 * np + ip;
                int ip1 = 2 * np - ip - 1;
                int ip2 = 2 * np + ip;
                int ip3 = 4 * np - ip - 1;
                grid[il][ip0] = new double[]{x, y, z};
                grid[il][ip1] = new double[]{-x, -y, z};
                grid[il][ip2] = new double[]{-x, -y, -z};
                grid[il][ip3] = new double[]{x, y, -z};
            }
            double x = radius * cosTheta;
            double y = radius * sinTheta;
            int ip0 = 0 * np + ip;
            int ip1 = 2 * np - ip - 1;
            int ip2 = 2 * np + ip;
            int ip3 = 4 * np - ip - 1;
            int il = 12;
            grid[il][ip0] = new double[]{x, y, 0.0};
            grid[il][ip1] = new double[]{-x, y, 0.0};
            grid[il][ip2] = new double[]{-x, -y, 0.0};
            grid[il][ip3] = new double[]{x, -y, 0.0};
        }
        double dTheta2 = 0.5235987755982988;
        for (int iLat = 0; iLat < 2; ++iLat) {
            double theta = (double)(iLat + 1) * dTheta2;
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double r = radius * sinTheta;
            int np2 = (int)Math.ceil(1.5707963267948966 * Math.sqrt((double)scale * cosTheta / 0.5));
            double dPhi2 = 1.5707963267948966 / (double)np2;
            for (int iup = 0; iup < 2; ++iup) {
                int il = 13 + iLat * 2 + iup;
                grid[il] = new double[np2 * 4 + 1][];
            }
            for (int ip = 0; ip < np2; ++ip) {
                double phi = (double)ip * dPhi2;
                double x = r * Math.cos(phi);
                double y = r * Math.sin(phi);
                int ip0 = 0 * np2 + ip;
                int ip1 = 2 * np2 - ip - 1;
                int ip2 = 2 * np2 + ip;
                int ip3 = 4 * np2 - ip - 1;
                for (int iup = 0; iup < 2; ++iup) {
                    int il = 13 + iLat * 2 + iup;
                    double z = iup == 0 ? radius * cosTheta : -radius * cosTheta;
                    grid[il][ip0] = new double[]{x, y, z};
                    grid[il][ip1] = new double[]{-x, y, z};
                    grid[il][ip2] = new double[]{-x, -y, z};
                    grid[il][ip3] = new double[]{x, -y, z};
                }
            }
        }
        for (int il = 0; il < grid.length; ++il) {
            double[][] line = grid[il];
            if (!$assertionsDisabled && line[line.length - 1] != null) {
                throw new AssertionError();
            }
            line[line.length - 1] = line[0];
        }
        return grid;
    }

    static {
        $assertionsDisabled = !SphericalPlot3D.class.desiredAssertionStatus();
    }
}

