/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.Coner;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.vo.ConeSearch;

public class ConeSearchConer
implements Coner {
    private final Parameter urlParam_ = new Parameter("serviceurl");
    private final ChoiceParameter verbParam_;
    private final BooleanParameter believeemptyParam_;
    private static final Logger logger;
    private static final String BELIEVE_EMPTY_NAME = "emptyok";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Number;

    public ConeSearchConer() {
        this.urlParam_.setPrompt("Base URL for query returning VOTable");
        this.urlParam_.setDescription(new String[]{"<p>The base part of a URL which defines the queries to be made.", "Additional parameters will be appended to this using CGI syntax", "(\"<code>name=value</code>\", separated by '&amp;' characters).", "If this value does not end in either a '?' or a '&amp;',", "one will be added as appropriate.", "</p>", "<p>See <ref id='coneService'/> for discussion of how to locate", "service URLs corresponding to given datasets.", "</p>"});
        this.verbParam_ = new ChoiceParameter("verb", (Object[])new String[]{"1", "2", "3"});
        this.verbParam_.setNullPermitted(true);
        this.verbParam_.setPrompt("Verbosity level of search responses (1..3)");
        this.verbParam_.setDescription(new String[]{"<p>Verbosity level of the tables returned by the query service.", "A value of 1 indicates the bare minimum and", "3 indicates all available information.", "</p>"});
        this.believeemptyParam_ = new BooleanParameter(BELIEVE_EMPTY_NAME);
        this.believeemptyParam_.setDefault("true");
        this.believeemptyParam_.setPrompt("Believe metadata from empty results?");
        this.believeemptyParam_.setDescription(new String[]{"<p>Whether the table metadata which is returned from a search", "result with zero rows is to be believed.", "According to the spirit, though not the letter, of the", "cone search standard, a cone search service which returns no data", "ought nevertheless to return the correct column headings.", "Unfortunately this is not always the case.", "If this parameter is set <code>true</code>, it is assumed", "that the service behaves properly in this respect; if it does not", "an error may result.  In that case, set this parameter", "<code>false</code>.  A consequence of setting it false is that", "in the event of no results being returned, the task will", "return no table at all, rather than an empty one.", "</p>"});
    }

    public String getSkySystem() {
        return "ICRS";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.urlParam_, this.verbParam_, this.believeemptyParam_};
    }

    public ConeSearcher createSearcher(Environment env, boolean bestOnly) throws TaskException {
        int verb;
        String url;
        try {
            url = this.urlParam_.stringValue(env);
        }
        catch (IllegalArgumentException e) {
            throw new ParameterValueException(this.urlParam_, e.getMessage(), (Throwable)e);
        }
        String sverb = this.verbParam_.stringValue(env);
        boolean believeEmpty = this.believeemptyParam_.booleanValue(env);
        if (sverb == null) {
            verb = -1;
        } else {
            try {
                verb = Integer.parseInt(sverb);
            }
            catch (NumberFormatException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw new ParameterValueException((Parameter)this.verbParam_, e.getMessage(), (Throwable)e);
            }
        }
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        return new ServiceSearcher(new ConeSearch(url), verb, believeEmpty, tfact);
    }

    static {
        $assertionsDisabled = !ConeSearchConer.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.ttools.cone");
    }

    private static class ServiceSearcher
    implements ConeSearcher {
        private final ConeSearch csearch_;
        private final int verb_;
        private final boolean believeEmpty_;
        private final StarTableFactory tfact_;
        private Class[] colTypes_;
        private boolean warned_;

        ServiceSearcher(ConeSearch csearch, int verb, boolean believeEmpty, StarTableFactory tfact) {
            this.csearch_ = csearch;
            this.verb_ = verb;
            this.believeEmpty_ = believeEmpty;
            this.tfact_ = tfact;
        }

        public StarTable performSearch(double ra, double dec, double sr) throws IOException {
            StarTable result;
            StarTable table = this.csearch_.performSearch(ra, dec, sr, this.verb_, this.tfact_);
            table = Tables.randomTable((StarTable)table);
            Object object = result = this.believeEmpty_ || !ServiceSearcher.isEmpty(table) ? table : null;
            if (result != null && !this.warned_) {
                if (this.colTypes_ == null) {
                    this.colTypes_ = ServiceSearcher.getColumnTypes(result);
                } else if (!Arrays.equals(this.colTypes_, ServiceSearcher.getColumnTypes(result))) {
                    String msg = "Different queries to the same cone search return incompatible tables";
                    if (this.believeEmpty_) {
                        msg = msg + " - try emptyok=false";
                    }
                    logger.warning(msg);
                    this.warned_ = true;
                }
            }
            return result;
        }

        public int getRaIndex(StarTable result) {
            ColumnInfo info;
            int icol;
            for (icol = 0; icol < result.getColumnCount(); ++icol) {
                info = result.getColumnInfo(icol);
                if (!"POS_EQ_RA_MAIN".equals(info.getUCD())) continue;
                if ((class$java$lang$Number == null ? ConeSearchConer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(info.getContentClass())) {
                    return icol;
                }
                logger.warning("Non-numeric POS_EQ_RA_MAIN column");
            }
            logger.warning("No POS_EQ_RA_MAIN column (service violates SCS 1.02 standard) - clutching at straws");
            for (icol = 0; icol < result.getColumnCount(); ++icol) {
                if (!(class$java$lang$Number == null ? ConeSearchConer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom((info = result.getColumnInfo(icol)).getContentClass())) continue;
                String ucd = info.getUCD();
                String name = info.getName();
                if (ucd != null && ucd.startsWith("pos.eq.ra")) {
                    return icol;
                }
                if (name == null || !name.equalsIgnoreCase("ra") && !name.equalsIgnoreCase("ra2000")) continue;
                return icol;
            }
            return -1;
        }

        public int getDecIndex(StarTable result) {
            ColumnInfo info;
            int icol;
            for (icol = 0; icol < result.getColumnCount(); ++icol) {
                info = result.getColumnInfo(icol);
                if (!"POS_EQ_DEC_MAIN".equals(info.getUCD())) continue;
                if ((class$java$lang$Number == null ? ConeSearchConer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(info.getContentClass())) {
                    return icol;
                }
                logger.warning("Non-numeric POS_EQ_DEC_MAIN column");
            }
            logger.warning("No POS_EQ_DEC_MAIN column (service violates SCS 1.02 standard) - clutching at straws");
            for (icol = 0; icol < result.getColumnCount(); ++icol) {
                if (!(class$java$lang$Number == null ? ConeSearchConer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom((info = result.getColumnInfo(icol)).getContentClass())) continue;
                String ucd = info.getUCD();
                String name = info.getName();
                if (ucd != null && ucd.startsWith("pos.eq.dec")) {
                    return icol;
                }
                if (name == null || !name.equalsIgnoreCase("dec") && !name.equalsIgnoreCase("dec2000")) continue;
                return icol;
            }
            return -1;
        }

        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isEmpty(StarTable table) throws IOException {
            long nr = table.getRowCount();
            if (nr >= 0L) {
                return nr == 0L;
            }
            RowSequence rseq = table.getRowSequence();
            try {
                boolean bl = rseq.next();
                return bl;
            }
            finally {
                rseq.close();
            }
        }

        private static Class[] getColumnTypes(StarTable table) {
            int ncol = table.getColumnCount();
            Class[] types = new Class[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                types[icol] = table.getColumnInfo(icol).getContentClass();
            }
            return types;
        }
    }
}

