/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.connector.CenterSite;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.BasicGrabHandleFactory;
import diva.canvas.interactor.CircleGeometry;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.GrabHandleFactory;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.Manipulator;
import diva.canvas.interactor.MoveHandle;
import java.util.Iterator;

public class CircleManipulator
extends Manipulator {
    private CircleGeometry _geometry;
    private Interactor _dragInteractor = null;

    public CircleManipulator() {
        this(new BasicGrabHandleFactory());
    }

    public CircleManipulator(GrabHandleFactory f) {
        this.setGrabHandleFactory(f);
        this.setHandleInteractor(new Resizer());
    }

    private CircleGeometry getGeometry() {
        return this._geometry;
    }

    public FigureDecorator newInstance(Figure f) {
        CircleManipulator m = new CircleManipulator();
        m.setGrabHandleFactory(this.getGrabHandleFactory());
        m.setHandleInteractor(this.getHandleInteractor());
        m.setDragInteractor(this._dragInteractor);
        return m;
    }

    public void refresh() {
        if (this._geometry != null) {
            this._geometry.setBounds(this.getChild().getBounds());
        }
    }

    public void setChild(Figure child) {
        super.setChild(child);
        this.clearGrabHandles();
        if (child != null) {
            this._geometry = new CircleGeometry(this, this.getChild().getBounds());
            Iterator i = this._geometry.sites();
            GrabHandle g = null;
            while (i.hasNext()) {
                Site site = (Site)i.next();
                g = this.getGrabHandleFactory().createGrabHandle(site);
                g.setParent(this);
                g.setInteractor(this.getHandleInteractor());
                this.addGrabHandle(g);
            }
            if (this._dragInteractor != null) {
                CenterSite center = new CenterSite(this.getChild());
                MoveHandle mover = new MoveHandle(center);
                mover.setParent(this);
                mover.setInteractor(this._dragInteractor);
                this.addGrabHandle(mover);
            }
            this.relocateGrabHandles();
            this._geometry.setMinimumSize(4.0f * g.getSize());
        }
    }

    public void setDragInteractor(Interactor dragger) {
        this._dragInteractor = dragger;
    }

    private static class Resizer
    extends DragInteractor {
        private Resizer() {
        }

        public void translate(LayerEvent e, double x, double y) {
            GrabHandle g = (GrabHandle)e.getFigureSource();
            g.translate(x, y);
            CircleManipulator parent = (CircleManipulator)g.getParent();
            CircleGeometry geometry = parent.getGeometry();
            parent.getChild().transform(CanvasUtilities.computeTransform(parent.getChild().getBounds(), geometry.getBounds()));
        }
    }
}

