/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsky.util.Preferences;
import jsky.util.ProxyServerUtil;
import jsky.util.gui.DialogUtil;

public class ProxyServerDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JTextField httpProxyServerField = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField httpProxyPortField = new JTextField();
    JTextArea jTextArea2 = new JTextArea();
    JLabel jLabel3 = new JLabel();
    JTextField nonProxyHostsField = new JTextField();
    JPanel jPanel1 = new JPanel();
    JButton cancelButton = new JButton();
    JButton applyButton = new JButton();
    JButton resetButton = new JButton();
    JButton okButton = new JButton();
    JLabel jLabel4 = new JLabel();
    JTextField httpsProxyServerField = new JTextField();
    JLabel jLabel5 = new JLabel();
    JTextField httpsProxyPortField = new JTextField();

    public ProxyServerDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.reset();
        Preferences.manageLocation(this);
    }

    public ProxyServerDialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("If your host is behind a firewall, you may need to use a proxy server to access remote catalogs via HTTP. Please enter the hostname and port number for the proxy server:");
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jLabel1.setLabelFor(this.httpProxyServerField);
        this.jLabel1.setText("HTTP Proxy Server:");
        this.jLabel2.setLabelFor(this.httpProxyPortField);
        this.jLabel2.setText("Port:");
        this.jTextArea2.setEditable(false);
        this.jTextArea1.setBackground(this.jLabel2.getBackground());
        this.jTextArea2.setBackground(this.jLabel2.getBackground());
        this.jTextArea2.setText("The value below can be a list of hosts, each seperated by a |. In addition, a wildcard character (*) can be used for matching. For example: *.foo.com|localhost :");
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setWrapStyleWord(true);
        this.jLabel3.setLabelFor(this.nonProxyHostsField);
        this.jLabel3.setText("No Proxy for:");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.applyButton_actionPerformed(e);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.resetButton_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.okButton_actionPerformed(e);
            }
        });
        this.setTitle("Proxy Server");
        this.panel1.setMinimumSize(new Dimension(521, 230));
        this.panel1.setPreferredSize(new Dimension(521, 230));
        this.jLabel4.setText("HTTPS Proxy Server:");
        this.jLabel5.setText("Port:");
        this.httpsProxyServerField.setText("");
        this.httpsProxyPortField.setText("");
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jTextArea1, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.httpProxyServerField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.httpProxyPortField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jTextArea2, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.nonProxyHostsField, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 14, 0, new Insets(17, 11, 11, 11), 0, 0));
        this.jPanel1.add((Component)this.okButton, null);
        this.jPanel1.add((Component)this.resetButton, null);
        this.jPanel1.add((Component)this.applyButton, null);
        this.jPanel1.add((Component)this.cancelButton, null);
        this.panel1.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.httpsProxyServerField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.jLabel5, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.httpsProxyPortField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jLabel2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 14, 2, new Insets(11, 11, 0, 0), 0, 0));
    }

    void okButton_actionPerformed(ActionEvent e) {
        if (this.apply()) {
            this.close();
        }
    }

    void resetButton_actionPerformed(ActionEvent e) {
        this.reset();
    }

    void applyButton_actionPerformed(ActionEvent e) {
        this.apply();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.close();
    }

    public boolean apply() {
        String httpProxyHost = this.httpProxyServerField.getText();
        int httpProxyPort = 80;
        String httpsProxyHost = this.httpsProxyServerField.getText();
        int httpsProxyPort = 443;
        String s = this.httpProxyPortField.getText();
        if (s != null && s.length() != 0) {
            try {
                httpProxyPort = Integer.parseInt(this.httpProxyPortField.getText());
            }
            catch (Exception e) {
                DialogUtil.error("Please enter a valid HTTP proxy port number.");
                return false;
            }
        }
        if ((s = this.httpsProxyPortField.getText()) != null && s.length() != 0) {
            try {
                httpsProxyPort = Integer.parseInt(this.httpsProxyPortField.getText());
            }
            catch (Exception e) {
                DialogUtil.error("Please enter a valid HTTPS proxy port number.");
                return false;
            }
        }
        String nonProxyHosts = this.nonProxyHostsField.getText();
        ProxyServerUtil.setProxy(httpProxyHost, httpProxyPort, httpsProxyHost, httpsProxyPort, nonProxyHosts, nonProxyHosts);
        return true;
    }

    public void reset() {
        String httpProxyHost = ProxyServerUtil.getHttpProxyHost();
        if (httpProxyHost == null) {
            httpProxyHost = "";
        }
        int httpProxyPort = ProxyServerUtil.getHttpProxyPort();
        String httpsProxyHost = ProxyServerUtil.getHttpsProxyHost();
        if (httpsProxyHost == null) {
            httpsProxyHost = "";
        }
        int httpsProxyPort = ProxyServerUtil.getHttpsProxyPort();
        String nonProxyHosts = ProxyServerUtil.getHttpNonProxyHosts();
        if (nonProxyHosts == null) {
            nonProxyHosts = "";
        }
        this.httpProxyServerField.setText(httpProxyHost);
        this.httpProxyPortField.setText("" + httpProxyPort);
        this.httpsProxyServerField.setText(httpsProxyHost);
        this.httpsProxyPortField.setText("" + httpsProxyPort);
        this.nonProxyHostsField.setText(nonProxyHosts);
    }

    public void close() {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        ProxyServerUtil.init();
        new ProxyServerDialog(){

            @Override
            public void close() {
                System.exit(0);
            }
        }.setVisible(true);
    }
}

