/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jsky.science.Coordinates;
import jsky.science.CoordinatesOffset;
import jsky.util.FormatUtilities;

public class CoordinatesOffsetPanel
extends JComponent
implements ActionListener,
PropertyChangeListener {
    protected JLabel fRaLabel;
    protected JLabel fDecLabel;
    protected JLabel fRaUnits;
    protected JLabel fDecUnits;
    protected JTextField fRaField;
    protected JTextField fDecField;
    protected CoordinatesOffset fOldOffset;
    protected String fFormatString;
    protected int fOrientation;
    protected static final String RAOFFSET_PROPERTY = "RAOffset".intern();
    protected static final String DECOFFSET_PROPERTY = "DECOffset".intern();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String COORDINATES_OFFSET_PROPERTY = "CoordinatesOffset".intern();
    public static final String READ_ONLY_PROPERTY = "ReadOnly".intern();
    public static final String ORIENTATION_PROPERTY = "Orientation".intern();
    GridBagConstraints constraint = new GridBagConstraints();

    public CoordinatesOffsetPanel() {
        this.setLayout(new GridBagLayout());
        this.fRaLabel = new JLabel("RA:");
        this.fRaField = new JTextField(8);
        String tooltip = "Offset formats should be: +/-##.##, units are arcsec";
        this.fRaLabel.setToolTipText(tooltip);
        this.fRaField.setToolTipText(tooltip);
        this.fRaUnits = new JLabel("arcsec");
        this.fDecLabel = new JLabel("Dec:");
        this.fDecField = new JTextField(8);
        this.fDecLabel.setToolTipText(tooltip);
        this.fDecField.setToolTipText(tooltip);
        this.fDecUnits = new JLabel("arcsec");
        this.fRaField.setActionCommand(RAOFFSET_PROPERTY);
        this.fRaField.addActionListener(this);
        this.fDecField.setActionCommand(DECOFFSET_PROPERTY);
        this.fDecField.addActionListener(this);
        this.add(this.fRaLabel);
        this.add(this.fRaField);
        this.add(this.fRaUnits);
        this.add(this.fDecLabel);
        this.add(this.fDecField);
        this.add(this.fDecUnits);
        this.fOldOffset = null;
        this.setOrientation(0);
    }

    public CoordinatesOffset getCoordinatesOffset() {
        try {
            this.fOldOffset = this.textFieldToOffset();
            return this.fOldOffset;
        }
        catch (NumberFormatException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public void setCoordinatesOffset(CoordinatesOffset offset) {
        CoordinatesOffset old = this.getCoordinatesOffset();
        this.fOldOffset = offset;
        String raString = "";
        String decString = "";
        if (offset != null) {
            raString = FormatUtilities.formatDouble(offset.getRa(Coordinates.ARCSEC), 2);
            decString = FormatUtilities.formatDouble(offset.getDec(Coordinates.ARCSEC), 2);
        }
        if (!this.fRaField.getText().equals(raString)) {
            this.fRaField.setText(raString);
        }
        if (!this.fDecField.getText().equals(decString)) {
            this.fDecField.setText(decString);
        }
        this.firePropertyChange(COORDINATES_OFFSET_PROPERTY, old, offset);
    }

    public void setCoordinatesOffset(String ra, String dec) {
        try {
            CoordinatesOffset newPosition;
            CoordinatesOffset hold = this.fOldOffset;
            this.fOldOffset = newPosition = this.stringToOffset(ra, dec);
            if (!this.fRaField.getText().equals(ra)) {
                this.fRaField.setText(ra);
            }
            if (!this.fDecField.getText().equals(dec)) {
                this.fDecField.setText(dec);
            }
            this.firePropertyChange(COORDINATES_OFFSET_PROPERTY, hold, newPosition);
        }
        catch (NumberFormatException ex) {
            FormatUtilities.writeError(this, "Unable to set coordinate offset: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            FormatUtilities.writeError(this, "Unable to set coordinate offset: " + ex.toString());
        }
    }

    public boolean isReadOnly() {
        return !this.fRaField.isEditable();
    }

    public void setReadOnly(boolean readOnly) {
        this.firePropertyChange(READ_ONLY_PROPERTY, !this.fRaField.isEditable(), readOnly);
        this.fRaField.setEditable(!readOnly);
        this.fDecField.setEditable(!readOnly);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setReadOnly(!b);
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    private void setConstraints(JComponent comp, int x, int y, int w, int h, int a) {
        this.constraint.weightx = 1.0;
        this.constraint.insets = new Insets(2, 2, 2, 2);
        this.constraint.gridx = x;
        this.constraint.gridy = y;
        this.constraint.gridheight = h;
        this.constraint.gridwidth = w;
        this.constraint.anchor = a;
        ((GridBagLayout)this.getLayout()).setConstraints(comp, this.constraint);
    }

    public void setOrientation(int orient) {
        this.firePropertyChange(ORIENTATION_PROPERTY, this.fOrientation, orient);
        this.fOrientation = orient;
        if (this.fOrientation == 1) {
            this.setConstraints(this.fRaLabel, 0, 0, 1, 1, 13);
            this.setConstraints(this.fRaField, 1, 0, 1, 1, 17);
            this.setConstraints(this.fRaUnits, 2, 0, 1, 1, 17);
            this.fRaUnits.setVisible(true);
            this.setConstraints(this.fDecLabel, 0, 1, 1, 1, 13);
            this.setConstraints(this.fDecField, 1, 1, 1, 1, 17);
            this.setConstraints(this.fDecUnits, 2, 1, 1, 1, 17);
        } else {
            this.setConstraints(this.fRaLabel, 0, 0, 1, 1, 13);
            this.setConstraints(this.fRaField, 1, 0, 1, 1, 17);
            this.setConstraints(this.fRaUnits, 2, 0, 1, 1, 17);
            this.fRaUnits.setVisible(false);
            this.setConstraints(this.fDecLabel, 3, 0, 1, 1, 13);
            this.setConstraints(this.fDecField, 4, 0, 1, 1, 17);
            this.setConstraints(this.fDecUnits, 5, 0, 1, 1, 17);
        }
    }

    protected CoordinatesOffset textFieldToOffset() throws NumberFormatException, IllegalArgumentException {
        return this.stringToOffset(this.fRaField.getText(), this.fDecField.getText());
    }

    protected CoordinatesOffset stringToOffset(String raString, String decString) throws NumberFormatException, IllegalArgumentException {
        double ra = new Double(raString);
        double dec = new Double(decString);
        return new CoordinatesOffset(ra, dec, Coordinates.ARCSEC);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block5: {
            if (e.getActionCommand() == RAOFFSET_PROPERTY || e.getActionCommand() == DECOFFSET_PROPERTY) {
                try {
                    CoordinatesOffset newOffset = this.textFieldToOffset();
                    this.firePropertyChange(COORDINATES_OFFSET_PROPERTY, this.fOldOffset, newOffset);
                    this.fOldOffset = newOffset;
                }
                catch (NumberFormatException ex) {
                    this.showErrorDialog();
                    if (this.fOldOffset != null) {
                        this.setCoordinatesOffset(this.fOldOffset);
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.showErrorDialog();
                    if (this.fOldOffset == null) break block5;
                    this.setCoordinatesOffset(this.fOldOffset);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.fOldOffset != null) {
            this.setCoordinatesOffset(this.fOldOffset);
        }
    }

    public void showErrorDialog() {
        String message = "Invalid format.  CoordinatesOffset should be\nentered in the following format: ##.## arcsec";
        JOptionPane.showMessageDialog(this, message, "Invalid CoordinatesOffset", 0);
    }

    public static void main(String[] args) {
        CoordinatesOffset offset = new CoordinatesOffset(5.0, 5.0, Coordinates.ARCSEC);
        CoordinatesOffsetPanel panel = new CoordinatesOffsetPanel();
        panel.setCoordinatesOffset(offset);
        JOptionPane.showConfirmDialog(null, panel);
    }
}

