/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import jsky.image.ImageChangeEvent;
import jsky.image.fits.codec.FITSImage;
import jsky.image.gui.MainImageDisplay;
import jsky.util.gui.SortedJTable;
import jsky.util.gui.SwingUtil;
import jsky.util.gui.TableUtil;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;

public class FITSKeywords
extends JPanel {
    protected MainImageDisplay _imageDisplay;
    protected SortedJTable _table;
    protected int _sumColWidths = 0;

    public FITSKeywords(MainImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeTable(), "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        imageDisplay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewImage() && !e.isBefore()) {
                    FITSKeywords.this.updateDisplay();
                }
            }
        });
        this.updateDisplay();
    }

    JScrollPane makeTable() {
        this._table = new SortedJTable();
        this._table.setAutoResizeMode(0);
        this._table.setIntercellSpacing(new Dimension(6, 3));
        this._table.setRowSelectionAllowed(true);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowHeight(20);
        this._table.setGridColor(Color.gray);
        JTableHeader header = this._table.getTableHeader();
        header.setUpdateTableInRealTime(false);
        header.setFont(header.getFont().deriveFont(1));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FITSKeywords.this.resize();
            }
        });
        return new JScrollPane(this._table);
    }

    public void resize() {
        if (this._sumColWidths < this.getWidth()) {
            this._table.setAutoResizeMode(3);
        } else {
            this._table.setAutoResizeMode(0);
        }
    }

    JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton closeButton = new JButton("Close");
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FITSKeywords.this.close();
            }
        });
        return panel;
    }

    public void updateDisplay() {
        FITSImage fitsImage = this._imageDisplay.getFitsImage();
        if (fitsImage == null) {
            this._table.setModel(new DefaultTableModel());
            return;
        }
        this.updateDisplay(fitsImage.getCurrentHDUIndex());
    }

    public void updateDisplay(int hduIndex) {
        FITSImage fitsImage = this._imageDisplay.getFitsImage();
        BasicHDU hdu = null;
        if (fitsImage == null || (hdu = fitsImage.getHDU(hduIndex)) == null) {
            this._table.setModel(new DefaultTableModel());
            return;
        }
        Object[] columnNames = new String[]{"Keyword", "Value", "Comment"};
        Header header = hdu.getHeader();
        int numKeywords = header.getNumberOfCards();
        Object[][] values = new String[numKeywords][3];
        Cursor it = header.iterator();
        int n = 0;
        while (it.hasNext()) {
            HeaderCard card = (HeaderCard)it.next();
            String name = card.getKey();
            String value = card.getValue();
            String comment = card.getComment();
            values[n][0] = name;
            values[n][1] = value;
            values[n++][2] = comment;
        }
        this._table.setModel(new DefaultTableModel(values, columnNames));
        this._sumColWidths = TableUtil.initColumnSizes(this._table, null);
        this.resize();
        this.updateTitle(header.getStringValue("EXTNAME"));
    }

    protected void updateTitle(String title) {
        JFrame parent;
        String s = "FITS Keywords";
        if (title != null) {
            s = s + ": " + title;
        }
        if ((parent = SwingUtil.getFrame(this)) != null) {
            parent.setTitle(s);
        }
    }

    void close() {
        JFrame parent = SwingUtil.getFrame(this);
        if (parent != null) {
            parent.setVisible(false);
        }
    }
}

