/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.awt.geom.Point2D;
import jsky.coords.WCSTransform;

public class platepos {
    private static final double COND2R = 0.01745329252;
    private static final double CONS2R = 206264.8062470964;
    private static final double TWOPI = 6.28318530717959;
    private static final int MAX_ITERATIONS = 50;
    private static final double TOLERANCE = 5.0E-7;
    private static final double CONR2S = 206264.8062470964;

    public static Point2D.Double getPosition(double xpix, double ypix, WCSTransform wcs) {
        double x = xpix + wcs.x_pixel_offset - 1.0 + 0.5;
        double y = ypix + wcs.y_pixel_offset - 1.0 + 0.5;
        double xmm = (wcs.ppo_coeff[2] - x * wcs.x_pixel_size) / 1000.0;
        double ymm = (y * wcs.y_pixel_size - wcs.ppo_coeff[5]) / 1000.0;
        double xmm2 = xmm * xmm;
        double ymm2 = ymm * ymm;
        double xmm3 = xmm * xmm2;
        double ymm3 = ymm * ymm2;
        double x2y2 = xmm2 + ymm2;
        double xi = wcs.amd_x_coeff[0] * xmm + wcs.amd_x_coeff[1] * ymm + wcs.amd_x_coeff[2] + wcs.amd_x_coeff[3] * xmm2 + wcs.amd_x_coeff[4] * xmm * ymm + wcs.amd_x_coeff[5] * ymm2 + wcs.amd_x_coeff[6] * x2y2 + wcs.amd_x_coeff[7] * xmm3 + wcs.amd_x_coeff[8] * xmm2 * ymm + wcs.amd_x_coeff[9] * xmm * ymm2 + wcs.amd_x_coeff[10] * ymm3 + wcs.amd_x_coeff[11] * xmm * x2y2 + wcs.amd_x_coeff[12] * xmm * x2y2 * x2y2;
        double eta = wcs.amd_y_coeff[0] * ymm + wcs.amd_y_coeff[1] * xmm + wcs.amd_y_coeff[2] + wcs.amd_y_coeff[3] * ymm2 + wcs.amd_y_coeff[4] * xmm * ymm + wcs.amd_y_coeff[5] * xmm2 + wcs.amd_y_coeff[6] * x2y2 + wcs.amd_y_coeff[7] * ymm3 + wcs.amd_y_coeff[8] * ymm2 * xmm + wcs.amd_y_coeff[9] * ymm * xmm2 + wcs.amd_y_coeff[10] * xmm3 + wcs.amd_y_coeff[11] * ymm * x2y2 + wcs.amd_y_coeff[12] * ymm * x2y2 * x2y2;
        double xir = xi / 206264.8062470964;
        double etar = eta / 206264.8062470964;
        double ctan = Math.tan(wcs.plate_dec);
        double ccos = Math.cos(wcs.plate_dec);
        double raoff = Math.atan2(xir / ccos, 1.0 - etar * ctan);
        double ra = raoff + wcs.plate_ra;
        if (ra < 0.0) {
            ra += 6.28318530717959;
        }
        double dec = Math.atan(Math.cos(raoff) / ((1.0 - etar * ctan) / (etar + ctan)));
        return new Point2D.Double(ra / 0.01745329252, dec / 0.01745329252);
    }

    public static Point2D.Double getPixels(double xpos, double ypos, WCSTransform wcs) {
        double xr = xpos * 0.01745329252;
        double yr = ypos * 0.01745329252;
        double sypos = Math.sin(yr);
        double cypos = Math.cos(yr);
        double syplate = Math.sin(wcs.plate_dec);
        double cyplate = Math.cos(wcs.plate_dec);
        double sxdiff = Math.sin(xr - wcs.plate_ra);
        double cxdiff = Math.cos(xr - wcs.plate_ra);
        double div = sypos * syplate + cypos * cyplate * cxdiff;
        double xi = cypos * sxdiff * 206264.8062470964 / div;
        double eta = (sypos * cyplate - cypos * syplate * cxdiff) * 206264.8062470964 / div;
        double xmm = xi / wcs.plate_scale;
        double ymm = eta / wcs.plate_scale;
        for (int i = 0; i < 50; ++i) {
            double xy = xmm * ymm;
            double x2 = xmm * xmm;
            double y2 = ymm * ymm;
            double x2y = x2 * ymm;
            double y2x = y2 * xmm;
            double x2y2 = x2 + y2;
            double cjunk = x2y2 * x2y2;
            double x3 = x2 * xmm;
            double y3 = y2 * ymm;
            double x4 = x2 * x2;
            double y4 = y2 * y2;
            double f = wcs.amd_x_coeff[0] * xmm + wcs.amd_x_coeff[1] * ymm + wcs.amd_x_coeff[2] + wcs.amd_x_coeff[3] * x2 + wcs.amd_x_coeff[4] * xy + wcs.amd_x_coeff[5] * y2 + wcs.amd_x_coeff[6] * x2y2 + wcs.amd_x_coeff[7] * x3 + wcs.amd_x_coeff[8] * x2y + wcs.amd_x_coeff[9] * y2x + wcs.amd_x_coeff[10] * y3 + wcs.amd_x_coeff[11] * xmm * x2y2 + wcs.amd_x_coeff[12] * xmm * cjunk;
            double fx = wcs.amd_x_coeff[0] + wcs.amd_x_coeff[3] * 2.0 * xmm + wcs.amd_x_coeff[4] * ymm + wcs.amd_x_coeff[6] * 2.0 * xmm + wcs.amd_x_coeff[7] * 3.0 * x2 + wcs.amd_x_coeff[8] * 2.0 * xy + wcs.amd_x_coeff[9] * y2 + wcs.amd_x_coeff[11] * (3.0 * x2 + y2) + wcs.amd_x_coeff[12] * (5.0 * x4 + 6.0 * x2 * y2 + y4);
            double fy = wcs.amd_x_coeff[1] + wcs.amd_x_coeff[4] * xmm + wcs.amd_x_coeff[5] * 2.0 * ymm + wcs.amd_x_coeff[6] * 2.0 * ymm + wcs.amd_x_coeff[8] * x2 + wcs.amd_x_coeff[9] * 2.0 * xy + wcs.amd_x_coeff[10] * 3.0 * y2 + wcs.amd_x_coeff[11] * 2.0 * xy + wcs.amd_x_coeff[12] * 4.0 * xy * x2y2;
            double g = wcs.amd_y_coeff[0] * ymm + wcs.amd_y_coeff[1] * xmm + wcs.amd_y_coeff[2] + wcs.amd_y_coeff[3] * y2 + wcs.amd_y_coeff[4] * xy + wcs.amd_y_coeff[5] * x2 + wcs.amd_y_coeff[6] * x2y2 + wcs.amd_y_coeff[7] * y3 + wcs.amd_y_coeff[8] * y2x + wcs.amd_y_coeff[9] * x2y + wcs.amd_y_coeff[10] * x3 + wcs.amd_y_coeff[11] * ymm * x2y2 + wcs.amd_y_coeff[12] * ymm * cjunk;
            double gx = wcs.amd_y_coeff[1] + wcs.amd_y_coeff[4] * ymm + wcs.amd_y_coeff[5] * 2.0 * xmm + wcs.amd_y_coeff[6] * 2.0 * xmm + wcs.amd_y_coeff[8] * y2 + wcs.amd_y_coeff[9] * 2.0 * xy + wcs.amd_y_coeff[10] * 3.0 * x2 + wcs.amd_y_coeff[11] * 2.0 * xy + wcs.amd_y_coeff[12] * 4.0 * xy * x2y2;
            double gy = wcs.amd_y_coeff[0] + wcs.amd_y_coeff[3] * 2.0 * ymm + wcs.amd_y_coeff[4] * xmm + wcs.amd_y_coeff[6] * 2.0 * ymm + wcs.amd_y_coeff[7] * 3.0 * y2 + wcs.amd_y_coeff[8] * 2.0 * xy + wcs.amd_y_coeff[9] * x2 + wcs.amd_y_coeff[11] * (x2 + 3.0 * y2) + wcs.amd_y_coeff[12] * (5.0 * y4 + 6.0 * x2 * y2 + x4);
            double dx = (-(f -= xi) * gy + (g -= eta) * fy) / (fx * gy - fy * gx);
            double dy = (-g * fx + f * gx) / (fx * gy - fy * gx);
            xmm += dx;
            ymm += dy;
            if (Math.abs(dx) < 5.0E-7 && Math.abs(dy) < 5.0E-7) break;
        }
        double x = (wcs.ppo_coeff[2] - xmm * 1000.0) / wcs.x_pixel_size;
        double y = (wcs.ppo_coeff[5] + ymm * 1000.0) / wcs.y_pixel_size;
        double xpix = x - wcs.x_pixel_offset + 1.0 - 0.5;
        double ypix = y - wcs.y_pixel_offset + 1.0 - 0.5;
        return new Point2D.Double(xpix, ypix);
    }
}

