/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs.main;

import com.cosylab.logging.engine.audience.Audience;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuListener;

public class LogMenuBar
extends JMenuBar {
    private JMenuItem connectMenuItem = null;
    private JMenuItem loadMenuItem = null;
    private JMenuItem loadURLMenuItem = null;
    private JMenuItem loadDBMenuItem = null;
    private JMenuItem saveFileMenuItem = null;
    private JMenuItem clearLogsMI = null;
    private JMenuItem exitMenuItem = null;
    private JSeparator exitSeparator = new JSeparator();
    private boolean exitHided;
    private JMenuItem statisticsMenuItem = null;
    private JMenuItem viewErrorLogMI;
    private JMenuItem viewErrorBrowserMI;
    private JMenuItem filtersMenuItem;
    private JMenuItem fieldsMenuItem = null;
    private JMenuItem searchMenuItem;
    private JMenuItem searchNextMenuItem;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private JMenu searchMenu;
    private JMenu zoomMenu;
    private JMenu expertMenu;
    private JMenuItem suspendMI;
    private JMenuItem prefsMI;
    private JCheckBoxMenuItem viewToolbarMI;
    private JCheckBoxMenuItem autoReconnectMI;
    private JCheckBoxMenuItem viewDetailedInfoMI;
    private JCheckBoxMenuItem viewStatusAreaMI;
    private JRadioButtonMenuItem operatorMode;
    private JRadioButtonMenuItem engineeringMode;
    private JRadioButtonMenuItem sciLogMode;
    private JMenuItem engineFiltersMI;
    private JCheckBoxMenuItem shortDateViewMI;
    private JCheckBoxMenuItem logTypeDescritptionViewMI;
    private JMenuItem zoomPrefsMI;
    private JMenuItem manualZoomMI;

    public LogMenuBar() {
        this.setName("LoggingClientMenuBar");
        this.setupMenuBar();
        this.hideExitMenu(true);
    }

    private void setupMenuBar() {
        this.fileMenu = new JMenu();
        this.fileMenu.setName("FileMenu");
        this.fileMenu.setText("File");
        this.fileMenu.add(this.getConnectMenuItem());
        this.fileMenu.add(this.getAutoReconnectMenuItem());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.getLoadMenuItem());
        this.fileMenu.add(this.getLoadURLMenuItem());
        this.fileMenu.add(this.getLoadDBMenuItem());
        this.fileMenu.add(this.getSaveFileMenuItem());
        this.fileMenu.add(this.getClearLogsMenuItem());
        this.fileMenu.add(this.exitSeparator);
        this.fileMenu.add(this.getExitMenuItem());
        this.add(this.fileMenu);
        this.viewMenu = new JMenu();
        this.viewMenu.setName("ViewMenu");
        this.viewMenu.setText("View");
        this.viewMenu.add(this.getViewToolbarMenuItem());
        this.viewMenu.add(this.getViewDetailedInfoMenuItem());
        this.viewMenu.add(this.getViewStatusAreaMenuItem());
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.getFieldsMenuItem());
        this.viewMenu.add(this.getShortDateViewMenuItem());
        this.viewMenu.add(this.getLogTypeDescriptionViewMenuItem());
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.getFiltersMenuItem());
        this.viewMenu.add(this.getViewErrorBrowserMenuItem());
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.getStatisticsMenuItem());
        this.viewMenu.add(this.getViewErrorLogMenuItem());
        this.add(this.viewMenu);
        this.add(this.getSearchMenu());
        this.add(this.getZoomMenu());
        this.expertMenu = new JMenu();
        this.expertMenu.setName("ExpertMenu");
        this.expertMenu.setText("Expert");
        JMenu modeMenu = new JMenu("Mode");
        this.expertMenu.add(modeMenu);
        modeMenu.add(this.getOperatorMode());
        modeMenu.add(this.getEngineeringMode());
        modeMenu.add(this.getSciLogMode());
        ButtonGroup group = new ButtonGroup();
        group.add(this.getOperatorMode());
        group.add(this.getEngineeringMode());
        group.add(this.getSciLogMode());
        this.expertMenu.addSeparator();
        this.expertMenu.add(this.getSuspendMenuItem());
        this.expertMenu.add(this.getPrefsMenuItem());
        this.expertMenu.add(this.getEngineFiltersMenuItem());
        this.add(this.expertMenu);
    }

    public JMenu getSearchMenu() {
        if (this.searchMenu == null) {
            this.searchMenu = new JMenu();
            this.searchMenu.setName("SearchMenu");
            this.searchMenu.setText("Search");
            this.searchMenu.add(this.getSearchMenuItem());
            this.searchMenu.add(this.getSearchNextMenuItem());
        }
        return this.searchMenu;
    }

    public JMenu getZoomMenu() {
        if (this.zoomMenu == null) {
            this.zoomMenu = new JMenu("Drill down");
            this.zoomPrefsMI = new JMenuItem("Preferences...");
            this.zoomMenu.add(this.zoomPrefsMI);
            this.manualZoomMI = new JMenuItem("Drill down...");
            this.zoomMenu.add(this.manualZoomMI);
        }
        return this.zoomMenu;
    }

    public JMenuItem getConnectMenuItem() {
        if (this.connectMenuItem == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/link.png"));
            this.connectMenuItem = new JMenuItem("Connect", icon);
            this.connectMenuItem.setName("connectMenuItem");
            this.connectMenuItem.setText("Connect");
        }
        return this.connectMenuItem;
    }

    public JMenuItem getLoadDBMenuItem() {
        if (this.loadDBMenuItem == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/database.png"));
            this.loadDBMenuItem = new JMenuItem("Load from database", icon);
            this.loadDBMenuItem.setName("LoadDBMenuItem");
        }
        return this.loadDBMenuItem;
    }

    public JMenuItem getLoadURLMenuItem() {
        if (this.loadURLMenuItem == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/loadURL.png"));
            this.loadURLMenuItem = new JMenuItem("Load from URL", icon);
            this.loadURLMenuItem.setName("LoadURLMenuItem");
        }
        return this.loadURLMenuItem;
    }

    public JMenuItem getFieldsMenuItem() {
        if (this.fieldsMenuItem == null) {
            this.fieldsMenuItem = new JMenuItem();
            this.fieldsMenuItem.setName("FieldsMenuItem");
            this.fieldsMenuItem.setText("Fields...");
        }
        return this.fieldsMenuItem;
    }

    public JMenuItem getFiltersMenuItem() {
        if (this.filtersMenuItem == null) {
            ImageIcon filterIcon = new ImageIcon(LogTypeHelper.class.getResource("/filters.png"));
            this.filtersMenuItem = new JMenuItem("Filters...", filterIcon);
            this.filtersMenuItem.setName("EditFiltersMenuItem");
        }
        return this.filtersMenuItem;
    }

    public JMenuItem getLoadMenuItem() {
        if (this.loadMenuItem == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/load.png"));
            this.loadMenuItem = new JMenuItem("Load from File", icon);
            this.loadMenuItem.setName("LoadMenuItem");
        }
        return this.loadMenuItem;
    }

    public JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/exit.png"));
            this.exitMenuItem = new JMenuItem("Exit", icon);
            this.exitMenuItem.setName("ExitMenuItem");
        }
        return this.exitMenuItem;
    }

    public JMenuItem getSaveFileMenuItem() {
        if (this.saveFileMenuItem == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/disk.png"));
            this.saveFileMenuItem = new JMenuItem("Save File As", icon);
            this.saveFileMenuItem.setName("SaveFileMenuItem");
        }
        return this.saveFileMenuItem;
    }

    public JMenuItem getClearLogsMenuItem() {
        if (this.clearLogsMI == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/delete.png"));
            this.clearLogsMI = new JMenuItem("Clear logs", icon);
            this.clearLogsMI.setName("ClearAllMenuItem");
        }
        return this.clearLogsMI;
    }

    public JMenuItem getSearchMenuItem() {
        if (this.searchMenuItem == null) {
            ImageIcon searchIcon = new ImageIcon(LogTypeHelper.class.getResource("/search.png"));
            this.searchMenuItem = new JMenuItem("Search...", searchIcon);
            this.searchMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.searchMenu.add(this.searchMenuItem);
            this.searchMenu.setName("SearchMenuItem");
        }
        return this.searchMenuItem;
    }

    public JMenuItem getSearchNextMenuItem() {
        if (this.searchNextMenuItem == null) {
            this.searchNextMenuItem = new JMenuItem("Search Next");
            this.searchNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.searchNextMenuItem.setEnabled(false);
            this.searchNextMenuItem.setName("SearchNextMenuItem");
        }
        return this.searchNextMenuItem;
    }

    public void setEventHandler(ActionListener actionListener, MenuListener menuListener) {
        this.fileMenu.addMenuListener(menuListener);
        this.viewMenu.addMenuListener(menuListener);
        this.searchMenu.addMenuListener(menuListener);
        this.connectMenuItem.addActionListener(actionListener);
        this.autoReconnectMI.addActionListener(actionListener);
        this.viewToolbarMI.addActionListener(actionListener);
        this.viewDetailedInfoMI.addActionListener(actionListener);
        this.shortDateViewMI.addActionListener(actionListener);
        this.logTypeDescritptionViewMI.addActionListener(actionListener);
        this.viewStatusAreaMI.addActionListener(actionListener);
        this.statisticsMenuItem.addActionListener(actionListener);
        this.viewErrorLogMI.addActionListener(actionListener);
        this.viewErrorBrowserMI.addActionListener(actionListener);
        this.searchMenuItem.addActionListener(actionListener);
        this.searchNextMenuItem.addActionListener(actionListener);
        this.suspendMI.addActionListener(actionListener);
        this.prefsMI.addActionListener(actionListener);
        this.loadMenuItem.addActionListener(actionListener);
        this.loadURLMenuItem.addActionListener(actionListener);
        this.loadDBMenuItem.addActionListener(actionListener);
        this.saveFileMenuItem.addActionListener(actionListener);
        this.clearLogsMI.addActionListener(actionListener);
        this.exitMenuItem.addActionListener(actionListener);
        this.fieldsMenuItem.addActionListener(actionListener);
        this.filtersMenuItem.addActionListener(actionListener);
        this.operatorMode.addActionListener(actionListener);
        this.engineeringMode.addActionListener(actionListener);
        this.sciLogMode.addActionListener(actionListener);
        this.engineFiltersMI.addActionListener(actionListener);
        this.zoomPrefsMI.addActionListener(actionListener);
        this.manualZoomMI.addActionListener(actionListener);
    }

    public JCheckBoxMenuItem getViewToolbarMenuItem() {
        if (this.viewToolbarMI == null) {
            this.viewToolbarMI = new JCheckBoxMenuItem("Toolbar", true);
        }
        return this.viewToolbarMI;
    }

    public JCheckBoxMenuItem getViewDetailedInfoMenuItem() {
        if (this.viewDetailedInfoMI == null) {
            this.viewDetailedInfoMI = new JCheckBoxMenuItem("Detailed log info", true);
        }
        return this.viewDetailedInfoMI;
    }

    public JCheckBoxMenuItem getViewStatusAreaMenuItem() {
        if (this.viewStatusAreaMI == null) {
            this.viewStatusAreaMI = new JCheckBoxMenuItem("Status area", false);
        }
        return this.viewStatusAreaMI;
    }

    public JCheckBoxMenuItem getShortDateViewMenuItem() {
        if (this.shortDateViewMI == null) {
            this.shortDateViewMI = new JCheckBoxMenuItem("Short date format", true);
        }
        return this.shortDateViewMI;
    }

    public JCheckBoxMenuItem getLogTypeDescriptionViewMenuItem() {
        if (this.logTypeDescritptionViewMI == null) {
            this.logTypeDescritptionViewMI = new JCheckBoxMenuItem("Show log type description", true);
        }
        return this.logTypeDescritptionViewMI;
    }

    public JCheckBoxMenuItem getAutoReconnectMenuItem() {
        if (this.autoReconnectMI == null) {
            ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/autoreconnect.png"));
            this.autoReconnectMI = new JCheckBoxMenuItem("Auto reconnect", icon, false);
        }
        return this.autoReconnectMI;
    }

    public JMenuItem getSuspendMenuItem() {
        if (this.suspendMI == null) {
            this.suspendMI = new JCheckBoxMenuItem("Suspend", false);
        }
        return this.suspendMI;
    }

    public JMenuItem getPrefsMenuItem() {
        if (this.prefsMI == null) {
            this.prefsMI = new JMenuItem("Preferences");
        }
        return this.prefsMI;
    }

    public JMenuItem getStatisticsMenuItem() {
        if (this.statisticsMenuItem == null) {
            ImageIcon statIcon = new ImageIcon(LogTypeHelper.class.getResource("/statistics.png"));
            this.statisticsMenuItem = new JMenuItem("Statistics", statIcon);
        }
        return this.statisticsMenuItem;
    }

    public JMenuItem getViewErrorLogMenuItem() {
        if (this.viewErrorLogMI == null) {
            ImageIcon errorLogIcon = new ImageIcon(LogTypeHelper.class.getResource("/errorLogIcon.png"));
            this.viewErrorLogMI = new JMenuItem("jlog error log", errorLogIcon);
        }
        return this.viewErrorLogMI;
    }

    public JMenuItem getViewErrorBrowserMenuItem() {
        if (this.viewErrorBrowserMI == null) {
            ImageIcon browserIcon = new ImageIcon(LogTypeHelper.class.getResource("/errorBrowserIcon.png"));
            this.viewErrorBrowserMI = new JMenuItem("Error browser", browserIcon);
        }
        return this.viewErrorBrowserMI;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.viewMenu.setEnabled(enabled);
        this.searchMenu.setEnabled(enabled);
        this.expertMenu.setEnabled(enabled);
        this.fileMenu.setEnabled(enabled);
        this.zoomMenu.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void hideExitMenu(boolean hide) {
        if (hide && !this.exitHided) {
            this.exitHided = true;
            this.fileMenu.remove(this.exitMenuItem);
            this.fileMenu.remove(this.exitSeparator);
        } else if (!hide && this.exitHided) {
            this.exitHided = false;
            this.fileMenu.add(this.exitSeparator);
            this.fileMenu.add(this.exitMenuItem);
        }
    }

    public JRadioButtonMenuItem getOperatorMode() {
        if (this.operatorMode == null) {
            this.operatorMode = new JRadioButtonMenuItem(Audience.AudienceInfo.OPERATOR.name);
        }
        return this.operatorMode;
    }

    public JRadioButtonMenuItem getEngineeringMode() {
        if (this.engineeringMode == null) {
            this.engineeringMode = new JRadioButtonMenuItem(Audience.AudienceInfo.ENGINEER.name);
        }
        return this.engineeringMode;
    }

    public JRadioButtonMenuItem getSciLogMode() {
        if (this.sciLogMode == null) {
            this.sciLogMode = new JRadioButtonMenuItem(Audience.AudienceInfo.SCILOG.name);
        }
        return this.sciLogMode;
    }

    public JMenuItem getEngineFiltersMenuItem() {
        if (this.engineFiltersMI == null) {
            this.engineFiltersMI = new JMenuItem("Engine filters...");
        }
        return this.engineFiltersMI;
    }

    public JMenuItem getManualZoomMI() {
        return this.manualZoomMI;
    }

    public JMenuItem getZoomPrefsMI() {
        return this.zoomPrefsMI;
    }
}

