/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.engine;

import alma.acs.commandcenter.engine.RunModel;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.commandcenter.util.PreparedString;
import alma.entity.xmlbinding.acscommandcentertools.AcsCommandCenterTools;
import alma.entity.xmlbinding.acscommandcentertools.Insertion;
import alma.entity.xmlbinding.acscommandcentertools.Tool;
import alma.entity.xmlbinding.acscommandcentertools.types.InsertionSourceType;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ToolManager {
    private static Logger log = MiscUtils.getPackageLogger(ToolManager.class);
    private static HashMap<String, Object> emptyMap = new HashMap();
    protected static AcsCommandCenterTools extraTools = new AcsCommandCenterTools();
    protected static HashMap<String, Tool> builtinTools = new HashMap();

    public static void readExtraTools(Reader f) throws Exception {
        BufferedReader r = new BufferedReader(f);
        extraTools = AcsCommandCenterTools.unmarshalAcsCommandCenterTools((Reader)r);
    }

    public static AcsCommandCenterTools getExtraTools() throws Exception {
        if (extraTools.getToolCount() == 0) {
            ToolManager.readDefaultExtraTools();
        }
        return extraTools;
    }

    public static String getDefaultExtraToolsName() {
        return "AcsCommandCenterTools.xml";
    }

    public static void readDefaultExtraTools() throws Exception {
        URL url = ToolManager.class.getClassLoader().getResource(ToolManager.getDefaultExtraToolsName());
        InputStream is = url.openStream();
        InputStreamReader r = new InputStreamReader(is);
        ToolManager.readExtraTools(r);
    }

    public static void readBuiltinTools(Reader f) throws Exception {
        BufferedReader r = new BufferedReader(f);
        AcsCommandCenterTools tools = AcsCommandCenterTools.unmarshalAcsCommandCenterTools((Reader)r);
        for (int i = 0; i < tools.getToolCount(); ++i) {
            Tool t = tools.getTool(i);
            builtinTools.put(t.getCaption().trim(), t);
        }
    }

    public static Tool getBuiltinTool(String caption) throws IllegalArgumentException, Exception {
        Tool ret;
        if (builtinTools.size() == 0) {
            ToolManager.readDefaultBuiltinTools();
        }
        if ((ret = builtinTools.get(caption)) == null) {
            throw new IllegalArgumentException("no such built-in tool: '" + caption + "'; currently defined built-in tools are: " + builtinTools.keySet());
        }
        return ret;
    }

    public static String getDefaultBuiltinToolsName() {
        return "AcsCommandCenterBuiltinTools.xml";
    }

    public static void readDefaultBuiltinTools() throws Exception {
        URL url = ToolManager.class.getClassLoader().getResource(ToolManager.getDefaultBuiltinToolsName());
        InputStream is = url.openStream();
        InputStreamReader r = new InputStreamReader(is);
        ToolManager.readBuiltinTools(r);
    }

    public static String generateCommand(Tool tool, RunModel runModel) throws Exception {
        return ToolManager.generateCommand(tool, runModel, emptyMap);
    }

    public static String generateCommand(Tool tool, RunModel runModel, Map<String, Object> input) throws Exception {
        String command;
        String[] pieces = ToolManager.collectInsertions(tool, runModel, input);
        PreparedString prep = new PreparedString(tool.getCommand());
        String ret = command = prep.toString(pieces);
        return ret;
    }

    protected static String[] collectInsertions(Tool tool, RunModel runModel, Map<String, Object> input) throws Exception {
        String[] ret = new String[tool.getInsertionCount()];
        for (int i = 0; i < ret.length; ++i) {
            Insertion ins = tool.getInsertion(i);
            String name = ins.getContent() != null ? ins.getContent().trim() : "";
            String fallback = ins.getDefault() != null ? ins.getDefault().trim() : "";
            ret[i] = ins.getSource().equals(InsertionSourceType.MODEL) ? ToolManager.readFromModel(runModel, name, fallback) : ToolManager.readFromInput(input, name, fallback);
        }
        return ret;
    }

    protected static String readFromModel(RunModel runModel, String name, String fallback) throws Exception {
        try {
            Method m;
            Object ret = null;
            if (((String)name).endsWith("()")) {
                name = ((String)name).substring(0, ((String)name).length() - 2);
            }
            if (!((String)name).startsWith("get")) {
                name = "get" + (String)name;
            }
            if ((ret = (m = RunModel.class.getDeclaredMethod((String)name, new Class[0])).invoke((Object)runModel, new Object[0])) == null || ret.equals("")) {
                ret = fallback;
            }
            log.finer("readFromModel('" + (String)name + "','" + fallback + "') returns '" + ret + "'");
            return ret.toString();
        }
        catch (InvocationTargetException exc) {
            log.fine("readFromModel(" + (String)name + "," + fallback + ") failed: " + exc);
            Throwable cause = exc.getCause();
            if (cause != null && cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw exc;
        }
        catch (Exception exc) {
            log.fine("readFromModel(" + (String)name + "," + fallback + ") failed: " + exc);
            throw exc;
        }
    }

    protected static String readFromInput(Map<String, Object> input, String name, String fallback) {
        Object ret = null;
        ret = input.get(name);
        if (ret == null || ret.equals("")) {
            ret = fallback;
        }
        return ret.toString();
    }
}

