/*
 * Decompiled with CFR 0.152.
 */
package alma.hibernate.util;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

public class JdbcNativeExtractor {
    public static Connection getRawConnection(Connection con) {
        return con;
    }

    public Connection getNativeConnection(Connection con) throws SQLException {
        if (con.getClass().getName().startsWith("oracle.jdbc") || con.getClass().getName().startsWith("org.hsqldb") || con.getClass().getName().startsWith("com.mysql")) {
            return con;
        }
        if (con.getClass().getName().startsWith("com.mchange.v2.c3p0")) {
            Connection oCon = con;
            try {
                Class<?> clazz = Class.forName("com.mchange.v2.c3p0.C3P0ProxyConnection");
                Method rawConnMethod = this.getClass().getMethod("getRawConnection", Connection.class);
                Method rawConnOperation = clazz.getMethod("rawConnectionOperation", Method.class, Object.class, Object[].class);
                Object c3p0rawConnection = clazz.getField("RAW_CONNECTION").get(oCon);
                return (Connection)rawConnOperation.invoke((Object)oCon, rawConnMethod, null, new Object[]{c3p0rawConnection});
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SQLException("Error in reflection: " + ex.getMessage());
            }
        }
        Connection conTmp = con.getMetaData().getConnection();
        if (conTmp.getClass().getName().contains("oracle.jdbc")) {
            return conTmp;
        }
        throw new SQLException("Could not find Native Connection of type OracleConnection");
    }
}

