/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

import java.util.Hashtable;
import java.util.Vector;

public class IorParser {
    private IorParser() {
    }

    public static void main(String[] args) {
        String maciManagerIOR = "IOR:000000000000001C49444C3A696A732E73692F6D6163692F4D616E616765723A312E300000000002000000000000006C000102000000000E3133342E3137312E34302E3139000BB8000000164F52422F4D616E61676572504F412F4D616E616765720000000000020000000000000008000000004A414300000000010000001C00000000000100010000000105010001000101090000000105010001000000010000002C0000000000000001000000010000001C00000000000100010000000105010001000101090000000105010001";
        if (args.length == 0) {
            System.err.println("Usage: (this) IOR:0123456789...");
            System.exit(2);
        }
        String hexIOR = args[0];
        new IOR(hexIOR).print();
        String[] result = IorParser.parse(hexIOR);
        System.out.println("\n host / port: " + result[0] + " / " + result[1]);
    }

    public static String[] parse(String hexIOR) throws IllegalArgumentException {
        String host = null;
        String port = null;
        IOR ior = null;
        try {
            ior = new IOR(hexIOR);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("parsing failed: " + exc);
        }
        if (ior == null || ior._profiles == null) {
            throw new IllegalArgumentException("parsing failed for unknown reason");
        }
        try {
            int i = 0;
            while ((long)i < ior._numProfiles) {
                int tag = ((Long)ior._profiles.elementAt(i * 2)).intValue();
                Hashtable profile_data = (Hashtable)ior._profiles.elementAt(i * 2 + 1);
                if ((long)tag == 0L) {
                    host = String.valueOf(profile_data.get("ProfileBody.host"));
                    port = String.valueOf(profile_data.get("ProfileBody.port"));
                    break;
                }
                ++i;
            }
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("parsing failed: " + exc);
        }
        if (host == null || port == null) {
            throw new IllegalArgumentException("parsing failed, host or port not found in IOR");
        }
        return new String[]{host, port};
    }

    private static class IOR {
        public static final long TAG_INTERNET_IOP = 0L;
        public static final long TAG_MULTIPLE_COMPONENTS = 1L;
        protected long _numProfiles;
        protected String _iorString;
        protected String _prefix;
        protected String _type_id;
        protected Vector _profiles = null;

        public IOR(String iorString) {
            this._iorString = new String(iorString);
            this.parse();
        }

        public long getNumProfiles() {
            return this._numProfiles;
        }

        public String getProfileData(long profileNo, String profileItem) {
            Hashtable profile_data = (Hashtable)this._profiles.elementAt((int)profileNo * 2 + 1);
            String profile_item = profile_data.get(profileItem).toString();
            return profile_item;
        }

        public int getProfileTag(long profileNo) {
            Long tagObj = (Long)this._profiles.elementAt((int)profileNo * 2);
            int tag = tagObj.intValue();
            return tag;
        }

        public String getTypeId() {
            return this._type_id;
        }

        public void print() {
            if (this._profiles != null) {
                System.out.println("Type ID           : " + this._type_id);
                System.out.println("Number of profiles: " + this._numProfiles);
                int i = 0;
                while ((long)i < this._numProfiles) {
                    System.out.println("Profile No. " + (i + 1));
                    int tag = ((Long)this._profiles.elementAt(i * 2)).intValue();
                    Hashtable profile_data = (Hashtable)this._profiles.elementAt(i * 2 + 1);
                    switch (tag) {
                        case 0: {
                            System.out.println("  Tag               : TAG_INTERNET_IOP");
                            System.out.println("  Version.major     : " + profile_data.get("Version.major"));
                            System.out.println("  Version.minor     : " + profile_data.get("Version.minor"));
                            System.out.println("  Host              : " + profile_data.get("ProfileBody.host"));
                            System.out.println("  Port              : " + profile_data.get("ProfileBody.port"));
                            System.out.println("  Object key        : " + profile_data.get("ProfileBody.object_key"));
                            break;
                        }
                        case 1: {
                            System.out.println("  Tag               : TAG_MULTIPLE_COMPONENTS");
                            System.out.println("  Profile data      : " + profile_data.get("ProfileData"));
                            break;
                        }
                        default: {
                            System.out.println("  New tag           : " + tag);
                            System.out.println("  Profile data      : " + profile_data.get("ProfileData"));
                        }
                    }
                    ++i;
                }
            }
        }

        protected void parse() {
            this._prefix = this._iorString.substring(0, 4);
            CDR iorCdr = new CDR();
            iorCdr.parseHexString(this._iorString.substring(4));
            this._type_id = iorCdr.getString();
            this._numProfiles = iorCdr.getULong();
            this._profiles = new Vector((int)this._numProfiles * 2);
            int i = 0;
            while ((long)i < this._numProfiles) {
                long tag = iorCdr.getULong();
                this._profiles.addElement(tag);
                Hashtable<String, Object> profile_data = new Hashtable<String, Object>(5);
                if (tag == 0L) {
                    CDR profileCdr = new CDR();
                    profileCdr.parseByteArray(iorCdr.getSequence());
                    profile_data.put("Version.major", Integer.valueOf(profileCdr.getChar()));
                    profile_data.put("Version.minor", Integer.valueOf(profileCdr.getChar()));
                    profile_data.put("ProfileBody.host", profileCdr.getString());
                    profile_data.put("ProfileBody.port", profileCdr.getUShort());
                    profile_data.put("ProfileBody.object_key", new String(profileCdr.getSequence()));
                } else {
                    profile_data.put("ProfileData", new String(iorCdr.getSequence()));
                }
                this._profiles.addElement(profile_data);
                ++i;
            }
        }
    }

    private static class CDR {
        protected boolean _byteOrder;
        protected int _byteLen;
        protected int _bytePos = 1;
        protected char[] _CDRArray;

        private CDR() {
        }

        public char getChar() {
            return this._CDRArray[this._bytePos++];
        }

        public long getULong() {
            this.skip(4);
            return this.getBytes(4);
        }

        public int getUShort() {
            this.skip(2);
            return (int)this.getBytes(2);
        }

        public char[] getSequence() {
            double seqLen = this.getULong();
            char[] sequence = new char[(int)seqLen];
            int i = 0;
            while ((double)i < seqLen) {
                sequence[i] = this._CDRArray[this._bytePos++];
                ++i;
            }
            return sequence;
        }

        public String getString() {
            double stringLen = this.getULong();
            this._bytePos += (int)stringLen;
            return new String(this._CDRArray, this._bytePos - (int)stringLen, (int)stringLen - 1);
        }

        public void parseByteArray(char[] sequence) {
            this._CDRArray = sequence;
            this.init();
        }

        public void parseHexString(String hexCDRString) {
            this._byteLen = hexCDRString.length() / 2;
            this._CDRArray = new char[this._byteLen];
            for (int i = 0; i < this._byteLen * 2; i += 2) {
                char cdrByte = this.hex2dual(hexCDRString.charAt(i));
                cdrByte = (char)(cdrByte << 4);
                this._CDRArray[i / 2] = cdrByte = (char)(cdrByte | this.hex2dual(hexCDRString.charAt(i + 1)));
            }
            this.init();
        }

        public String toHexString() {
            return new String();
        }

        protected long getBytes(int count) {
            long buff = 0L;
            if (this._byteOrder) {
                for (int i = count - 1; i >= 0; --i) {
                    buff += (long)this._CDRArray[this._bytePos + i];
                    if (i == 0) continue;
                    buff <<= 8;
                }
                this._bytePos += count;
            } else {
                for (int i = 0; i < count; ++i) {
                    buff += (long)this._CDRArray[this._bytePos++];
                    if (i == count - 1) continue;
                    buff <<= 8;
                }
            }
            return buff;
        }

        protected char hex2dual(char hc) {
            char dual = '\u0000';
            if (Character.isDigit(hc)) {
                dual = (char)Integer.valueOf("" + hc).intValue();
            } else {
                if ((hc = Character.toLowerCase(hc)) == 'a') {
                    dual = (char)10;
                }
                if (hc == 'b') {
                    dual = (char)11;
                }
                if (hc == 'c') {
                    dual = (char)12;
                }
                if (hc == 'd') {
                    dual = (char)13;
                }
                if (hc == 'e') {
                    dual = (char)14;
                }
                if (hc == 'f') {
                    dual = (char)15;
                }
            }
            return dual;
        }

        protected void init() {
            this._byteOrder = this._CDRArray[0] != '\u0000';
        }

        protected void skip(int alignment) {
            double remainder = this._bytePos % alignment;
            if (remainder > 0.0) {
                this._bytePos += alignment - (int)remainder;
            }
        }
    }
}

