/*
 * Decompiled with CFR 0.152.
 */
package skyview.data;

import java.text.DecimalFormat;

public class CoordinateFormatter {
    private boolean isSexagesimal = true;
    String[] sexaSep = new String[]{" ", " "};
    boolean zeroFill = false;

    public String sexagesimal(double value, int precision) {
        StringBuffer str = new StringBuffer();
        if (value < 0.0) {
            value = Math.abs(value);
            str.append("-");
        }
        if (precision > 13) {
            precision = 13;
        }
        if (precision <= 2) {
            str.append(String.valueOf(this.numb((int)(value + 0.49999999))));
        } else if (precision == 3) {
            int deg = (int)value;
            int frac = (int)(10.0 * (value - (double)((int)value)) + 0.5);
            if (frac == 10) {
                ++deg;
                frac = 0;
            }
            str.append(this.numb(deg) + "." + frac);
        } else if (precision == 4) {
            int deg = (int)value;
            int min = (int)(60.0 * (value - (double)deg) + 0.5);
            if (min == 60) {
                ++deg;
                min = 0;
            }
            str.append(this.numb(deg) + this.sexaSep[0] + this.numb(min));
        } else if (precision == 5) {
            int deg = (int)value;
            double fmin = 60.0 * (value - (double)deg);
            int min = (int)fmin;
            int frac = (int)(10.0 * (fmin - (double)min) + 0.5);
            if (frac == 10) {
                ++min;
                frac = 0;
            }
            if (min == 60) {
                ++deg;
                min = 0;
            }
            str.append(this.numb(deg) + this.sexaSep[0] + this.numb(min) + "." + frac);
        } else if (precision == 6) {
            int deg = (int)value;
            double fmin = 60.0 * (value - (double)deg);
            int min = (int)fmin;
            int sec = (int)(60.0 * (fmin - (double)min) + 0.5);
            if (sec == 60) {
                ++min;
                sec = 0;
            }
            if (min == 60) {
                ++deg;
                min = 0;
            }
            str.append(this.numb(deg) + this.sexaSep[0] + this.numb(min) + this.sexaSep[1] + this.numb(sec));
        } else {
            double maxval = 1.0;
            int deg = (int)value;
            double fmin = 60.0 * (value - (double)deg);
            int min = (int)fmin;
            double fsec = 60.0 * (fmin - (double)min);
            int sec = (int)fsec;
            double ffrac = fsec - (double)sec;
            for (int i = 6; i < precision; ++i) {
                ffrac *= 10.0;
                maxval *= 10.0;
            }
            int frac = (int)(ffrac + 0.5);
            if ((double)frac == maxval) {
                ++sec;
                frac = 0;
            }
            if (sec == 60) {
                ++min;
                sec = 0;
            }
            if (min == 60) {
                ++deg;
                min = 0;
            }
            str.append(this.numb(deg) + this.sexaSep[0] + this.numb(min) + this.sexaSep[1] + this.numb(sec) + "." + frac);
        }
        return str.toString();
    }

    public String decimal(double value, int precision) {
        if (precision < 3) {
            precision = 2;
        }
        String form = "0";
        if (this.zeroFill) {
            form = form + "0";
        }
        form = form + ".";
        for (int i = 2; i < precision; ++i) {
            form = this.zeroFill ? form + "0" : form + "#";
        }
        return new DecimalFormat(form).format(value);
    }

    private String numb(int input) {
        if (!this.zeroFill || input >= 10) {
            return "" + input;
        }
        return "0" + input;
    }

    public void setZeroFill(boolean flag) {
        this.zeroFill = flag;
    }

    public void setSexagesimal(boolean flag) {
        this.isSexagesimal = flag;
    }

    public void setSeparators(String[] separators) {
        if (separators != null && separators.length > 1 && separators[0] != null && separators[1] != null) {
            System.arraycopy(separators, 0, this.sexaSep, 0, 2);
        } else {
            System.err.println("Warning: Invalid separator array ignored in CoordinateFormatter.");
        }
    }

    public String format(double value, int precision) {
        if (this.isSexagesimal) {
            return this.sexagesimal(value, precision);
        }
        return this.decimal(value, precision);
    }

    public static void main(String[] args) {
        double val = Double.parseDouble(args[0]);
        int prec = Integer.parseInt(args[1]);
        CoordinateFormatter c = new CoordinateFormatter();
        System.out.println("Without leading zeros:");
        System.out.println("   Sex:" + c.sexagesimal(val, prec));
        System.out.println("   Dec:" + c.decimal(val, prec));
        c.setZeroFill(true);
        System.out.println("With leading zeros:");
        System.out.println("   Sex:" + c.sexagesimal(val, prec));
        System.out.println("   Dec:" + c.decimal(val, prec));
        c.setSeparators(new String[]{":", ":"});
        System.out.println("With leading zeros and colon separators:");
        System.out.println("   Sex:" + c.sexagesimal(val, prec));
        System.out.println("   Dec:" + c.decimal(val, prec));
    }
}

