/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractDigitsFacet;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSUnsignedLong
extends AbstractDigitsFacet {
    private static final String JAVA_CLASS_NAME = "java.math.BigInteger";
    public static final String NAME = "unsignedLong";
    public static final short TYPE = 46;
    private static final JType JTYPE = new JClass("java.math.BigInteger");
    public static final String MIN_VALUE = "0";
    public static final String MAX_VALUE = "18446744073709551615";

    public XSUnsignedLong() {
        this.setMinInclusive(MIN_VALUE);
        this.setMaxInclusive(MAX_VALUE);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public short getType() {
        return 46;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isDateTime() {
        return false;
    }

    @Override
    public JType getJType() {
        return JTYPE;
    }

    @Override
    public String newInstanceCode() {
        return "new java.math.BigInteger(\"0\");";
    }

    @Override
    public String createToJavaObjectCode(String variableName) {
        return variableName;
    }

    @Override
    public String createFromJavaObjectCode(String variableName) {
        return "((java.math.BigInteger) " + variableName + ")";
    }

    @Override
    public void validationCode(JSourceCode jsc, String fixedValue, String validatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.BigIntegerValidator typeValidator;\ntypeValidator = new org.exolab.castor.xml.validators.BigIntegerValidator();\n{0}.setValidator(typeValidator);", validatorInstanceName);
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(new BigInteger(\"" + fixedValue + "\");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        this.codeWhiteSpaceFacet(jsc, "typeValidator");
        if (this.getMinExclusive() != null) {
            jsc.add("java.math.BigInteger min = new java.math.BigInteger(\"{0}\");\ntypeValidator.setMinExclusive(min);", this.getMinExclusive());
        } else if (this.getMinInclusive() != null) {
            jsc.add("java.math.BigInteger min = new java.math.BigInteger(\"{0}\");\ntypeValidator.setMinInclusive(min);", this.getMinInclusive());
        }
        if (this.getMaxExclusive() != null) {
            jsc.add("java.math.BigInteger max = new java.math.BigInteger(\"{0}\");\ntypeValidator.setMaxExclusive(max);", this.getMaxExclusive());
        } else if (this.getMaxInclusive() != null) {
            jsc.add("java.math.BigInteger max = new java.math.BigInteger(\"{0}\");\ntypeValidator.setMaxInclusive(max);", this.getMaxInclusive());
        }
        this.codeDigitsFacet(jsc, "typeValidator");
    }
}

