/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.MalformedURLException;
import net.ivoa.registry.RegistryAccessException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryPanel;
import uk.ac.starlink.vo.RegistryStarTable;

public class RegistryTableLoadDialog
extends BasicTableLoadDialog {
    private final RegistryQueryPanel rqPanel_ = new RegistryQueryPanel();
    private static Boolean available_;
    public static String[] defaultQueries_;

    public RegistryTableLoadDialog() {
        super("Registry Query", "Imports a table describing the result of querying a registry");
        this.rqPanel_.setPresetQueries(defaultQueries_);
        this.add(this.rqPanel_);
    }

    public String getName() {
        return "Registry Query";
    }

    public String getDescription() {
        return "Returns a table describing the resources in a registry for a given query";
    }

    public boolean isAvailable() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.rqPanel_.setEnabled(enabled);
    }

    protected BasicTableLoadDialog.TableSupplier getTableSupplier() {
        try {
            final RegistryQuery query = this.rqPanel_.getRegistryQuery();
            return new BasicTableLoadDialog.TableSupplier(){

                public StarTable getTable(StarTableFactory factory, String format) throws IOException {
                    try {
                        return new RegistryStarTable(query);
                    }
                    catch (RegistryAccessException e) {
                        throw BasicTableLoadDialog.asIOException((Throwable)e);
                    }
                }

                public String getTableID() {
                    return query.toString();
                }
            };
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    static {
        defaultQueries_ = new String[]{"capability/@standardID = 'ivo://ivoa.net/std/ConeSearch'", "capability/@standardID = 'ivo://ivoa.net/std/SIA'", "capability/@standardID = 'ivo://ivoa.net/std/SSA'", "capability/@standardID = 'ivo://ivoa.net/std/Registry'"};
    }
}

