/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transport;

import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.giop.TransportListener;
import org.jacorb.transport.Current;
import org.jacorb.transport.DefaultStatisticsProvider;
import org.jacorb.transport.NoContext;
import org.omg.CORBA.LocalObject;
import org.slf4j.Logger;

public class DefaultCurrentImpl
extends LocalObject
implements Current,
TransportListener,
Configurable {
    private int statistics_provider_index_ = -1;
    private static final ThreadLocal tss_transport_event_ = new ThreadLocal();
    private Logger logger_;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger_ = configuration.getLogger("org.jacorb.transport.current");
        List<String> statsProviderClassNames = configuration.getAttributeList("jacorb.connection.statistics_providers");
        statsProviderClassNames.add(DefaultStatisticsProvider.class.getName());
        StringBuffer buff = new StringBuffer();
        Iterator<String> iter = statsProviderClassNames.iterator();
        while (iter.hasNext()) {
            buff.append((Object)iter.next());
            if (!iter.hasNext()) continue;
            buff.append(',');
        }
        configuration.setAttribute("jacorb.connection.statistics_providers", buff.toString());
        this.statistics_provider_index_ = statsProviderClassNames.size() - 1;
    }

    @Override
    public void transportSelected(TransportListener.Event event) {
        tss_transport_event_.set(event);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Transport selected " + event);
        }
    }

    protected TransportListener.Event getLatestTransportCurentEvent() throws NoContext {
        TransportListener.Event e = (TransportListener.Event)tss_transport_event_.get();
        if (e == null) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("No events were available. Is traits() called outside of an upcall or interceptor?");
            }
            throw new NoContext();
        }
        return e;
    }

    @Override
    public int id() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        return e.hashCode();
    }

    @Override
    public long bytes_sent() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.bytes_sent_;
    }

    @Override
    public long bytes_received() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.bytes_received_;
    }

    @Override
    public long messages_sent() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.messages_sent_;
    }

    @Override
    public long messages_received() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.messages_received_;
    }

    @Override
    public long open_since() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.created_;
    }
}

