/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.interactor.Geometry;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class RectangleGeometry
implements Geometry {
    private Figure _parentFigure;
    private double _minSize = 10.0;
    private double _xOvershoot = 0.0;
    private double _yOvershoot = 0.0;
    private RectangularShape _rect;
    private Shape _path;
    private static int _siteCount = 5;
    private RectangleSite[] _sites = new RectangleSite[_siteCount];
    private double _rotateAngle = 0.0;
    private Point2D _rotateCenter;

    public RectangleGeometry(Figure figure, Shape shape) {
        this._parentFigure = figure;
        this.setShape(shape);
        this._setRotateCenter(new Point2D.Double(this._rect.getCenterX(), this._rect.getCenterY()));
    }

    public Site getSite(int id) {
        if (this._sites[id] == null) {
            this._sites[id] = new RectangleSite(id);
        }
        return this._sites[id];
    }

    public double getMinimumSize() {
        return this._minSize;
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public Shape getShape() {
        return this._path;
    }

    public double getRotateAngle() {
        return this._rotateAngle;
    }

    public double getNormalizedRotateAngle() {
        double tmp = this.getRotateAngle() + Math.PI;
        double frac = tmp - Math.floor(tmp / (Math.PI * 2)) * (Math.PI * 2);
        return frac - Math.PI;
    }

    public RectangularShape getRect() {
        return this._rect;
    }

    public void setMinimumSize(double minimumSize) {
        this._minSize = minimumSize;
    }

    public void setShape(Shape shape) {
        this._rect = shape.getBounds2D();
        this._path = this._rect;
    }

    public void refresh(Figure figure) {
        Shape shape = figure.getShape();
        if (shape instanceof RectangularShape) {
            this._rect = figure.getBounds();
            this._path = this._rect;
        } else if (this._path instanceof Path2D) {
            this.refresh((Path2D)this._path);
        }
    }

    private void refresh(Path2D path) {
        double[] ret = this.calcGeom(path);
        double centerX = ret[0];
        double centerY = ret[1];
        double width = ret[2];
        double height = ret[3];
        if (this._rect != null) {
            this._rect.setFrameFromCenter(centerX, centerY, centerX + width / 2.0, centerY + height / 2.0);
        }
        this._setRotateCenter(new Point2D.Double(centerX, centerY));
        this._setRotateAngle(this.calcAngle(path));
    }

    private Point2D.Double[] getCorners(Path2D path) {
        Point2D.Double[] corners = new Point2D.Double[4];
        double[] coords = new double[6];
        PathIterator pathItr = path.getPathIterator(new AffineTransform());
        for (int i = 0; i < 4; ++i) {
            pathItr.currentSegment(coords);
            corners[i] = new Point2D.Double(coords[0], coords[1]);
            pathItr.next();
        }
        return corners;
    }

    private double calcAngle(Path2D path) {
        Point2D.Double[] corners = this.getCorners(path);
        double dx = corners[1].x - corners[0].x;
        double dy = corners[1].y - corners[0].y;
        return Math.atan2(dy, dx);
    }

    private double[] calcGeom(Path2D path) {
        double[] ret = new double[4];
        Point2D.Double[] corners = this.getCorners(path);
        ret[0] = (corners[0].x + corners[2].x) / 2.0;
        ret[1] = (corners[0].y + corners[2].y) / 2.0;
        double dx = corners[1].x - corners[0].x;
        double dy = corners[1].y - corners[0].y;
        ret[2] = Math.sqrt(dx * dx + dy * dy);
        dx = corners[2].x - corners[1].x;
        dy = corners[2].y - corners[1].y;
        ret[3] = Math.sqrt(dx * dx + dy * dy);
        return ret;
    }

    public Iterator sites() {
        return new Iterator(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < _siteCount;
            }

            public Object next() {
                if (RectangleGeometry.this._sites[this.cursor] == null) {
                    ((RectangleGeometry)RectangleGeometry.this)._sites[this.cursor] = new RectangleSite(this.cursor);
                }
                return RectangleGeometry.this._sites[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Site cannot be removed");
            }
        };
    }

    public void transform(AffineTransform at) {
        this._path = at.createTransformedShape(this._path);
        this._rotateCenter = at.transform(this._rotateCenter, this._rotateCenter);
    }

    public void translate(double x, double y) {
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        this._path = at.createTransformedShape(this._path);
        this._rect.setFrame(this._rect.getX() + x, this._rect.getY() + y, this._rect.getWidth(), this._rect.getHeight());
        this._rotateCenter.setLocation(this._rotateCenter.getX() + x, this._rotateCenter.getY() + y);
    }

    private void _setRotateAngle(double angle) {
        this._rotateAngle = angle;
    }

    public Point2D getRotateCenter() {
        return this._rotateCenter;
    }

    private void _setRotateCenter(Point2D p) {
        this._rotateCenter = p;
    }

    public class RectangleSite
    extends AbstractSite {
        private int _id;
        private double _offX;
        private double _offY;

        RectangleSite(int id) {
            this._id = id;
            this.offset();
        }

        private void offset() {
            switch (this._id) {
                case 0: {
                    this._offX = RectangleGeometry.this._rect.getWidth() / 2.0;
                    this._offY = RectangleGeometry.this._rect.getHeight() / 2.0;
                    return;
                }
                case 1: {
                    this._offX = RectangleGeometry.this._rect.getWidth() / 2.0;
                    this._offY = 0.0;
                    return;
                }
                case 2: {
                    this._offX = 0.0;
                    this._offY = -RectangleGeometry.this._rect.getHeight() / 2.0;
                    return;
                }
                case 3: {
                    this._offX = -RectangleGeometry.this._rect.getWidth() / 2.0;
                    this._offY = 0.0;
                    return;
                }
                case 4: {
                    this._offX = 0.0;
                    this._offY = RectangleGeometry.this._rect.getHeight() / 2.0;
                }
            }
        }

        public int getID() {
            return this._id;
        }

        public Figure getFigure() {
            return RectangleGeometry.this._parentFigure;
        }

        public Point2D getPoint() {
            this.offset();
            Point2D.Double point = new Point2D.Double(RectangleGeometry.this._rect.getCenterX() + this._offX, RectangleGeometry.this._rect.getCenterY() + this._offY);
            AffineTransform af = new AffineTransform();
            af.setToRotation(RectangleGeometry.this.getRotateAngle(), RectangleGeometry.this.getRotateCenter().getX(), RectangleGeometry.this.getRotateCenter().getY());
            af.transform(point, point);
            return point;
        }

        public double getX() {
            return this.getPoint().getX();
        }

        public double getY() {
            return this.getPoint().getY();
        }

        public void translate(double dx, double dy) {
            Point2D p1 = this.getPoint();
            Point2D p2 = this.getPoint();
            p2.setLocation(p2.getX() + dx, p2.getY() + dy);
            AffineTransform af = new AffineTransform();
            af.setToRotation(-RectangleGeometry.this.getRotateAngle(), RectangleGeometry.this.getRotateCenter().getX(), RectangleGeometry.this.getRotateCenter().getY());
            af.transform(p1, p1);
            af.transform(p2, p2);
            double x = p2.getX() - p1.getX();
            double y = p2.getY() - p1.getY();
            double x1 = RectangleGeometry.this._rect.getX();
            double y1 = RectangleGeometry.this._rect.getY();
            double x2 = x1 + RectangleGeometry.this._rect.getWidth();
            double y2 = y1 + RectangleGeometry.this._rect.getHeight();
            switch (this._id) {
                case 0: {
                    x2 += x;
                    y2 += y;
                    break;
                }
                case 1: {
                    x2 += x;
                    break;
                }
                case 2: {
                    y1 += y;
                    break;
                }
                case 3: {
                    x1 += x;
                    break;
                }
                case 4: {
                    y2 += y;
                }
            }
            switch (this._id) {
                case 0: 
                case 1: {
                    if (x2 < x1 + RectangleGeometry.this._minSize || RectangleGeometry.this._xOvershoot < 0.0) {
                        RectangleGeometry.this._xOvershoot += x - (x1 + RectangleGeometry.this._minSize - (x2 - x));
                        x2 = x1 + RectangleGeometry.this._minSize;
                        break;
                    }
                    RectangleGeometry.this._xOvershoot = 0.0;
                    break;
                }
                case 3: {
                    if (x1 > x2 - RectangleGeometry.this._minSize || RectangleGeometry.this._xOvershoot < 0.0) {
                        RectangleGeometry.this._xOvershoot += x - (x1 + RectangleGeometry.this._minSize - (x2 - x));
                        x1 = x2 - RectangleGeometry.this._minSize;
                        break;
                    }
                    RectangleGeometry.this._xOvershoot = 0.0;
                }
            }
            switch (this._id) {
                case 2: {
                    if (y1 > y2 - RectangleGeometry.this._minSize || RectangleGeometry.this._yOvershoot < 0.0) {
                        RectangleGeometry.this._yOvershoot += y - (y1 + RectangleGeometry.this._minSize - (y2 - y));
                        y1 = y2 - RectangleGeometry.this._minSize;
                        break;
                    }
                    RectangleGeometry.this._yOvershoot = 0.0;
                    break;
                }
                case 0: 
                case 4: {
                    if (y2 < y1 + RectangleGeometry.this._minSize || RectangleGeometry.this._yOvershoot < 0.0) {
                        RectangleGeometry.this._yOvershoot += y - (y1 + RectangleGeometry.this._minSize - (y2 - y));
                        y2 = y1 + RectangleGeometry.this._minSize;
                        break;
                    }
                    RectangleGeometry.this._yOvershoot = 0.0;
                }
            }
            RectangleGeometry.this._rect.setFrameFromDiagonal(x1, y1, x2, y2);
        }

        public void setPoint(Point2D point) {
            this.translate(point.getX() - this.getX(), point.getY() - this.getY());
        }

        public String toString() {
            return "id=" + this._id + ", _offX=" + this._offX + ", _offY=" + this._offY;
        }
    }
}

