/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.hla.runtime.obsprep.util.Log;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public abstract class Resolver
implements Runnable {
    private boolean isQuerySuccessful = false;
    private boolean isQueryReturned = false;
    public static double NODATA = Double.POSITIVE_INFINITY;
    public static double INVALID = Double.NEGATIVE_INFINITY;
    protected String name = null;
    protected double ra;
    protected double dec;
    protected double properMotionRa;
    protected double properMotionDec;
    protected Velocity sourceVelocity;
    protected double parallax;
    protected final List<Resolver> results = new ArrayList<Resolver>(10);
    protected String errorMessage = null;
    protected ResolverService resolverService = ResolverService.UNKNOWN;

    public abstract void query(String var1) throws IOException, MalformedURLException;

    protected Resolver() {
        this.reset();
    }

    public void reset() {
        this.setQueryCompleted(false);
        this.setQuerySuccessful(false);
        this.ra = NODATA;
        this.dec = NODATA;
        this.properMotionRa = NODATA;
        this.properMotionDec = NODATA;
        this.sourceVelocity = null;
        this.parallax = NODATA;
        this.errorMessage = null;
    }

    public void fail() {
        this.ra = INVALID;
        this.dec = INVALID;
        this.isQueryReturned = false;
        this.isQuerySuccessful = false;
    }

    public abstract void setNameServer(String var1);

    public abstract String getNameServer();

    public List<Resolver> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "Unknown";
        if (this.sourceVelocity != null) {
            string = this.sourceVelocity.toString();
        }
        stringBuilder.append("Server = " + this.getNameServer() + " : ").append("name = " + this.name + ", ").append("ra = " + this.doubleToString(this.ra) + ", ").append("dec = " + this.doubleToString(this.dec) + ", ").append("pmRA = " + this.doubleToString(this.properMotionRa) + ", ").append("pmDec = " + this.doubleToString(this.properMotionDec) + ", ").append("sourceVelocity = " + string + ", ").append("parallax = " + this.doubleToString(this.parallax)).append("resolver = " + this.resolverService.getResolutionServiceName());
        return stringBuilder.toString();
    }

    private String doubleToString(double d) {
        if (d == NODATA || d == INVALID) {
            return "(No Data)";
        }
        return Double.toString(d);
    }

    @Override
    public void run() {
        try {
            this.query(this.getName());
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage("MalformedURLException:" + malformedURLException.getMessage());
            this.fail();
        }
        catch (UnknownHostException unknownHostException) {
            this.setErrorMessage("Unknown Host: " + unknownHostException.getMessage() + ".\nIs the network online?");
            this.fail();
        }
        catch (ConnectException connectException) {
            this.setErrorMessage("Could not connect to the host: " + connectException.getMessage() + "\nIs the network online? Server trouble?");
            this.fail();
        }
        catch (IOException iOException) {
            this.setErrorMessage("IO Error : Network trouble?");
            this.fail();
        }
    }

    protected void failedResolutionHandler(String string, String string2) {
        this.setErrorMessage(string + " " + string2);
        Log.logger((Object)this).warning(string + " " + string2);
        this.reset();
        this.fail();
        this.results.clear();
    }

    public boolean isQueryCompleted() {
        return this.isQueryReturned;
    }

    public void setQueryCompleted(boolean bl) {
        this.isQueryReturned = bl;
    }

    public boolean isQuerySuccessful() {
        return this.isQuerySuccessful;
    }

    public void setQuerySuccessful(boolean bl) {
        this.isQuerySuccessful = bl;
    }

    public boolean isQueryReturned() {
        return this.isQueryReturned;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public double getRa() {
        return this.ra;
    }

    public void setRa(double d) {
        this.ra = d;
    }

    public double getDec() {
        return this.dec;
    }

    public void setDec(double d) {
        this.dec = d;
    }

    public double getProperMotionRa() {
        return this.properMotionRa;
    }

    public void setProperMotionRa(double d) {
        this.properMotionRa = d;
    }

    public double getProperMotionDec() {
        return this.properMotionDec;
    }

    public void setProperMotionDec(double d) {
        this.properMotionDec = d;
    }

    public Velocity getSourceVelocity() {
        return this.sourceVelocity;
    }

    public void setSourceVelocity(Velocity velocity) {
        this.sourceVelocity = velocity;
    }

    public double getParallax() {
        return this.parallax;
    }

    public void setParallax(double d) {
        this.parallax = d;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public ResolverService getResolverService() {
        return this.resolverService;
    }

    public void setResolverService(ResolverService resolverService) {
        this.resolverService = resolverService;
    }

    public static enum ResolverService {
        UNKNOWN("Unknown"),
        SIMBAD("SIMBAD"),
        NED("NED"),
        VIZIER("Vizier");

        @NonNull
        private String resolutionServiceName;

        private ResolverService(String string2) {
            if (string2 == null) {
                throw new NullPointerException("resolutionServiceName is marked non-null but is null");
            }
            this.resolutionServiceName = string2;
        }

        @NonNull
        public String getResolutionServiceName() {
            return this.resolutionServiceName;
        }
    }
}

