/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions.wrappers;

import alma.Control.LO2Parameters;
import alma.Control.TuningParameters;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.services.losolutions.wrappers.LO2ParametersWrapper;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;

public class TuningParametersWrapper {
    private String receiverBand = RECEIVERBAND_BAND03;
    private Frequency lSFrequency;
    private Frequency fLOOGFrequency;
    private boolean tuneHigh;
    private int coldMultiplier;
    private boolean band0band1selectUSB;
    private boolean band2band3selectUSB;
    private double weightedError;
    private double score;
    private int basebandCount;
    private Frequency actualLO1;
    private List<LO2ParametersWrapper> lo2list = new ArrayList<LO2ParametersWrapper>();
    public static String RECEIVERBAND_BAND01 = FrequencySetup.RECEIVERBAND_ALMA_RB_01;
    public static String RECEIVERBAND_BAND02 = FrequencySetup.RECEIVERBAND_ALMA_RB_02;
    public static String RECEIVERBAND_BAND03 = FrequencySetup.RECEIVERBAND_ALMA_RB_03;
    public static String RECEIVERBAND_BAND04 = FrequencySetup.RECEIVERBAND_ALMA_RB_04;
    public static String RECEIVERBAND_BAND05 = FrequencySetup.RECEIVERBAND_ALMA_RB_05;
    public static String RECEIVERBAND_BAND06 = FrequencySetup.RECEIVERBAND_ALMA_RB_06;
    public static String RECEIVERBAND_BAND07 = FrequencySetup.RECEIVERBAND_ALMA_RB_07;
    public static String RECEIVERBAND_BAND08 = FrequencySetup.RECEIVERBAND_ALMA_RB_08;
    public static String RECEIVERBAND_BAND09 = FrequencySetup.RECEIVERBAND_ALMA_RB_09;
    public static String RECEIVERBAND_BAND10 = FrequencySetup.RECEIVERBAND_ALMA_RB_10;
    private static String[] knownReceiverBand = new String[]{RECEIVERBAND_BAND01, RECEIVERBAND_BAND02, RECEIVERBAND_BAND03, RECEIVERBAND_BAND04, RECEIVERBAND_BAND05, RECEIVERBAND_BAND06, RECEIVERBAND_BAND07, RECEIVERBAND_BAND08, RECEIVERBAND_BAND09, RECEIVERBAND_BAND10};

    public static String[] getKnownReceiverBand() {
        return knownReceiverBand;
    }

    public TuningParametersWrapper() {
    }

    public TuningParametersWrapper(TuningParameters tuningParameters) {
        this();
        this.importNativeTuningParameters(tuningParameters);
    }

    public void importNativeTuningParameters(TuningParameters tuningParameters) {
        if (tuningParameters.receiverBand.value() >= 10) {
            throw new IllegalArgumentException("OT does not expect the receiver : " + String.valueOf(tuningParameters.receiverBand));
        }
        this.receiverBand = knownReceiverBand[tuningParameters.receiverBand.value()];
        this.getLSFrequency().setContentInGHz(tuningParameters.LSFrequency / 1.0E9);
        this.getFLOOGFrequency().setContentInGHz(tuningParameters.FLOOGFrequency / 1.0E9);
        this.tuneHigh = tuningParameters.tuneHigh;
        this.coldMultiplier = tuningParameters.coldMultiplier;
        this.band0band1selectUSB = tuningParameters.band0band1selectUSB;
        this.band2band3selectUSB = tuningParameters.band2band3selectUSB;
        this.weightedError = tuningParameters.weightedError;
        this.score = tuningParameters.score;
        this.clearLO2();
        for (LO2Parameters lO2Parameters : tuningParameters.LO2) {
            this.addLO2(new LO2ParametersWrapper(lO2Parameters));
        }
    }

    public String getReceiverBand() {
        return this.receiverBand;
    }

    public void setReceiverBand(String string) {
        this.receiverBand = string;
    }

    public Frequency getLSFrequency() {
        if (this.lSFrequency == null) {
            this.lSFrequency = Frequency.createFrequency();
        }
        return this.lSFrequency;
    }

    public void setLSFrequency(Frequency frequency) {
        this.lSFrequency = frequency;
    }

    public Frequency getFLOOGFrequency() {
        if (this.fLOOGFrequency == null) {
            this.fLOOGFrequency = Frequency.createFrequency();
        }
        return this.fLOOGFrequency;
    }

    public void setFLOOGFrequency(Frequency frequency) {
        this.fLOOGFrequency = frequency;
    }

    public boolean getTuneHigh() {
        return this.tuneHigh;
    }

    public void setTuneHigh(boolean bl) {
        this.tuneHigh = bl;
    }

    public int getColdMutiplier() {
        return this.coldMultiplier;
    }

    public void setColdMultiplier(int n) {
        this.coldMultiplier = n;
    }

    public boolean getBand0band1selectUSB() {
        return this.band0band1selectUSB;
    }

    public void setBand0band1selectUSB(boolean bl) {
        this.band0band1selectUSB = bl;
    }

    public boolean getBand2band3selectUSB() {
        return this.band2band3selectUSB;
    }

    public void setBand2band3selectUSB(boolean bl) {
        this.band2band3selectUSB = bl;
    }

    public double getWeightedError() {
        return this.weightedError;
    }

    public void setWeightedError(double d) {
        this.weightedError = d;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double d) {
        this.score = d;
    }

    public int getBasebandCount() {
        return this.basebandCount;
    }

    public void setBasebandCount(int n) {
        this.basebandCount = n;
    }

    public Frequency getActualLO1() {
        return this.actualLO1;
    }

    public void setActualLO1(Frequency frequency) {
        this.actualLO1 = frequency;
    }

    public int getLO2Count() {
        return this.lo2list.size();
    }

    public LO2ParametersWrapper[] getLO2() {
        return this.lo2list.toArray(new LO2ParametersWrapper[this.lo2list.size()]);
    }

    public LO2ParametersWrapper getLO2(int n) {
        return this.lo2list.get(n);
    }

    public void addLO2(LO2ParametersWrapper lO2ParametersWrapper) {
        this.addLO2(this.lo2list.size(), lO2ParametersWrapper);
    }

    public void addLO2(int n, LO2ParametersWrapper lO2ParametersWrapper) {
        this.lo2list.add(n, lO2ParametersWrapper);
    }

    public LO2ParametersWrapper removeLO2(int n) {
        return this.lo2list.remove(n);
    }

    public boolean removeLO2(LO2ParametersWrapper lO2ParametersWrapper) {
        return this.lo2list.remove(lO2ParametersWrapper);
    }

    public void clearLO2() {
        this.lo2list.clear();
    }
}

