/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.FieldSourceData;
import alma.obsprep.bo.schedblock.data.TargetData;
import alma.obsprep.ot.models.schedblock.ReferencePointModel;
import alma.obsprep.ot.models.schedblock.observingparameters.ScienceParameterModel;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.RepresentativeTargetCalculator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.sbbuilder.TPSBGeneratorFactory;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

class TotalPowerSBScienceTargetDistributor {
    private final SchedBlock schedBlock;
    private static final double tpMaxTOSPerSB_s = AlmaPolicies.getInstance().getTpMaxTOSPerSB().getSecs();

    public TotalPowerSBScienceTargetDistributor(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (!schedBlock.isTotalPowerScienceSB()) {
            throw new IllegalArgumentException("The SB provided should be a TP science SB");
        }
        this.schedBlock = schedBlock;
    }

    public List<SchedBlock> ensureAllSourcesObservableWithinTPSBExecutionTOS() throws UnknownEntityException {
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        if (this.isRasteringAllSourcesInSameTPSBExecutionPossible(this.schedBlock)) {
            return List.of(this.schedBlock);
        }
        List<Map<FieldSource, Time>> list = this.createSBExecutionTimeCompliantSourceGroupings(this.schedBlock);
        assert (list != null && !list.isEmpty()) : "It is expected that there should be more than a single subgroup";
        arrayList.add(this.schedBlock);
        for (Map<FieldSource, Time> map2 : list.subList(1, list.size())) {
            SchedBlock schedBlock = this.schedBlock.deepCopy();
            schedBlock.getSbGenerationContext().setSB(schedBlock);
            List<String> list2 = map2.keySet().stream().map(FieldSourceData::getSourceName).toList();
            List<Target> list3 = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
            List<Target> list4 = list3.stream().filter(target -> !list2.contains(target.getFieldSource().getSourceName())).toList();
            list4.stream().forEach(schedBlock::removeTarget);
            List<FieldSource> list5 = list3.stream().filter(target -> !list2.contains(target.getFieldSource().getSourceName())).map(TargetData::getFieldSource).toList();
            list5.stream().forEach(arg_0 -> ((SchedBlock)schedBlock).removeFieldSource(arg_0));
            arrayList.add(schedBlock);
        }
        List<Target> list6 = this.schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        list.subList(1, list.size()).stream().forEach(map -> map.entrySet().stream().forEach(entry -> {
            List<String> list2 = map.keySet().stream().map(FieldSourceData::getSourceName).toList();
            this.schedBlock.removeFieldSource((FieldSource)entry.getKey());
            List<Target> list3 = list6.stream().filter(target -> list2.contains(target.getFieldSource().getSourceName())).toList();
            list3.stream().forEach(this.schedBlock::removeTarget);
        }));
        this.reassignRepresentativeTargetsInSBs(arrayList);
        arrayList.stream().forEach(this::setObservingGroupDopplerTarget);
        this.recalculateSpectralSpecsUsingReassignedDopplerTargets(arrayList);
        arrayList.stream().forEach(this::removeUnusedScienceParameters);
        arrayList.stream().forEach(this::quantizeSubscanDurationsInTPSBs);
        return arrayList;
    }

    private void quantizeSubscanDurationsInTPSBs(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            for (Reference reference : target.getFieldSource().getReference()) {
                ReferencePointModel referencePointModel = new ReferencePointModel(reference);
                try {
                    referencePointModel.adjustSubscanDuration();
                }
                catch (ReferencePointModel.UnableToAdjustSubscanDurationException unableToAdjustSubscanDurationException) {
                    throw new WizardSBGenerationException("Unable to align subscan duration " + unableToAdjustSubscanDurationException.getMessage());
                }
            }
            target.getScienceParametersCollection().stream().forEach(scienceParameters -> {
                ScienceParameterModel scienceParameterModel = new ScienceParameterModel((ScienceParameters)((Object)scienceParameters));
                try {
                    scienceParameterModel.adjustSubscanDuration();
                }
                catch (ScienceParameterModel.UnableToAdjustSubscanDuration unableToAdjustSubscanDuration) {
                    // empty catch block
                }
            });
        }
    }

    private void recalculateSpectralSpecsUsingReassignedDopplerTargets(@NonNull List<SchedBlock> list) {
        if (list == null) {
            throw new NullPointerException("tpSBSubgroups is marked non-null but is null");
        }
        for (SchedBlock schedBlock : list) {
            ScienceGoal scienceGoal = this.generateSGWithSBScienceTargetsOnly(schedBlock);
            Collection<Collection<SchedBlock>> collection = TPSBGeneratorFactory.getTotalPowerSBGenerator(this.schedBlock.getSbGenerationContext()).getSchedBlocks(scienceGoal);
            this.updateTPSubgroupSBSpectralSpecsForNewDopplerTarget(collection, schedBlock);
            Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("New TP SBs have been generated");
        }
    }

    private void updateTPSubgroupSBSpectralSpecsForNewDopplerTarget(Collection<Collection<SchedBlock>> collection, SchedBlock schedBlock) {
        Set set = Arrays.stream(schedBlock.getFieldSource()).map(FieldSourceData::getSourceName).collect(Collectors.toSet());
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock2 : collection2) {
                Set set2 = Arrays.stream(schedBlock2.getFieldSource()).map(FieldSourceData::getSourceName).collect(Collectors.toSet());
                if (!set2.containsAll(set) || !set.containsAll(set2)) continue;
                this.reviseSpectralSpecUsingNewDopplerTarget(schedBlock2, schedBlock);
            }
        }
    }

    private void reviseSpectralSpecUsingNewDopplerTarget(@NonNull SchedBlock schedBlock, @NonNull SchedBlock schedBlock2) {
        if (schedBlock == null) {
            throw new NullPointerException("sbWithRevisedDopplerTarget is marked non-null but is null");
        }
        if (schedBlock2 == null) {
            throw new NullPointerException("tpSubgroupSB is marked non-null but is null");
        }
        HashSet hashSet = new HashSet();
        List<Target> list = schedBlock2.getAllTargets(ScienceParameters.scienceParametersFilter);
        for (Target target2 : list) {
            if (hashSet.contains(target2)) continue;
            String string = target2.getFieldSource().getSourceName();
            Target target3 = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().filter(target -> target.getFieldSource().getSourceName().equals(string)).findFirst().get();
            assert (target3.getFieldSource().getSourceName().equals(string));
            SpectralSpec spectralSpec = target2.getSpectralSpec();
            SpectralSpec spectralSpec2 = target3.getSpectralSpec();
            schedBlock2.addSpectralSpec(spectralSpec2);
            list.stream().filter(target -> target.getSpectralSpec().equals(spectralSpec)).forEach(target -> {
                target.setSpectralSpec(spectralSpec2);
                hashSet.add(target);
            });
            schedBlock2.removeSpectralSpec(spectralSpec);
        }
    }

    private ScienceGoal generateSGWithSBScienceTargetsOnly(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("subgroupSB is marked non-null but is null");
        }
        ScienceGoal scienceGoal = schedBlock.getSbGenerationContext().getGoal().deepCopy();
        assert (scienceGoal != null);
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        List<TargetParameters> list2 = Arrays.asList(scienceGoal.getTargetParameters());
        List<TargetParameters> list3 = list2.stream().filter(targetParameters -> !this.isTargetParameterInSB((TargetParameters)targetParameters, list)).toList();
        list3.stream().forEach(scienceGoal::removeTargetParameters);
        scienceGoal.setKeyTargetParameters(0);
        Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("Target parameters in science goal " + String.valueOf(scienceGoal.getKeyTargetParameters()));
        return scienceGoal;
    }

    private boolean isTargetParameterInSB(@NonNull TargetParameters targetParameters, @NonNull List<Target> list) {
        if (targetParameters == null) {
            throw new NullPointerException("tp is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("scienceTargets is marked non-null but is null");
        }
        return list.stream().anyMatch(target -> target.getFieldSource().getTargetParameters().getSourceName().equals(targetParameters.getSourceName()));
    }

    private void removeUnusedScienceParameters(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        Set set = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().map(target -> target.getFirstScienceParameters().get()).collect(Collectors.toSet());
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>(Arrays.asList(schedBlock.getObservingParametersScienceParameters()));
        set.stream().forEach(hashSet::remove);
        hashSet.stream().forEach(arg_0 -> ((SchedBlock)schedBlock).removeObservingParameters(arg_0));
    }

    private void reassignRepresentativeTargetsInSBs(@NonNull List<SchedBlock> list) {
        if (list == null) {
            throw new NullPointerException("tpSBSubgroups is marked non-null but is null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: tpSBSubgroups.isEmpty() (" + list.isEmpty() + ") did not pass the test: tpSBSubgroups.isEmpty() test");
        }
        for (SchedBlock schedBlock : list) {
            List<Target> list2 = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
            if (list2.isEmpty()) continue;
            SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
            Target target = list2.get(0);
            schedulingConstraints.setRepresentativeTarget(target);
            schedulingConstraints.setRepresentativeCoordinates(target.getFieldSource().getSourceCoordinates().getICRSSkyCoordinates().deepCopy());
        }
    }

    private List<Map<FieldSource, Time>> createSBExecutionTimeCompliantSourceGroupings(@NonNull SchedBlock schedBlock) throws UnknownEntityException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        Map<FieldSource, Time> map = this.getRasterScanTimesForSources(this.schedBlock);
        ArrayList<Map<FieldSource, Time>> arrayList = new ArrayList<Map<FieldSource, Time>>();
        double d = 0.0;
        LinkedHashMap<FieldSource, Time> linkedHashMap = new LinkedHashMap<FieldSource, Time>();
        for (Map.Entry<FieldSource, Time> entry : map.entrySet()) {
            double d2 = entry.getValue().getSecs();
            if (d2 + d <= tpMaxTOSPerSB_s) {
                linkedHashMap.put(entry.getKey(), entry.getValue());
            } else {
                arrayList.add(linkedHashMap);
                linkedHashMap = new LinkedHashMap();
                linkedHashMap.put(entry.getKey(), entry.getValue());
                d = 0.0;
            }
            d += d2;
        }
        if (!linkedHashMap.isEmpty()) {
            arrayList.add(linkedHashMap);
        }
        this.spreadSourcesEvenlyAcrossSubgroups(arrayList);
        return arrayList;
    }

    private List<Map<FieldSource, Time>> spreadSourcesEvenlyAcrossSubgroups(@NonNull List<Map<FieldSource, Time>> list) {
        if (list == null) {
            throw new NullPointerException("fieldSourceSubgroups is marked non-null but is null");
        }
        int n = list.size();
        int n2 = list.stream().mapToInt(Map::size).sum();
        int n3 = n2 / n;
        Comparator comparator = (map, map2) -> Integer.valueOf(map.size()).compareTo(map2.size());
        Comparator comparator2 = (map, map2) -> Integer.valueOf(map2.size()).compareTo(map.size());
        List list2 = list.stream().sorted(comparator).toList();
        List list3 = list.stream().sorted(comparator2).toList();
        block0: for (Map map3 : list3) {
            for (Map map4 : list2) {
                boolean bl = false;
                do {
                    Map.Entry entry3;
                    bl = false;
                    if (map3.size() <= n3 || map4.size() >= n3 || map3.size() <= map4.size()) continue block0;
                    if (map3 == map4) break block0;
                    Comparator comparator3 = (entry, entry2) -> {
                        int n = (int)((Time)entry.getValue()).getSecs();
                        Integer n2 = (int)((Time)entry2.getValue()).getSecs();
                        return Integer.compare(n, n2);
                    };
                    Optional optional = map3.entrySet().stream().min(comparator3);
                    double d = map4.entrySet().stream().mapToDouble(entry -> ((Time)entry.getValue()).getSecs()).sum();
                    if (!(d + ((Time)(entry3 = (Map.Entry)optional.orElseThrow(() -> new WizardSBGenerationException("Failed to get smallest t_rect"))).getValue()).getSecs() <= tpMaxTOSPerSB_s)) continue;
                    map4.put((FieldSource)entry3.getKey(), (Time)entry3.getValue());
                    map3.remove(entry3.getKey());
                    bl = true;
                } while (bl);
            }
        }
        return list;
    }

    private Map<FieldSource, Time> getRasterScanTimesForSources(@NonNull SchedBlock schedBlock) throws UnknownEntityException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        boolean bl = schedBlock.getSbGenerationContext().getGoal().isSolarScienceGoal();
        Time time3 = AlmaPolicies.getInstance().getItosForSolarSource();
        HashMap<FieldSource, Time> hashMap = new HashMap<FieldSource, Time>();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            FieldSource fieldSource = target.getFieldSource();
            if (!fieldSource.getFieldPatternType().equals(FieldPattern.FieldPatternType.RECTANGLE.getLabel())) {
                throw new RuntimeException("Unexpected field type found in TP science TP: " + fieldSource.getFieldPatternType());
            }
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
            Time time4 = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to get science parameters")).getSubScanDuration();
            Time time5 = bl ? time3.deepCopy() : Time.createTimeSec(time4.getSecs() * (double)rectanglePattern.getRowCount());
            hashMap.put(fieldSource, time5);
        }
        Map map = hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.naturalOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (time, time2) -> time, LinkedHashMap::new));
        return map;
    }

    private boolean isRasteringAllSourcesInSameTPSBExecutionPossible(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        double d = 0.0;
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to find science parameters when expected"));
            double d2 = scienceParameters.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("No TP raster data found when expected")).getT_rect().getSecs();
            d += d2;
        }
        return d <= tpMaxTOSPerSB_s;
    }

    private void setObservingGroupDopplerTarget(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            String string = observingGroup.getName();
            assert (string != null);
            try {
                if (!SBTimeEstimateHelper.GroupType.SCIENCE.equals((Object)SBTimeEstimateHelper.GroupType.getGroupType(string))) continue;
                RepresentativeTargetCalculator representativeTargetCalculator = new RepresentativeTargetCalculator();
                Target target = representativeTargetCalculator.getRepresentativeScienceTargetInObservingGroup(observingGroup, schedBlock, schedBlock.getSbGenerationContext());
                observingGroup.setMainTarget(target);
                Log.logger(SBGeneratorTemplate.class).fine(String.format("Rep. target for observing group %s is %s", observingGroup.getName(), target.getFieldSource().getSourceName()));
            }
            catch (SchedBlock.UnableToFindParentScienceGoalException | SBTimeEstimateHelper.UnknownObservingGroupTypeException | RepresentativeTargetCalculator.UnableToDetermineRepTargetForObservingGroupException exception) {
                throw new WizardSBGenerationException("Unable to set the doppler target for the observing group: " + string + " " + exception.getMessage());
            }
        }
    }
}

