/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.matchers.Matcher;

public class Lo2BasebandMatcher
implements Matcher<SpectralLine> {
    private static final Frequency TWO_GHZ = Frequency.createFrequencyGHZ(2.0);
    private static final Frequency FOUR_GHZ = Frequency.createFrequencyGHZ(4.0);
    private final FrequencyRange baseband;

    public Lo2BasebandMatcher(Frequency frequency, Frequency frequency2, Velocity velocity, boolean bl) {
        Frequency frequency3;
        Frequency frequency4;
        if (bl) {
            frequency4 = (Frequency)((Frequency)frequency.plus((AbstractDoubleWithUnit)frequency2)).minus((AbstractDoubleWithUnit)FOUR_GHZ);
            frequency3 = (Frequency)((Frequency)frequency.plus((AbstractDoubleWithUnit)frequency2)).minus((AbstractDoubleWithUnit)TWO_GHZ);
        } else {
            frequency4 = (Frequency)((Frequency)frequency.minus((AbstractDoubleWithUnit)frequency2)).plus((AbstractDoubleWithUnit)TWO_GHZ);
            frequency3 = (Frequency)((Frequency)frequency.minus((AbstractDoubleWithUnit)frequency2)).plus((AbstractDoubleWithUnit)FOUR_GHZ);
        }
        frequency4 = velocity.reverseShift(frequency4);
        frequency3 = velocity.reverseShift(frequency3);
        this.baseband = new FrequencyRange(frequency4, frequency3);
    }

    public boolean matches(SpectralLine spectralLine) {
        Frequency frequency = spectralLine.getFrequency();
        return this.baseband.contains(frequency);
    }
}

