/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;

public class OpticalCameraSpecValidator
extends AbstractValidator {
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        OpticalCameraSpec opticalCameraSpec = (OpticalCameraSpec)businessObject;
        if (Log.logger((Object)this).info()) {
            Log.logger((Object)this).info("BO is " + String.valueOf(opticalCameraSpec) + ", Parent is " + String.valueOf(opticalCameraSpec.getParent()));
        }
        if (opticalCameraSpec.getUsedCount() == 0) {
            problem = DefaultProblem.createWarning("Optical camera spec. " + opticalCameraSpec.getName() + " is not used by any target", " ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!(opticalCameraSpec.getMinIntegrationTime().getContent() > 0.0)) {
            problem = DefaultProblem.createError("Minimum exposure time in the optical camera is invalid", "In the Optical Camera Spec editor insert an exposure time that is greater than 0", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

