/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.common.horizonsparser.HorizonParser;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import java.io.IOException;
import java.util.List;

public class EphemerisValidator {
    private final Log.Logger logger;

    public EphemerisValidator(Log.Logger logger) {
        if (logger == null) {
            throw new NullPointerException("Illegal argument - the argument logger cannot be null");
        }
        this.logger = logger;
    }

    public void validateEphemeris(String string, BusinessObject businessObject, ProblemListModel problemListModel, boolean bl) {
        if (string.isEmpty()) {
            if (bl) {
                problemListModel.add(DefaultProblem.createError("No ephemeris has been provided.", "Add an ephemeris generated using the JPL HORIZONS tool.", (IBusinessObject)businessObject));
            } else {
                problemListModel.add(DefaultProblem.createWarning("No ephemeris has been provided", "Add an ephemeris generated using the JPL HORIZONS tool.", (IBusinessObject)businessObject));
            }
        } else {
            Problem problem;
            List list;
            OTHorizonParser oTHorizonParser;
            String string2 = null;
            boolean bl2 = false;
            HorizonParser.HorizonsValueUnitPair horizonsValueUnitPair = null;
            try {
                oTHorizonParser = new OTHorizonParser(new OTLoggerAdapter(this.logger, this.getClass().getName(), null), string);
                assert (oTHorizonParser != null);
                string2 = oTHorizonParser.getCenterSiteName(string);
                bl2 = oTHorizonParser.isEphemerisElevationCutOffSpecified(string);
                horizonsValueUnitPair = oTHorizonParser.getStepSize(string);
                list = oTHorizonParser.parseEphemeris();
            }
            catch (HorizonParser.UnableToParseEphemerisDataException | IOException throwable) {
                Problem problem2 = DefaultProblem.createError("Unable to parse ephemeris", "Verify that the ephemeris is in valid HORIZONS format", (IBusinessObject)businessObject);
                problemListModel.add(problem2);
                return;
            }
            assert (list != null);
            if (list.isEmpty()) {
                problem = DefaultProblem.createError("No ephemeris entries found in ephemeris data.", "Please ensure that there are ephemeris entries in your ephemeris file", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            assert (string2 != null);
            assert (horizonsValueUnitPair != null);
            assert (oTHorizonParser != null);
            if (!horizonsValueUnitPair.getUnits().equals((Object)HorizonParser.HorizonsUnit.MINUTES) || horizonsValueUnitPair.getValue() > 60.0) {
                problem = DefaultProblem.createError("Ephemeris sampling rate is greater than 60 mins", "An ephemeris with entries once every 20 minutes is recommended", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (!string2.equalsIgnoreCase("Atacama Large mm/sub-mm Array (ALMA, center)")) {
                problem = DefaultProblem.createError("Ephemeris should be topocentric", String.format("Center-site keyword should be set to %s", "Atacama Large mm/sub-mm Array (ALMA, center)"), (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (bl2) {
                problem = DefaultProblem.createWarning("Ephemeris should not use an elevation cutoff", "Please submit an ephemeris which does not specify an elevation cutoff", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (oTHorizonParser.getNumberOfHeadersFound() != 4) {
                problem = DefaultProblem.createWarning("Unexpected columns found in ephemeris data", "Ensure that HORIZONS ephemeris data is restricted to \"Astrometric RA & DEC\" and \"Obsrv range & rng rate\"", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }
}

